/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.mana_mote.SpiritMoteBlock;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.SpiritTypeBuilder;
import com.sammy.malum.core.systems.spirit.SpiritVisualMotif;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5251;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class MalumSpiritType {
    public final String identifier;
    public final Supplier<SpiritShardItem> spiritShard;
    private final SpiritVisualMotif visualMotif;
    private final Color itemColor;
    protected class_1814 itemRarity;
    protected class_2561 spiritItemDescription;

    public static SpiritTypeBuilder create(String identifier, SpiritVisualMotif visualMotif, Supplier<SpiritShardItem> spiritShard) {
        return new SpiritTypeBuilder(identifier, visualMotif, spiritShard);
    }

    public MalumSpiritType(String identifier, SpiritVisualMotif visualMotif, Supplier<SpiritShardItem> spiritShard, Color itemColor) {
        this.identifier = identifier;
        this.spiritShard = spiritShard;
        this.visualMotif = visualMotif;
        this.itemColor = itemColor;
    }

    public float getAlphaMultiplier() {
        return this.visualMotif.getAlphaMultiplier();
    }

    public Color getPrimaryColor() {
        return this.visualMotif.getPrimaryColor();
    }

    public Color getSecondaryColor() {
        return this.visualMotif.getSecondaryColor();
    }

    public float getColorCoefficient() {
        return this.visualMotif.getColorCoefficient();
    }

    public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return this.visualMotif.createColorData(coefficientMultiplier);
    }

    public Color getItemColor() {
        return this.itemColor;
    }

    public class_5251 getTextColor(boolean isTooltip) {
        Color color = isTooltip ? ColorHelper.darker((Color)this.getPrimaryColor(), (int)1, (float)0.75f) : ColorHelper.brighter((Color)this.getPrimaryColor(), (int)1, (float)0.85f);
        return class_5251.method_27717((int)color.getRGB());
    }

    public class_1814 getItemRarity() {
        if (this.itemRarity == null) {
            this.itemRarity = class_1814.field_8907;
        }
        return this.itemRarity;
    }

    public class_2561 getSpiritShardFlavourTextComponent() {
        if (this.spiritItemDescription == null) {
            this.spiritItemDescription = class_2561.method_43471((String)this.getSpiritFlavourText()).method_27692(class_124.field_1056).method_27696(class_2583.field_24360.method_27703(this.getTextColor(true)));
        }
        return this.spiritItemDescription;
    }

    public String getSpiritFlavourText() {
        return "malum.spirit.flavour." + this.identifier;
    }

    public class_2561 getSpiritJarCounterComponent(int count) {
        return class_2561.method_43470((String)(" " + count + " ")).method_10852((class_2561)class_2561.method_43471((String)this.getSpiritDescription())).method_27696(class_2583.field_24360.method_36139(this.getPrimaryColor().getRGB()));
    }

    public String getSpiritDescription() {
        return "malum.spirit.description." + this.identifier;
    }

    public class_2960 getTotemGlowTexture() {
        return MalumMod.malumPath("textures/vfx/totem_poles/" + this.identifier + "_glow.png");
    }

    public class_2680 getTotemPoleBlockState(boolean isCorrupt, class_3965 hit) {
        class_2248 base = isCorrupt ? (class_2248)BlockRegistry.SOULWOOD_TOTEM_POLE.get() : (class_2248)BlockRegistry.RUNEWOOD_TOTEM_POLE.get();
        return (class_2680)((class_2680)base.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)hit.method_17780())).method_11657((class_2769)SpiritTypeRegistry.SPIRIT_TYPE_PROPERTY, (Comparable)((Object)this.identifier));
    }

    public class_2680 getSpiritMoteBlockState() {
        return (class_2680)((class_2248)BlockRegistry.SPIRIT_MOTE.get()).method_9564().method_11657((class_2769)SpiritMoteBlock.SPIRIT_TYPE, (Comparable)((Object)this.identifier));
    }
}

