/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1856;
import org.jetbrains.annotations.Nullable;

public class EntitySpiritDropData {
    public static final String SOUL_DATA = "soul_data";
    public static final EntitySpiritDropData EMPTY = new EntitySpiritDropData(SpiritTypeRegistry.SACRED_SPIRIT, new ArrayList<SpiritWithCount>(), null);
    public final MalumSpiritType primaryType;
    public final int totalSpirits;
    public final List<SpiritWithCount> dataEntries;
    @Nullable
    public final class_1856 spiritItem;

    public EntitySpiritDropData(MalumSpiritType primaryType, List<SpiritWithCount> dataEntries, @Nullable class_1856 spiritItem) {
        this.primaryType = primaryType;
        this.totalSpirits = dataEntries.stream().mapToInt(d -> d.count).sum();
        this.dataEntries = dataEntries;
        this.spiritItem = spiritItem;
    }

    public static Builder builder(MalumSpiritType type) {
        return EntitySpiritDropData.builder(type, 1);
    }

    public static Builder builder(MalumSpiritType type, int count) {
        return new Builder(type).withSpirit(type, count);
    }

    public static class Builder {
        private final MalumSpiritType type;
        private final List<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
        private class_1856 spiritItem = null;

        public Builder(MalumSpiritType type) {
            this.type = type;
        }

        public Builder withSpirit(MalumSpiritType spiritType) {
            return this.withSpirit(spiritType, 1);
        }

        public Builder withSpirit(MalumSpiritType spiritType, int count) {
            this.spirits.add(new SpiritWithCount(spiritType, count));
            return this;
        }

        public Builder withSpiritItem(class_1856 spiritItem) {
            this.spiritItem = spiritItem;
            return this;
        }

        public EntitySpiritDropData build() {
            return new EntitySpiritDropData(this.type, this.spirits, this.spiritItem);
        }
    }
}

