/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.recipe;

import com.google.gson.JsonObject;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;

public class SpiritWithCount
implements IRecipeComponent {
    public final MalumSpiritType type;
    public final int count;

    public SpiritWithCount(class_1799 stack) {
        this.type = ((SpiritShardItem)stack.method_7909()).type;
        this.count = stack.method_7947();
    }

    public SpiritWithCount(MalumSpiritType type, int count) {
        this.type = type;
        this.count = count;
    }

    public static SpiritWithCount deserialize(JsonObject inputObject) {
        MalumSpiritType type = SpiritHarvestHandler.getSpiritType(inputObject.get("type").getAsString());
        int count = 1;
        if (inputObject.has("count")) {
            count = inputObject.get("count").getAsInt();
        }
        return new SpiritWithCount(type, count);
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type.identifier);
        if (this.getCount() > 1) {
            object.addProperty("count", (Number)this.getCount());
        }
        return object;
    }

    public class_2561 getComponent() {
        return this.type.getSpiritJarCounterComponent(this.count);
    }

    public class_2487 save(class_2487 tag) {
        tag.method_10582("type", this.type.identifier);
        tag.method_10569("count", this.count);
        return tag;
    }

    public static SpiritWithCount load(class_2487 tag) {
        MalumSpiritType type = SpiritHarvestHandler.getSpiritType(tag.method_10558("type"));
        int count = tag.method_10550("count");
        return new SpiritWithCount(type, count);
    }

    public class_1799 getStack() {
        return new class_1799((class_1935)this.getItem(), this.getCount());
    }

    public List<class_1799> getStacks() {
        return List.of(this.getStack());
    }

    public class_1792 getItem() {
        return this.type.spiritShard.get();
    }

    public int getCount() {
        return this.count;
    }

    public boolean matches(class_1799 stack) {
        return stack.method_7909().equals(this.getItem()) && stack.method_7947() >= this.getCount();
    }
}

