/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class SpiritDataReloadListener
extends class_4309 {
    public static final Map<class_2960, EntitySpiritDropData> SPIRIT_DATA = new HashMap<class_2960, EntitySpiritDropData>();
    public static final Set<class_2960> HAS_NO_DATA = new HashSet<class_2960>();
    public static final EntitySpiritDropData DEFAULT_MONSTER_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.WICKED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_CREATURE_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.SACRED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_AMBIENT_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.AERIAL_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_WATER_CREATURE_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.AQUEOUS_SPIRIT).withSpirit(SpiritTypeRegistry.SACRED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_WATER_AMBIENT_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.AQUEOUS_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_UNDERGROUND_WATER_CREATURE_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.AQUEOUS_SPIRIT).withSpirit(SpiritTypeRegistry.EARTHEN_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_AXOLOTL_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.AQUEOUS_SPIRIT, 2).withSpirit(SpiritTypeRegistry.SACRED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_BOSS_SPIRIT_DATA = EntitySpiritDropData.builder(SpiritTypeRegistry.ELDRITCH_SPIRIT, 2).build();
    private static final Gson GSON = new GsonBuilder().create();

    public SpiritDataReloadListener() {
        super(GSON, "spirit_data/entity");
    }

    protected void apply(Map<class_2960, JsonElement> objectIn, class_3300 resourceManagerIn, class_3695 profilerIn) {
        SPIRIT_DATA.clear();
        HAS_NO_DATA.clear();
        for (JsonElement entry : objectIn.values()) {
            JsonObject object = entry.getAsJsonObject();
            String name = object.getAsJsonPrimitive("registry_name").getAsString();
            class_2960 resourceLocation = new class_2960(name);
            if (!class_7923.field_41177.method_10250(resourceLocation)) continue;
            if (!object.has("primary_type")) {
                MalumMod.LOGGER.info("Entity with registry name: " + name + " lacks a primary spirit type. Skipping file.");
                continue;
            }
            String primaryType = object.getAsJsonPrimitive("primary_type").getAsString();
            boolean isEmpty = primaryType.equals("none");
            if (SPIRIT_DATA.containsKey(resourceLocation)) {
                if (isEmpty) {
                    MalumMod.LOGGER.info("Entity with registry name: " + name + " already has spirit data associated with it. Removing.");
                } else {
                    MalumMod.LOGGER.info("Entity with registry name: " + name + " already has spirit data associated with it. Overwriting.");
                }
            } else if (HAS_NO_DATA.contains(resourceLocation) && !isEmpty) {
                MalumMod.LOGGER.info("Entity with registry name: " + name + " already has empty spirit data associated with it. Overwriting.");
            }
            if (primaryType.equals("none")) {
                SPIRIT_DATA.remove(resourceLocation);
                HAS_NO_DATA.add(resourceLocation);
                continue;
            }
            JsonArray array = object.getAsJsonArray("spirits");
            SPIRIT_DATA.put(resourceLocation, new EntitySpiritDropData(SpiritHarvestHandler.getSpiritType(primaryType), SpiritDataReloadListener.getSpiritData(array), SpiritDataReloadListener.getSpiritItem(object)));
            HAS_NO_DATA.remove(resourceLocation);
        }
    }

    private static List<SpiritWithCount> getSpiritData(JsonArray array) {
        ArrayList<SpiritWithCount> spiritData = new ArrayList<SpiritWithCount>();
        for (JsonElement spiritElement : array) {
            JsonObject spiritObject = spiritElement.getAsJsonObject();
            String spiritName = spiritObject.getAsJsonPrimitive("spirit").getAsString();
            int count = spiritObject.getAsJsonPrimitive("count").getAsInt();
            spiritData.add(new SpiritWithCount(SpiritHarvestHandler.getSpiritType(spiritName), count));
        }
        return spiritData;
    }

    private static class_1856 getSpiritItem(JsonObject object) {
        if (!object.has("spirit_item")) {
            return null;
        }
        try {
            return class_1856.method_52177((JsonElement)object.get("spirit_item"));
        }
        catch (JsonParseException ignored) {
            return null;
        }
    }
}

