/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class ReapingDataReloadListener
extends class_4309 {
    public static Map<class_2960, List<MalumReapingDropsData>> REAPING_DATA = new HashMap<class_2960, List<MalumReapingDropsData>>();
    private static final Gson GSON = new GsonBuilder().create();

    public ReapingDataReloadListener() {
        super(GSON, "reaping_data");
    }

    protected void apply(Map<class_2960, JsonElement> objectIn, class_3300 resourceManagerIn, class_3695 profilerIn) {
        REAPING_DATA.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            class_2960 location = (class_2960)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            String name = object.getAsJsonPrimitive("registry_name").getAsString();
            class_2960 resourceLocation = new class_2960(name);
            if (!class_7923.field_41177.method_10250(resourceLocation)) continue;
            if (REAPING_DATA.containsKey(resourceLocation)) {
                MalumMod.LOGGER.info("Entity with registry name: " + name + " already has reaping data associated with it. Overwriting.");
            }
            JsonArray drops = object.getAsJsonArray("drops");
            ArrayList<MalumReapingDropsData> dropsList = new ArrayList<MalumReapingDropsData>();
            for (JsonElement drop : drops) {
                JsonObject dropObject = drop.getAsJsonObject();
                if (!dropObject.has("ingredient")) {
                    MalumMod.LOGGER.info("Entity with registry name: " + name + " lacks a reaping ingredient. Skipping drops entry.");
                    continue;
                }
                class_1856 dropIngredient = class_1856.method_52177((JsonElement)dropObject.getAsJsonObject("ingredient"));
                float chance = dropObject.getAsJsonPrimitive("chance").getAsFloat();
                int min = dropObject.getAsJsonPrimitive("min").getAsInt();
                int max = dropObject.getAsJsonPrimitive("max").getAsInt();
                dropsList.add(new MalumReapingDropsData(dropIngredient, chance, min, max));
            }
            REAPING_DATA.put(resourceLocation, dropsList);
        }
    }

    public static class MalumReapingDropsData {
        public final class_1856 drop;
        public final float chance;
        public final int min;
        public final int max;

        public MalumReapingDropsData(class_1856 drop, float chance, int min, int max) {
            this.drop = drop;
            this.chance = chance;
            this.min = min;
            this.max = max;
        }
    }
}

