/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class MalignantConversionReloadListener
extends class_4309 {
    public static Map<class_2960, MalignantConversionData> CONVERSION_DATA = new HashMap<class_2960, MalignantConversionData>();
    private static final Gson GSON = new GsonBuilder().create();

    public MalignantConversionReloadListener() {
        super(GSON, "malignant_conversion_data");
    }

    protected void apply(Map<class_2960, JsonElement> objectIn, class_3300 resourceManagerIn, class_3695 profilerIn) {
        CONVERSION_DATA.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            class_2960 location = (class_2960)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            String name = object.getAsJsonPrimitive("source_attribute").getAsString();
            class_2960 sourceAttribute = new class_2960(name);
            if (!class_7923.field_41190.method_10250(sourceAttribute)) continue;
            double consumptionRatio = object.has("ratio") ? object.getAsJsonPrimitive("ratio").getAsDouble() : 1.0;
            JsonArray targetAttributes = object.getAsJsonArray("target_attributes");
            ArrayList<Pair<class_1320, Double>> attributeList = new ArrayList<Pair<class_1320, Double>>();
            for (JsonElement attribute : targetAttributes) {
                JsonObject attributeObject = attribute.getAsJsonObject();
                class_2960 attributeName = new class_2960(attributeObject.getAsJsonPrimitive("attribute").getAsString());
                if (!class_7923.field_41190.method_10250(attributeName)) continue;
                double ratio = attributeObject.getAsJsonPrimitive("ratio").getAsDouble();
                attributeList.add((Pair<class_1320, Double>)Pair.of((Object)((class_1320)class_7923.field_41190.method_10223(attributeName)), (Object)ratio));
            }
            CONVERSION_DATA.put(sourceAttribute, new MalignantConversionData((class_1320)class_7923.field_41190.method_10223(sourceAttribute), consumptionRatio, attributeList));
        }
    }

    public record MalignantConversionData(class_1320 sourceAttribute, double consumptionRatio, List<Pair<class_1320, Double>> targetAttributes) {
    }
}

