/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.hiding.flags;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.sammy.malum.core.handlers.hiding.flags.UncappedFeatureFlag;
import com.sammy.malum.core.handlers.hiding.flags.UncappedFeatureFlagSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_7700;
import org.slf4j.Logger;

public class UncappedFeatureFlagRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_7700 universe;
    private final Map<class_2960, UncappedFeatureFlag> names;
    private final UncappedFeatureFlagSet allFlags;

    public UncappedFeatureFlagRegistry(class_7700 pUniverse, UncappedFeatureFlagSet pAllFlags, Map<class_2960, UncappedFeatureFlag> pNames) {
        this.universe = pUniverse;
        this.names = pNames;
        this.allFlags = pAllFlags;
    }

    public boolean isSubset(UncappedFeatureFlagSet pSet) {
        return pSet.isSubsetOf(this.allFlags);
    }

    public UncappedFeatureFlagSet allFlags() {
        return this.allFlags;
    }

    public UncappedFeatureFlagSet fromNames(Iterable<class_2960> pNames) {
        return this.fromNames(pNames, flag -> LOGGER.warn("Unknown feature flag: {}", flag));
    }

    public UncappedFeatureFlagSet subset(UncappedFeatureFlag ... pFlags) {
        return UncappedFeatureFlagSet.create(this.universe, Arrays.asList(pFlags));
    }

    public UncappedFeatureFlagSet fromNames(Iterable<class_2960> pNames, Consumer<class_2960> pOnError) {
        Set set = Sets.newIdentityHashSet();
        for (class_2960 resourcelocation : pNames) {
            UncappedFeatureFlag featureflag = this.names.get(resourcelocation);
            if (featureflag == null) {
                pOnError.accept(resourcelocation);
                continue;
            }
            set.add(featureflag);
        }
        return UncappedFeatureFlagSet.create(this.universe, set);
    }

    public Set<class_2960> toNames(UncappedFeatureFlagSet pSet) {
        HashSet<class_2960> set = new HashSet<class_2960>();
        this.names.forEach((resourceLocation, featureFlag) -> {
            if (pSet.contains((UncappedFeatureFlag)featureFlag)) {
                set.add((class_2960)resourceLocation);
            }
        });
        return set;
    }

    public Codec<UncappedFeatureFlagSet> codec() {
        return class_2960.field_25139.listOf().comapFlatMap(resourceLocations -> {
            HashSet errorSet = new HashSet();
            UncappedFeatureFlagSet flagSet = this.fromNames((Iterable<class_2960>)resourceLocations, errorSet::add);
            return !errorSet.isEmpty() ? DataResult.error(() -> "Unknown feature ids: " + errorSet, (Object)flagSet) : DataResult.success((Object)flagSet);
        }, flagSet -> List.copyOf(this.toNames((UncappedFeatureFlagSet)flagSet)));
    }

    public static class Builder {
        private final class_7700 universe;
        private int id;
        private final Map<class_2960, UncappedFeatureFlag> flags = new LinkedHashMap<class_2960, UncappedFeatureFlag>();

        public Builder(String pId) {
            this.universe = new class_7700(pId);
        }

        public UncappedFeatureFlag createVanilla(String pId) {
            return this.create(new class_2960("minecraft", pId));
        }

        public UncappedFeatureFlag create(class_2960 pLocation) {
            UncappedFeatureFlag featureflag;
            UncappedFeatureFlag featureflag1;
            if (this.id >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if ((featureflag1 = this.flags.put(pLocation, featureflag = new UncappedFeatureFlag(this.universe, this.id++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + pLocation);
            }
            return featureflag;
        }

        public UncappedFeatureFlagRegistry build() {
            UncappedFeatureFlagSet flagSet = UncappedFeatureFlagSet.create(this.universe, this.flags.values());
            return new UncappedFeatureFlagRegistry(this.universe, flagSet, Map.copyOf(this.flags));
        }
    }
}

