/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.hiding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7696;
import net.minecraft.class_7697;
import net.minecraft.class_7699;

public class HiddenTagHandler {
    private static final Map<class_6862<class_1792>, BooleanSupplier> ITEMS_TO_HIDE = new HashMap<class_6862<class_1792>, BooleanSupplier>();
    private static final HashMap<UUID, Runnable> INVOKED_WHEN_CONDITIONS_CHANGE = new HashMap();
    private static class_7697 FLAGS;
    private static final Map<class_6862<class_1792>, class_7696> FEATURE_FLAGS;

    public static void hideTagWhen(class_6862<class_1792> item, BooleanSupplier condition) {
        ITEMS_TO_HIDE.put(item, condition);
    }

    public static void buildFeatureFlagSet(class_2960 name) {
        class_7697.class_7698 builder = new class_7697.class_7698(name.toString());
        for (class_6862<class_1792> tag : ITEMS_TO_HIDE.keySet()) {
            FEATURE_FLAGS.put(tag, builder.method_45395(tag.comp_327()));
        }
        FLAGS = builder.method_45394();
    }

    public static class_7699 createFeatureFlagSet() {
        HashSet<class_7696> flags = new HashSet<class_7696>();
        for (Map.Entry<class_6862<class_1792>, BooleanSupplier> entry : ITEMS_TO_HIDE.entrySet()) {
            class_7696 flag = FEATURE_FLAGS.get(entry.getKey());
            if (flag == null || entry.getValue().getAsBoolean()) continue;
            flags.add(flag);
        }
        return FLAGS.method_45390(flags.toArray(new class_7696[0]));
    }

    public static class_7699 createAllEnabledFlagSet() {
        return FLAGS.method_45383();
    }

    public static UUID registerHiddenItemListener(Runnable runnable) {
        runnable.run();
        UUID uuid = UUID.randomUUID();
        INVOKED_WHEN_CONDITIONS_CHANGE.put(uuid, runnable);
        return uuid;
    }

    public static void removeListener(UUID listener) {
        INVOKED_WHEN_CONDITIONS_CHANGE.remove(listener);
    }

    public static void conditionsChanged() {
        INVOKED_WHEN_CONDITIONS_CHANGE.values().forEach(Runnable::run);
    }

    public static List<class_6862<class_1792>> tagsToHide() {
        ArrayList<class_6862<class_1792>> tags = new ArrayList<class_6862<class_1792>>();
        for (Map.Entry<class_6862<class_1792>, BooleanSupplier> entry : ITEMS_TO_HIDE.entrySet()) {
            if (!entry.getValue().getAsBoolean()) continue;
            tags.add(entry.getKey());
        }
        return tags;
    }

    static {
        FEATURE_FLAGS = new HashMap<class_6862<class_1792>, class_7696>();
    }
}

