/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sammy.malum.client.VoidRevelationHandler;
import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumLivingEntityDataComponent;
import com.sammy.malum.common.components.MalumPlayerDataComponent;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.packets.VoidRejectionPacket;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.registry.client.ShaderRegistry;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class TouchOfDarknessHandler {
    public static final UUID GRAVITY_MODIFIER_UUID = UUID.fromString("d0aea6b5-f6c5-479d-b70c-455e46a62184");
    public static final float MAX_AFFLICTION = 100.0f;
    public boolean isNearWeepingWell;
    public int weepingWellInfluence;
    public int expectedAffliction;
    public int afflictionDuration;
    public float currentAffliction;
    public int progressToRejection;
    public int rejection;

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10556("isNearWeepingWell", this.isNearWeepingWell);
        tag.method_10569("weepingWellInfluence", this.weepingWellInfluence);
        tag.method_10569("expectedAffliction", this.expectedAffliction);
        tag.method_10569("afflictionDuration", this.afflictionDuration);
        tag.method_10548("currentAffliction", this.currentAffliction);
        tag.method_10569("progressToRejection", this.progressToRejection);
        tag.method_10569("rejection", this.rejection);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.isNearWeepingWell = tag.method_10577("isNearWeepingWell");
        this.weepingWellInfluence = tag.method_10550("weepingWellInfluence");
        this.expectedAffliction = tag.method_10550("expectedAffliction");
        this.afflictionDuration = tag.method_10550("afflictionDuration");
        this.currentAffliction = tag.method_10583("currentAffliction");
        this.progressToRejection = tag.method_10550("progressToRejection");
        this.rejection = tag.method_10550("rejection");
    }

    public static void handlePrimordialSoupContact(class_1309 livingEntity) {
        TouchOfDarknessHandler touchOfDarknessHandler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)livingEntity)).touchOfDarknessHandler;
        if (touchOfDarknessHandler.rejection > 0) {
            return;
        }
        livingEntity.method_18799(livingEntity.method_18798().method_1021((double)0.4f));
        touchOfDarknessHandler.afflict(100);
    }

    public static Optional<VoidConduitBlockEntity> checkForWeepingWell(class_1309 livingEntity) {
        return BlockHelper.getBlockEntitiesStream(VoidConduitBlockEntity.class, (class_1937)livingEntity.method_37908(), (class_2338)livingEntity.method_24515(), (int)8).findFirst();
    }

    public static void entityTick(LivingEntityEvents.LivingTickEvent event) {
        class_1324 gravity;
        class_2248 block;
        boolean isInTheGoop;
        class_1309 livingEntity = event.getEntity();
        class_1937 level = livingEntity.method_37908();
        TouchOfDarknessHandler handler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)livingEntity)).touchOfDarknessHandler;
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (level.method_8510() % 20L == 0L) {
                Optional<VoidConduitBlockEntity> voidConduitBlockEntity = TouchOfDarknessHandler.checkForWeepingWell((class_1309)player);
                handler.isNearWeepingWell = voidConduitBlockEntity.isPresent();
            }
            if (handler.isNearWeepingWell) {
                ++handler.weepingWellInfluence;
            }
        }
        boolean bl = isInTheGoop = (block = level.method_8320(livingEntity.method_24515()).method_26204()) instanceof PrimordialSoupBlock || block instanceof VoidConduitBlock;
        if (!isInTheGoop) {
            block = level.method_8320(livingEntity.method_24515().method_10084()).method_26204();
            boolean bl2 = isInTheGoop = block instanceof PrimordialSoupBlock || block instanceof VoidConduitBlock;
        }
        if (handler.afflictionDuration > 0) {
            --handler.afflictionDuration;
            if (handler.afflictionDuration == 0) {
                handler.expectedAffliction = 0;
            }
        }
        if (handler.currentAffliction < (float)handler.expectedAffliction) {
            handler.currentAffliction = Math.min(100.0f, handler.currentAffliction + 1.5f);
        }
        if (handler.currentAffliction > (float)handler.expectedAffliction) {
            handler.currentAffliction = Math.max(handler.currentAffliction - (handler.expectedAffliction == 0 ? 1.5f : 0.75f), (float)handler.expectedAffliction);
        }
        if ((gravity = livingEntity.method_5996(PortingLibAttributes.ENTITY_GRAVITY)) != null) {
            boolean hasModifier;
            boolean bl3 = hasModifier = gravity.method_6199(GRAVITY_MODIFIER_UUID) != null;
            if (handler.progressToRejection > 0) {
                if (!hasModifier) {
                    gravity.method_26835(TouchOfDarknessHandler.getEntityGravityAttributeModifier(livingEntity));
                }
                gravity.method_26838();
            } else if (hasModifier) {
                gravity.method_6200(GRAVITY_MODIFIER_UUID);
            }
        }
        if (isInTheGoop) {
            class_1657 player;
            if (!(livingEntity instanceof class_1657) || !(player = (class_1657)livingEntity).method_7325()) {
                ++handler.progressToRejection;
                if (!level.field_9236) {
                    if (livingEntity instanceof class_1657 && level.method_8510() % 6L == 0L) {
                        level.method_8396(null, livingEntity.method_24515(), (class_3414)SoundRegistry.SONG_OF_THE_VOID.get(), class_3419.field_15251, 0.5f + (float)handler.progressToRejection * 0.02f, 0.5f + (float)handler.progressToRejection * 0.03f);
                    }
                    if (handler.rejection == 0 && handler.progressToRejection > 60) {
                        handler.reject(livingEntity);
                    }
                }
            }
        } else {
            handler.progressToRejection = 0;
        }
        if (handler.rejection > 0) {
            --handler.rejection;
            float intensity = (float)handler.rejection / 40.0f;
            class_243 movement = livingEntity.method_18798();
            livingEntity.method_18800(movement.field_1352, Math.pow(intensity, 2.0), movement.field_1350);
        }
    }

    public void afflict(int expectedAffliction) {
        if (this.expectedAffliction > expectedAffliction) {
            return;
        }
        this.expectedAffliction = expectedAffliction;
        this.afflictionDuration = 60;
    }

    public void reject(class_1309 livingEntity) {
        if (!(livingEntity instanceof class_1657)) {
            livingEntity.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        MalumPlayerDataComponent playerDataCapability = (MalumPlayerDataComponent)MalumComponents.MALUM_PLAYER_COMPONENT.get((Object)player);
        class_1937 level = livingEntity.method_37908();
        this.progressToRejection = 0;
        this.rejection = 40;
        if (!level.field_9236) {
            PacketRegistry.MALUM_CHANNEL.sendToClientsTrackingAndSelf((S2CPacket)new VoidRejectionPacket(livingEntity.method_5628()), (class_1297)livingEntity);
            Optional<VoidConduitBlockEntity> voidConduitBlockEntity = TouchOfDarknessHandler.checkForWeepingWell(livingEntity);
            if (voidConduitBlockEntity.isPresent()) {
                VoidConduitBlockEntity weepingWell = voidConduitBlockEntity.get();
                class_2338 worldPosition = weepingWell.method_11016();
                ParticleEffectTypeRegistry.WEEPING_WELL_REACTS.createPositionedEffect((class_3218)level, new PositionEffectData((float)worldPosition.method_10263() + 0.5f, (float)worldPosition.method_10264() + 0.6f, (float)worldPosition.method_10260() + 0.5f));
            } else {
                ParticleEffectTypeRegistry.WEEPING_WELL_REACTS.createEntityEffect((class_1297)livingEntity);
            }
            if (!player.method_7337()) {
                livingEntity.method_5643(DamageTypeRegistry.create(level, DamageTypeRegistry.VOODOO), 4.0f);
            }
            if (!playerDataCapability.hasBeenRejected) {
                SpiritHarvestHandler.spawnItemAsSpirit(((SpiritShardItem)((Object)ItemRegistry.UMBRAL_SPIRIT.get())).method_7854(), (class_1309)player, (class_1309)player);
            }
            level.method_8396(null, livingEntity.method_24515(), (class_3414)SoundRegistry.VOID_REJECTION.get(), class_3419.field_15251, 2.0f, class_3532.method_15344((class_5819)livingEntity.method_6051(), (float)0.5f, (float)0.8f));
        } else {
            VoidRevelationHandler.seeTheRevelation(VoidRevelationHandler.RevelationType.BLACK_CRYSTAL);
        }
        playerDataCapability.hasBeenRejected = true;
        livingEntity.method_6092(new class_1293((class_1291)MobEffectRegistry.REJECTED.get(), 400, 0));
    }

    public static class_1322 getEntityGravityAttributeModifier(final class_1309 livingEntity) {
        return new class_1322(GRAVITY_MODIFIER_UUID, "Weeping Well Gravity Modifier", 0.0, class_1322.class_1323.field_6331){

            public double method_6186() {
                return TouchOfDarknessHandler.updateEntityGravity(livingEntity);
            }
        };
    }

    public static double updateEntityGravity(class_1309 livingEntity) {
        TouchOfDarknessHandler handler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)livingEntity)).touchOfDarknessHandler;
        if (handler.progressToRejection > 0) {
            return (float)(-Math.min(60, handler.progressToRejection)) / 60.0f;
        }
        return 0.0;
    }

    public static class ClientOnly {
        private static final class_289 INSTANCE = new class_289();

        public static void renderDarknessVignette(class_332 guiGraphics) {
            class_310 minecraft = class_310.method_1551();
            class_4587 poseStack = guiGraphics.method_51448();
            class_746 player = minecraft.field_1724;
            TouchOfDarknessHandler darknessHandler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)player)).touchOfDarknessHandler;
            if (darknessHandler.currentAffliction == 0.0f) {
                return;
            }
            int screenWidth = minecraft.method_22683().method_4486();
            int screenHeight = minecraft.method_22683().method_4502();
            float effectStrength = Easing.SINE_IN_OUT.ease(darknessHandler.currentAffliction / 100.0f, 0.0f, 1.0f, 1.0f);
            float alpha = Math.min(1.0f, effectStrength * 5.0f);
            float zoom = 0.5f + Math.min(0.35f, effectStrength);
            float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
            ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)ShaderRegistry.TOUCH_OF_DARKNESS.getInstance().get();
            shaderInstance.method_35785("Speed").method_1251(1000.0f);
            Consumer<Float> setZoom = f -> shaderInstance.method_35785("Zoom").method_1251(f.floatValue());
            Consumer<Float> setIntensity = f -> shaderInstance.method_35785("Intensity").method_1251(f.floatValue());
            VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexDefaultFormat().setPositionWithWidth(0.0f, 0.0f, (float)screenWidth, (float)screenHeight).overrideBufferBuilder(INSTANCE.method_1349()).setColor(0.0f, 0.0f, 0.0f).setAlpha(alpha).setShader(ShaderRegistry.TOUCH_OF_DARKNESS.getInstance());
            poseStack.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            setZoom.accept(Float.valueOf(zoom));
            setIntensity.accept(Float.valueOf(intensity));
            builder.draw(poseStack);
            setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
            setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
            builder.setAlpha(0.5f * alpha).draw(poseStack);
            RenderSystem.disableBlend();
            poseStack.method_22909();
            shaderInstance.setUniformDefaults();
        }
    }
}

