/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumLivingEntityDataComponent;
import com.sammy.malum.common.container.SpiritPouchContainer;
import com.sammy.malum.common.entity.spirit.SpiritItemEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.curiosities.SpiritPouchItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.AttributeRegistry;
import com.sammy.malum.registry.common.DamageTypeTagRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.container.ItemInventory;

public class SpiritHarvestHandler {
    public static boolean shatterSoul(class_1309 target, class_1282 source, float v) {
        class_1309 attacker = null;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 directAttacker;
            attacker = directAttacker = (class_1309)class_12972;
        }
        if (attacker == null) {
            attacker = target.method_6065();
        }
        if (attacker == null && source.method_48789(DamageTypeTagRegistry.SOUL_SHATTER_DAMAGE)) {
            SpiritHarvestHandler.spawnSpirits(target);
            return true;
        }
        if (attacker != null) {
            class_1799 stack = SoulDataHandler.getSoulHunterWeapon(source, attacker);
            if (!(target instanceof class_1657)) {
                SoulDataHandler soulData = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)target)).soulData;
                if (((Boolean)CommonConfig.SOULLESS_SPAWNERS.getConfigValue()).booleanValue() && soulData.spawnerSpawned) {
                    return true;
                }
                if (soulData.exposedSoulDuration > 0.0f && !soulData.soulless) {
                    SpiritHarvestHandler.spawnSpirits(target, attacker, stack);
                    soulData.soulless = true;
                }
            }
        }
        return true;
    }

    public static boolean modifyDroppedItems(class_1309 entityLiving, class_1282 damageSource, Collection<class_1542> itemEntities, int i, boolean b) {
        MalumLivingEntityDataComponent capability = (MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)entityLiving);
        if (capability.soulsToApplyToDrops != null) {
            SpiritHarvestHandler.getSpiritData(entityLiving).ifPresent(spiritData -> {
                class_1856 spiritItem = spiritData.spiritItem;
                if (spiritItem != null) {
                    for (class_1542 itemEntity : itemEntities) {
                        if (!spiritItem.method_8093(itemEntity.method_6983())) continue;
                        MalumComponents.MALUM_ITEM_COMPONENT.maybeGet((Object)itemEntity).ifPresent(e -> {
                            e.soulsToDrop = capability.soulsToApplyToDrops.stream().map(class_1799::method_7972).collect(Collectors.toList());
                            e.attackerForSouls = capability.killerUUID;
                            e.totalSoulCount = spiritData.totalSpirits;
                        });
                        itemEntity.method_6989();
                        itemEntity.field_7204 = 5980;
                        itemEntity.method_5875(true);
                        itemEntity.method_18799(itemEntity.method_18798().method_18805(1.0, 0.5, 1.0));
                    }
                }
            });
        }
        return false;
    }

    public static int shatterItem(class_1542 entity, class_1799 itemStack) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            MalumComponents.MALUM_ITEM_COMPONENT.maybeGet((Object)entity).ifPresent(e -> {
                class_1297 patt5032$temp;
                class_1309 attacker = null;
                if (e.attackerForSouls != null && (patt5032$temp = level.method_14190(e.attackerForSouls)) instanceof class_1309) {
                    class_1309 living;
                    attacker = living = (class_1309)patt5032$temp;
                }
                if (e.soulsToDrop != null) {
                    ArrayList<class_1799> stacks = new ArrayList<class_1799>();
                    for (int i = 0; i < entity.method_6983().method_7947(); ++i) {
                        e.soulsToDrop.stream().map(class_1799::method_7972).forEach(stacks::add);
                    }
                    SpiritHarvestHandler.createSpiritEntities((class_1937)level, stacks, entity.method_19538(), e.totalSoulCount, attacker);
                }
            });
        }
        return -1;
    }

    public static void pickupSpirit(class_1309 collector, class_1799 stack) {
        if (collector instanceof class_1657) {
            class_1657 player = (class_1657)collector;
            class_1324 instance = player.method_5996((class_1320)AttributeRegistry.ARCANE_RESONANCE.get());
            ItemHelper.getEventResponders((class_1309)collector).forEach(s -> {
                class_1792 patt5954$temp = s.method_7909();
                if (patt5954$temp instanceof IMalumEventResponderItem) {
                    IMalumEventResponderItem eventItem = (IMalumEventResponderItem)patt5954$temp;
                    eventItem.pickupSpirit(collector, instance != null ? instance.method_6194() : 0.0);
                }
            });
            for (class_2371 playerInventory : player.method_31548().field_7543) {
                for (class_1799 item : playerInventory) {
                    ItemInventory inventory;
                    class_1799 result;
                    if (!(item.method_7909() instanceof SpiritPouchItem) || !(result = (inventory = SpiritPouchItem.getInventory(item)).method_5491(stack)).method_7960()) continue;
                    class_1937 level = player.method_37908();
                    level.method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
                    class_1703 class_17032 = player.field_7512;
                    if (class_17032 instanceof SpiritPouchContainer) {
                        SpiritPouchContainer pouchMenu = (SpiritPouchContainer)class_17032;
                        pouchMenu.update(inventory);
                    }
                    return;
                }
            }
        }
        ItemHelper.giveItemToEntity((class_1309)collector, (class_1799)stack);
    }

    public static void spawnSpirits(class_1309 target) {
        SpiritHarvestHandler.spawnSpirits(SpiritHarvestHandler.getSpiritDropsRaw(target), target, null);
    }

    public static void spawnSpirits(class_1309 target, class_1309 attacker, class_1799 harvestStack) {
        SpiritHarvestHandler.spawnSpirits(SpiritHarvestHandler.getSpawnedSpirits(target, attacker, harvestStack), target, attacker);
    }

    public static void spawnSpirits(List<class_1799> spirits, class_1309 target, class_1309 attacker) {
        if (spirits.isEmpty()) {
            return;
        }
        SpiritHarvestHandler.getSpiritData(target).ifPresent(data -> {
            if (data.spiritItem != null) {
                MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.maybeGet((Object)target).ifPresent(e -> {
                    e.soulsToApplyToDrops = spirits;
                    if (attacker != null) {
                        e.killerUUID = attacker.method_5667();
                    }
                });
            } else {
                SpiritHarvestHandler.spawnItemsAsSpirits(spirits, target, attacker);
            }
        });
    }

    public static void spawnItemAsSpirit(class_1799 spirit, class_1309 target, class_1309 attacker) {
        SpiritHarvestHandler.spawnItemsAsSpirits(List.of(spirit), target, attacker);
    }

    public static void spawnItemsAsSpirits(Collection<class_1799> spirits, class_1309 target, class_1309 attacker) {
        SpiritHarvestHandler.createSpiritEntities(target.method_37908(), spirits, target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0), spirits.stream().mapToInt(class_1799::method_7947).sum(), attacker);
    }

    private static void createSpiritEntities(class_1937 level, Collection<class_1799> spirits, class_243 position, float totalCount, @Nullable class_1309 attacker) {
        if (attacker == null) {
            attacker = level.method_8604(position.field_1352, position.field_1351, position.field_1350, 8.0, e -> true);
        }
        UUID attackerUUID = attacker == null ? null : attacker.method_5667();
        float speed = 0.15f + 0.25f / (totalCount + 1.0f);
        class_5819 random = level.field_9229;
        for (class_1799 stack : spirits) {
            if (stack.method_7960()) continue;
            boolean noFancySpirits = (Boolean)CommonConfig.NO_FANCY_SPIRITS.getConfigValue();
            for (int j = 0; j < stack.method_7947(); ++j) {
                if (noFancySpirits) {
                    class_1542 itemEntity = new class_1542(level, position.field_1352, position.field_1351, position.field_1350, stack);
                    itemEntity.method_6988();
                    itemEntity.method_18800((double)class_3532.method_15344((class_5819)random, (float)-0.1f, (float)0.1f), (double)class_3532.method_15344((class_5819)random, (float)0.25f, (float)0.5f), (double)class_3532.method_15344((class_5819)random, (float)-0.1f, (float)0.1f));
                    level.method_8649((class_1297)itemEntity);
                    continue;
                }
                SpiritItemEntity entity = new SpiritItemEntity(level, attackerUUID, ItemHelper.copyWithNewCount((class_1799)stack, (int)1), position.field_1352, position.field_1351, position.field_1350, RandomHelper.randomBetween((class_5819)random, (float)(-speed), (float)speed), RandomHelper.randomBetween((class_5819)random, (float)0.05f, (float)0.06f), RandomHelper.randomBetween((class_5819)random, (float)(-speed), (float)speed));
                level.method_8649((class_1297)entity);
            }
        }
        level.method_43128(null, position.field_1352, position.field_1351, position.field_1350, (class_3414)SoundRegistry.SOUL_SHATTER.get(), class_3419.field_15248, 1.0f, 0.7f + random.method_43057() * 0.4f);
    }

    public static List<class_1799> getSpawnedSpirits(class_1309 entity, class_1309 attacker, class_1799 harvestStack) {
        return SpiritHarvestHandler.getSpiritData(entity).map(data -> SpiritHarvestHandler.applySpiritLootBonuses(SpiritHarvestHandler.getSpiritDropsRaw(data), attacker, harvestStack)).orElse(Collections.emptyList());
    }

    public static List<class_1799> applySpiritLootBonuses(List<class_1799> spirits, class_1309 attacker, class_1799 weapon) {
        if (spirits.isEmpty()) {
            return spirits;
        }
        int spiritBonus = 0;
        if (attacker.method_5996((class_1320)AttributeRegistry.SPIRIT_SPOILS.get()) != null) {
            spiritBonus = (int)((double)spiritBonus + attacker.method_26825((class_1320)AttributeRegistry.SPIRIT_SPOILS.get()));
        }
        if (!weapon.method_7960()) {
            int spiritPlunder = class_1890.method_8225((class_1887)((class_1887)EnchantmentRegistry.SPIRIT_PLUNDER.get()), (class_1799)weapon);
            if (spiritPlunder > 0) {
                weapon.method_7956(spiritPlunder, attacker, e -> e.method_20235(class_1304.field_6173));
            }
            spiritBonus += spiritPlunder;
        }
        for (int i = 0; i < spiritBonus; ++i) {
            int random = attacker.method_6051().method_43048(spirits.size());
            spirits.get(random).method_7933(1);
        }
        return spirits;
    }

    public static List<class_1799> getSpiritDropsRaw(class_1309 entity) {
        return SpiritHarvestHandler.getSpiritData(entity).map(SpiritHarvestHandler::getSpiritDropsRaw).orElse(Collections.emptyList());
    }

    public static List<class_1799> getSpiritDropsRaw(EntitySpiritDropData data) {
        return data != null ? data.dataEntries.stream().map(SpiritWithCount::getStack).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static Optional<EntitySpiritDropData> getSpiritData(class_1309 entity) {
        class_2960 key = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (SpiritDataReloadListener.HAS_NO_DATA.contains(key)) {
            return Optional.empty();
        }
        EntitySpiritDropData spiritData = SpiritDataReloadListener.SPIRIT_DATA.get(key);
        if (spiritData != null) {
            return Optional.of(spiritData);
        }
        if (!entity.method_5822()) {
            return Optional.of(SpiritDataReloadListener.DEFAULT_BOSS_SPIRIT_DATA);
        }
        if (!((Boolean)CommonConfig.USE_DEFAULT_SPIRIT_VALUES.getConfigValue()).booleanValue()) {
            return Optional.empty();
        }
        return switch (entity.method_5864().method_5891()) {
            case class_1311.field_6302 -> Optional.of(SpiritDataReloadListener.DEFAULT_MONSTER_SPIRIT_DATA);
            case class_1311.field_6294 -> Optional.of(SpiritDataReloadListener.DEFAULT_CREATURE_SPIRIT_DATA);
            case class_1311.field_6303 -> Optional.of(SpiritDataReloadListener.DEFAULT_AMBIENT_SPIRIT_DATA);
            case class_1311.field_34447 -> Optional.of(SpiritDataReloadListener.DEFAULT_AXOLOTL_SPIRIT_DATA);
            case class_1311.field_30092 -> Optional.of(SpiritDataReloadListener.DEFAULT_UNDERGROUND_WATER_CREATURE_SPIRIT_DATA);
            case class_1311.field_6300 -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_CREATURE_SPIRIT_DATA);
            case class_1311.field_24460 -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_AMBIENT_SPIRIT_DATA);
            default -> Optional.empty();
        };
    }

    public static MalumSpiritType getSpiritType(String spirit) {
        return SpiritTypeRegistry.SPIRITS.getOrDefault(spirit, SpiritTypeRegistry.SACRED_SPIRIT);
    }
}

