/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumPlayerDataComponent;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.AttributeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import net.minecraft.class_1041;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class SoulWardHandler {
    public float soulWard;
    public float soulWardProgress;

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10548("soulWard", this.soulWard);
        tag.method_10548("soulWardProgress", this.soulWardProgress);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.soulWard = tag.method_10583("soulWard");
        this.soulWardProgress = tag.method_10583("soulWardProgress");
    }

    public static void recoverSoulWard(class_1657 player) {
        if (!player.method_37908().field_9236) {
            SoulWardHandler soulWardHandler = ((MalumPlayerDataComponent)MalumComponents.MALUM_PLAYER_COMPONENT.get((Object)player)).soulWardHandler;
            class_1324 soulWardCap = player.method_5996((class_1320)AttributeRegistry.SOUL_WARD_CAP.get());
            if (soulWardCap != null) {
                if ((double)soulWardHandler.soulWard < soulWardCap.method_6194() && soulWardHandler.soulWardProgress <= 0.0f) {
                    soulWardHandler.soulWard += 1.0f;
                    if (!player.method_7337()) {
                        class_3414 sound = (double)soulWardHandler.soulWard >= soulWardCap.method_6194() ? (class_3414)SoundRegistry.SOUL_WARD_CHARGE.get() : (class_3414)SoundRegistry.SOUL_WARD_GROW.get();
                        float pitch = 1.0f + soulWardHandler.soulWard / (float)soulWardCap.method_6194() * 0.5f + (float)(class_3532.method_15386((float)soulWardHandler.soulWard) % 3) * 0.25f;
                        player.method_37908().method_8396(null, player.method_24515(), sound, class_3419.field_15248, 0.25f, pitch);
                    }
                    soulWardHandler.soulWardProgress = SoulWardHandler.getSoulWardCooldown(player);
                    MalumComponents.MALUM_PLAYER_COMPONENT.sync((Object)player);
                } else {
                    soulWardHandler.soulWardProgress -= 1.0f;
                }
                if ((double)soulWardHandler.soulWard > soulWardCap.method_6194()) {
                    soulWardHandler.soulWard = (float)soulWardCap.method_6194();
                    MalumComponents.MALUM_PLAYER_COMPONENT.sync((Object)player);
                }
            }
        }
    }

    public static void shieldPlayer(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!player.method_37908().field_9236) {
                SoulWardHandler soulWardHandler = ((MalumPlayerDataComponent)MalumComponents.MALUM_PLAYER_COMPONENT.get((Object)player)).soulWardHandler;
                soulWardHandler.soulWardProgress = SoulWardHandler.getSoulWardCooldown(0.0) + SoulWardHandler.getSoulWardCooldown(player);
                if (soulWardHandler.soulWard > 0.0f) {
                    class_1282 source = event.getSource();
                    float amount = event.getAmount();
                    float multiplier = source.method_48789(LodestoneDamageTypeTags.IS_MAGIC) ? ((Double)CommonConfig.SOUL_WARD_MAGIC.getConfigValue()).floatValue() : ((Double)CommonConfig.SOUL_WARD_PHYSICAL.getConfigValue()).floatValue();
                    for (class_1799 s : ItemHelper.getEventResponders((class_1309)player)) {
                        class_1792 class_17922 = s.method_7909();
                        if (!(class_17922 instanceof IMalumEventResponderItem)) continue;
                        IMalumEventResponderItem eventItem = (IMalumEventResponderItem)class_17922;
                        multiplier = eventItem.overrideSoulwardDamageAbsorbPercentage(event, (class_1309)player, s, multiplier);
                        break;
                    }
                    float result = amount * multiplier;
                    float absorbed = amount - result;
                    double strength = 1.0 + player.method_26825((class_1320)AttributeRegistry.SOUL_WARD_STRENGTH.get());
                    float soulwardLost = (float)((double)soulWardHandler.soulWard - (double)absorbed / strength);
                    if (strength != 0.0) {
                        soulWardHandler.soulWard = Math.max(0.0f, soulwardLost);
                    } else {
                        soulwardLost = soulWardHandler.soulWard;
                        soulWardHandler.soulWard = 0.0f;
                    }
                    for (class_1799 s : ItemHelper.getEventResponders((class_1309)player)) {
                        class_1792 class_17923 = s.method_7909();
                        if (!(class_17923 instanceof IMalumEventResponderItem)) continue;
                        IMalumEventResponderItem eventItem = (IMalumEventResponderItem)class_17923;
                        eventItem.onSoulwardAbsorbDamage(event, player, s, soulwardLost, absorbed);
                    }
                    class_3414 sound = soulWardHandler.soulWard == 0.0f ? (class_3414)SoundRegistry.SOUL_WARD_DEPLETE.get() : (class_3414)SoundRegistry.SOUL_WARD_HIT.get();
                    player.method_37908().method_8396(null, player.method_24515(), sound, player.method_5634(), 1.0f, class_3532.method_15344((class_5819)player.method_6051(), (float)1.0f, (float)1.5f));
                    event.setAmount(result);
                    MalumComponents.MALUM_PLAYER_COMPONENT.sync((Object)player);
                }
            }
        }
    }

    public static int getSoulWardCooldown(class_1657 player) {
        return SoulWardHandler.getSoulWardCooldown(player.method_26825((class_1320)AttributeRegistry.SOUL_WARD_RECOVERY_RATE.get()));
    }

    public static int getSoulWardCooldown(double recoverySpeed) {
        int baseValue = (Integer)CommonConfig.SOUL_WARD_RATE.getConfigValue();
        if (recoverySpeed == 0.0) {
            return baseValue;
        }
        float n = 0.6f;
        double exponent = 1.0 + (Math.pow(recoverySpeed * 0.25 + 1.0, 1.0f - n) - 1.0) / (double)(1.0f - n);
        return (int)((double)baseValue * (1.0 / exponent));
    }

    public static class ClientOnly {
        public static void renderSoulWard(class_332 guiGraphics, class_1041 window) {
            class_746 player;
            class_310 minecraft = class_310.method_1551();
            class_4587 poseStack = guiGraphics.method_51448();
            if (!(minecraft.field_1690.field_1842 || (player = minecraft.field_1724).method_7337() || player.method_7325())) {
                SoulWardHandler soulWardHandler = ((MalumPlayerDataComponent)MalumComponents.MALUM_PLAYER_COMPONENT.get((Object)player)).soulWardHandler;
                float soulWard = soulWardHandler.soulWard;
                if (soulWard > 0.0f) {
                    float absorb = class_3532.method_15386((float)player.method_6067());
                    float maxHealth = (float)player.method_5996(class_5134.field_23716).method_6194();
                    float armor = (float)player.method_5996(class_5134.field_23724).method_6194();
                    int left = window.method_4486() / 2 - 91;
                    int top = window.method_4502() - 59;
                    if (armor == 0.0f) {
                        top += 4;
                    }
                    int healthRows = class_3532.method_15386((float)((maxHealth + absorb) / 2.0f / 10.0f));
                    int rowHeight = Math.max(10 - (healthRows - 2), 3);
                    poseStack.method_22903();
                    RenderSystem.setShaderTexture((int)0, (class_2960)ClientOnly.getSoulWardTexture());
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
                    shaderInstance.method_35785("YFrequency").method_1251(15.0f);
                    shaderInstance.method_35785("XFrequency").method_1251(15.0f);
                    shaderInstance.method_35785("Speed").method_1251(550.0f);
                    shaderInstance.method_35785("Intensity").method_1251(120.0f);
                    VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexDefaultFormat().setShader(() -> shaderInstance);
                    int size = 13;
                    boolean forceDisplay = soulWard <= 1.0f;
                    double soulWardAmount = forceDisplay ? 1.0 : Math.ceil(Math.floor(soulWard) / 3.0);
                    int i = 0;
                    while ((double)i < soulWardAmount) {
                        int row = (int)((float)i / 10.0f);
                        int x = left + i % 10 * 8;
                        int y = top - row * 4 + rowHeight * 2 - 15;
                        int progress = Math.min(3, (int)soulWard - i * 3);
                        int xTextureOffset = forceDisplay ? 31 : 1 + (3 - progress) * 15;
                        shaderInstance.method_35785("UVCoordinates").method_35652(new Vector4f((float)xTextureOffset / 45.0f, (float)(xTextureOffset + size) / 45.0f, 0.0f, 0.33333334f));
                        shaderInstance.method_35785("TimeOffset").method_1251((float)i * 150.0f);
                        builder.setPositionWithWidth((float)(x - 2), (float)(y - 2), (float)size, (float)size).setUVWithWidth((float)xTextureOffset, 0.0f, (float)size, (float)size, 45.0f).draw(poseStack);
                        ++i;
                    }
                    shaderInstance.setUniformDefaults();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.disableBlend();
                    poseStack.method_22909();
                }
            }
        }

        public static class_2960 getSoulWardTexture() {
            return MalumMod.malumPath("textures/gui/soul_ward/default.png");
        }
    }
}

