/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumLivingEntityDataComponent;
import com.sammy.malum.common.entity.boomerang.ScytheBoomerangEntity;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1338;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1389;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3730;

public class SoulDataHandler {
    public float exposedSoulDuration;
    public boolean soulless;
    public boolean spawnerSpawned;

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.exposedSoulDuration != 0.0f) {
            tag.method_10548("exposedSoulDuration", this.exposedSoulDuration);
        }
        tag.method_10556("soulless", this.soulless);
        tag.method_10556("spawnerSpawned", this.spawnerSpawned);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.exposedSoulDuration = tag.method_10583("exposedSoulDuration");
        this.soulless = tag.method_10577("soulless");
        this.spawnerSpawned = tag.method_10577("spawnerSpawned");
    }

    public static boolean markAsSpawnerSpawned(class_1308 mob, class_1936 levelAccessor, double v, double v1, double v2, class_1917 baseSpawner, class_3730 mobSpawnType) {
        if (baseSpawner != null && mobSpawnType == class_3730.field_16469) {
            MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.maybeGet((Object)mob).ifPresent(ec -> {
                SoulDataHandler soulData = ec.soulData;
                soulData.spawnerSpawned = true;
            });
        }
        return true;
    }

    public static boolean updateAi(class_1297 entity, class_1937 level, boolean b) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.maybeGet((Object)livingEntity).ifPresent(ec -> {
                SoulDataHandler soulData = ec.soulData;
                if (livingEntity instanceof class_1308) {
                    class_1308 mob = (class_1308)livingEntity;
                    if (soulData.soulless) {
                        SoulDataHandler.removeSentience(mob);
                    }
                }
            });
        }
        return true;
    }

    public static void preventTargeting(class_1309 targeting, class_1309 target) {
        if (targeting instanceof class_1308) {
            class_1308 mob = (class_1308)targeting;
            MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.maybeGet((Object)mob).ifPresent(ec -> {
                SoulDataHandler soulData = ec.soulData;
                if (soulData.soulless) {
                    // empty if block
                }
            });
        }
    }

    public static void exposeSoul(LivingHurtEvent event) {
        class_1309 attacker;
        class_1799 stack;
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        class_1309 target = event.getEntity();
        class_1282 source = event.getSource();
        SoulDataHandler soulData = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)target)).soulData;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (stack = SoulDataHandler.getSoulHunterWeapon(source, attacker = (class_1309)class_12972)).method_31573(ItemTagRegistry.SOUL_HUNTER_WEAPON)) {
            soulData.exposedSoulDuration = 200.0f;
        }
        if (source.method_5526() != null && source.method_5526().method_5752().contains("malum:soul_arrow")) {
            soulData.exposedSoulDuration = 200.0f;
        }
    }

    public static void manageSoul(LivingEntityEvents.LivingTickEvent event) {
        class_1309 entity = event.getEntity();
        SoulDataHandler soulData = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)entity)).soulData;
        if (soulData.exposedSoulDuration > 0.0f) {
            soulData.exposedSoulDuration -= 1.0f;
        }
    }

    public static void removeSentience(class_1308 mob) {
        mob.field_6201.method_35115().removeIf(g -> g.method_19058() instanceof class_1361 || g.method_19058() instanceof class_1366 || g.method_19058() instanceof class_1389 || g.method_19058() instanceof class_1374 || g.method_19058() instanceof class_1376 || g.method_19058() instanceof class_1338);
    }

    public static class_1799 getSoulHunterWeapon(class_1282 source, class_1309 attacker) {
        class_1799 stack = attacker.method_6047();
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof ScytheBoomerangEntity) {
            ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)class_12972;
            stack = scytheBoomerang.method_7495();
        }
        return stack;
    }
}

