/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.datafixers.util.Pair;
import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumLivingEntityDataComponent;
import com.sammy.malum.core.listeners.MalignantConversionReloadListener;
import com.sammy.malum.registry.common.AttributeRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5131;
import net.minecraft.class_5819;

public class MalignantConversionHandler {
    private static final UUID MALIGNANT_CONVERSION_UUID = UUID.fromString("ff803d68-a615-4279-a59a-d847db2481d7");
    public static final HashMap<class_1320, UUID> MODIFIER_UUIDS = new HashMap();
    public final HashMap<class_1320, Double> cachedAttributeValues = new HashMap();
    public boolean skipConversionLogic;

    public static void checkForAttributeChanges(LivingEntityEvents.LivingTickEvent event) {
        class_1309 livingEntity = event.getEntity();
        if (!livingEntity.method_37908().field_9236) {
            MalignantConversionHandler handler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)livingEntity)).malignantConversionHandler;
            class_1320 conversionAttribute = (class_1320)AttributeRegistry.MALIGNANT_CONVERSION.get();
            class_1324 conversionInstance = livingEntity.method_5996(conversionAttribute);
            if (conversionInstance != null) {
                if (handler.skipConversionLogic) {
                    if (conversionInstance.method_6194() == 0.0) {
                        return;
                    }
                    handler.skipConversionLogic = false;
                }
                Map<class_2960, MalignantConversionReloadListener.MalignantConversionData> conversionData = MalignantConversionReloadListener.CONVERSION_DATA;
                for (MalignantConversionReloadListener.MalignantConversionData data : conversionData.values()) {
                    class_1320 attribute = data.sourceAttribute();
                    class_1324 instance = livingEntity.method_5996(attribute);
                    if (instance == null || !handler.cachedAttributeValues.containsKey(attribute)) continue;
                    MalignantConversionHandler.convertAttribute(livingEntity, data.sourceAttribute(), data.consumptionRatio(), data.targetAttributes());
                }
                if (handler.cachedAttributeValues.containsKey(conversionAttribute) && handler.cachedAttributeValues.get(conversionAttribute).doubleValue() != conversionInstance.method_6194()) {
                    for (MalignantConversionReloadListener.MalignantConversionData data : conversionData.values()) {
                        MalignantConversionHandler.convertAttribute(livingEntity, data.sourceAttribute(), data.consumptionRatio(), data.targetAttributes(), true);
                    }
                }
                handler.cachedAttributeValues.put(conversionAttribute, conversionInstance.method_6194());
                if (conversionInstance.method_6194() == 0.0) {
                    handler.skipConversionLogic = true;
                }
            }
        }
    }

    private static void convertAttribute(class_1309 livingEntity, class_1320 sourceAttribute, double consumptionRatio, List<Pair<class_1320, Double>> targetAttributes) {
        MalignantConversionHandler.convertAttribute(livingEntity, sourceAttribute, consumptionRatio, targetAttributes, false);
    }

    private static void convertAttribute(class_1309 livingEntity, class_1320 sourceAttribute, double consumptionRatio, List<Pair<class_1320, Double>> targetAttributes, boolean skipCacheComparison) {
        class_5131 attributes = livingEntity.method_6127();
        double malignantConversion = attributes.method_26852((class_1320)AttributeRegistry.MALIGNANT_CONVERSION.get());
        class_1324 sourceInstance = livingEntity.method_5996(sourceAttribute);
        if (sourceInstance != null) {
            MalignantConversionHandler handler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)livingEntity)).malignantConversionHandler;
            class_1322 originalModifier = sourceInstance.method_6199(MALIGNANT_CONVERSION_UUID);
            if (originalModifier != null) {
                sourceInstance.method_6202(originalModifier);
            }
            if (skipCacheComparison || handler.cachedAttributeValues.get(sourceAttribute).doubleValue() != sourceInstance.method_6194()) {
                double cachedValue = sourceInstance.method_6194();
                for (Pair<class_1320, Double> target : targetAttributes) {
                    class_1320 targetAttribute = (class_1320)target.getFirst();
                    class_1324 targetInstance = livingEntity.method_5996(targetAttribute);
                    if (targetInstance == null) continue;
                    UUID uuid = MODIFIER_UUIDS.computeIfAbsent(sourceAttribute, a -> class_3532.method_15378((class_5819)class_5819.method_43053()));
                    targetInstance.method_6200(uuid);
                    double bonus = cachedValue * malignantConversion * (Double)target.getSecond();
                    if (!(bonus > 0.0)) continue;
                    targetInstance.method_26835(new class_1322(uuid, "Malignant Conversion: " + class_2561.method_43471((String)targetAttribute.method_26830()), bonus, class_1322.class_1323.field_6328));
                }
                handler.cachedAttributeValues.put(sourceAttribute, sourceInstance.method_6194());
                if (malignantConversion > 0.0) {
                    sourceInstance.method_26835(new class_1322(MALIGNANT_CONVERSION_UUID, "Malignant Conversion: " + class_2561.method_43471((String)sourceAttribute.method_26830()), -malignantConversion * consumptionRatio, class_1322.class_1323.field_6331));
                }
            }
            if (originalModifier != null && sourceInstance.method_6199(MALIGNANT_CONVERSION_UUID) == null && malignantConversion > 0.0) {
                sourceInstance.method_26835(originalModifier);
            }
        }
    }
}

