/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.emi.recipes;

import com.google.common.collect.Lists;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.compability.emi.EMIHandler;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

public class SpiritRepairEmiRecipe
implements EmiRecipe {
    private static final class_2960 BACKGROUND_LOCATION = MalumMod.malumPath("textures/gui/spirit_repair_jei.png");
    private final SpiritRepairRecipe recipe;
    private final List<EmiIngredient> inputs;
    private final EmiIngredient damaged;
    private final EmiIngredient repairIngredient;
    private final List<EmiIngredient> spirits;
    private final List<EmiStack> outputs;
    private final EmiIngredient repaired;

    public SpiritRepairEmiRecipe(SpiritRepairRecipe recipe) {
        this.recipe = recipe;
        this.inputs = Lists.newArrayList();
        this.outputs = recipe.inputs.stream().map(r -> EmiStack.of((class_1799)r.method_7854())).toList();
        this.damaged = EmiIngredient.of(this.outputs.stream().map(EmiStack::getItemStack).map(class_1799::method_7972).peek(s -> s.method_7974((int)((float)s.method_7936() * recipe.durabilityPercentage))).map(s -> EmiIngredient.of((class_1856)class_1856.method_8101((class_1799[])new class_1799[]{s}))).toList());
        this.inputs.add(this.damaged);
        this.repairIngredient = EMIHandler.convertIngredientWithCount(recipe.repairMaterial);
        this.inputs.add(this.repairIngredient);
        this.spirits = EMIHandler.convertSpiritWithCounts(recipe.spirits);
        this.inputs.addAll(this.spirits);
        this.repaired = EmiIngredient.of(this.outputs.stream().map(EmiStack::getItemStack).map(SpiritRepairRecipe::getRepairRecipeOutput).map(EmiStack::of).toList());
    }

    public EmiRecipeCategory getCategory() {
        return EMIHandler.SPIRIT_REPAIR;
    }

    public class_2960 getId() {
        return this.recipe.method_8114();
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 142;
    }

    public int getDisplayHeight() {
        return 185;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND_LOCATION, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 0, 0);
        widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mx, my, d) -> {
            if (!this.spirits.isEmpty()) {
                ArcanaCodexHelper.renderItemFrames(guiGraphics.method_51448(), this.spirits.size(), 61, 12, false);
            }
        });
        EMIHandler.addItems(widgets, 61, 12, false, this.spirits);
        widgets.addSlot(this.damaged, 81, 56).drawBack(false);
        widgets.addSlot(this.repairIngredient, 43, 56).drawBack(false);
        widgets.addSlot(this.repaired, 62, 123).recipeContext((EmiRecipe)this).drawBack(false);
    }
}

