/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.emi;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.compability.emi.recipes.RuneworkingEmiRecipe;
import com.sammy.malum.compability.emi.recipes.SpiritFocusingEmiRecipe;
import com.sammy.malum.compability.emi.recipes.SpiritInfusionEmiRecipe;
import com.sammy.malum.compability.emi.recipes.SpiritRepairEmiRecipe;
import com.sammy.malum.compability.emi.recipes.SpiritRiteEmiRecipe;
import com.sammy.malum.compability.emi.recipes.SpiritTransmutationEmiRecipe;
import com.sammy.malum.compability.emi.recipes.SpiritTransmutationRecipeWrapper;
import com.sammy.malum.compability.emi.recipes.WeepingWellEmiRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.SpiritRiteRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_3956;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class EMIHandler
implements EmiPlugin {
    private static final EmiStack SPIRIT_INFUSION_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.SPIRIT_ALTAR.get()));
    public static final EmiRecipeCategory SPIRIT_INFUSION = new EmiRecipeCategory(MalumMod.malumPath("spirit_infusion"), (EmiRenderable)SPIRIT_INFUSION_WORKSTATION);
    private static final EmiStack SPIRIT_FOCUSING_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.SPIRIT_CRUCIBLE.get()));
    public static final EmiRecipeCategory SPIRIT_FOCUSING = new EmiRecipeCategory(MalumMod.malumPath("spirit_focusing"), (EmiRenderable)SPIRIT_FOCUSING_WORKSTATION);
    private static final EmiStack SPIRIT_TRANSMUTATION_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.SOULWOOD_TOTEM_BASE.get()));
    public static final EmiRecipeCategory SPIRIT_TRANSMUTATION = new EmiRecipeCategory(MalumMod.malumPath("spirit_transmutation"), (EmiRenderable)SPIRIT_TRANSMUTATION_WORKSTATION);
    private static final EmiStack SPIRIT_RITE_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.RUNEWOOD_TOTEM_BASE.get()));
    public static final EmiRecipeCategory SPIRIT_RITE = new EmiRecipeCategory(MalumMod.malumPath("spirit_rite"), (EmiRenderable)SPIRIT_RITE_WORKSTATION);
    private static final EmiStack SPIRIT_REPAIR_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.REPAIR_PYLON.get()));
    public static final EmiRecipeCategory SPIRIT_REPAIR = new EmiRecipeCategory(MalumMod.malumPath("spirit_repair"), (EmiRenderable)SPIRIT_REPAIR_WORKSTATION);
    private static final EmiStack RUNEWORKING_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.RUNIC_WORKBENCH.get()));
    public static final EmiRecipeCategory RUNEWORKING = new EmiRecipeCategory(MalumMod.malumPath("runeworking"), (EmiRenderable)RUNEWORKING_WORKSTATION);
    private static final EmiStack WEEPING_WORKSTATION = EmiStack.of((class_1935)((class_1935)ItemRegistry.VOID_DEPOT.get()));
    public static final EmiRecipeCategory WEEPING = new EmiRecipeCategory(MalumMod.malumPath("weeping_well"), (EmiRenderable)WEEPING_WORKSTATION);

    private <C extends class_1263, R extends class_1860<C>, E extends EmiRecipe> void registerRecipeTypeCategory(EmiRegistry registry, EmiRecipeCategory category, EmiStack workstation) {
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)workstation);
    }

    private <C extends class_1263, R extends class_1860<C>, E extends EmiRecipe> void registerRecipeType(EmiRegistry registry, EmiRecipeCategory category, EmiStack workstation, class_3956<R> type, Function<R, E> builder) {
        this.registerRecipeTypeCategory(registry, category, workstation);
        registry.getRecipeManager().method_30027(type).forEach(recipe -> registry.addRecipe((EmiRecipe)builder.apply(recipe)));
    }

    public void register(EmiRegistry registry) {
        this.registerRecipeType(registry, SPIRIT_INFUSION, SPIRIT_INFUSION_WORKSTATION, (class_3956)RecipeTypeRegistry.SPIRIT_INFUSION.get(), SpiritInfusionEmiRecipe::new);
        this.registerRecipeType(registry, SPIRIT_FOCUSING, SPIRIT_FOCUSING_WORKSTATION, (class_3956)RecipeTypeRegistry.SPIRIT_FOCUSING.get(), SpiritFocusingEmiRecipe::new);
        this.registerRecipeType(registry, RUNEWORKING, RUNEWORKING_WORKSTATION, (class_3956)RecipeTypeRegistry.RUNEWORKING.get(), RuneworkingEmiRecipe::new);
        this.registerRecipeType(registry, WEEPING, WEEPING_WORKSTATION, (class_3956)RecipeTypeRegistry.VOID_FAVOR.get(), WeepingWellEmiRecipe::new);
        this.registerRecipeTypeCategory(registry, SPIRIT_TRANSMUTATION, SPIRIT_TRANSMUTATION_WORKSTATION);
        List transmutation = registry.getRecipeManager().method_30027((class_3956)RecipeTypeRegistry.SPIRIT_TRANSMUTATION.get());
        ArrayList leftovers = Lists.newArrayList();
        LinkedHashMap groups = Maps.newLinkedHashMap();
        transmutation.forEach(recipe -> {
            if (recipe.group != null) {
                List group = groups.computeIfAbsent(recipe.group, k -> Lists.newArrayList());
                group.add(recipe);
            } else {
                leftovers.add(recipe);
            }
        });
        groups.values().stream().map(SpiritTransmutationRecipeWrapper::new).forEach(recipe -> registry.addRecipe((EmiRecipe)new SpiritTransmutationEmiRecipe((SpiritTransmutationRecipeWrapper)recipe)));
        leftovers.stream().map(List::of).map(SpiritTransmutationRecipeWrapper::new).forEach(recipe -> registry.addRecipe((EmiRecipe)new SpiritTransmutationEmiRecipe((SpiritTransmutationRecipeWrapper)recipe)));
        this.registerRecipeTypeCategory(registry, SPIRIT_RITE, SPIRIT_RITE_WORKSTATION);
        SpiritRiteRegistry.RITES.forEach(rite -> registry.addRecipe((EmiRecipe)new SpiritRiteEmiRecipe((TotemicRiteType)rite)));
        this.registerRecipeType(registry, SPIRIT_REPAIR, SPIRIT_REPAIR_WORKSTATION, (class_3956)RecipeTypeRegistry.SPIRIT_REPAIR.get(), SpiritRepairEmiRecipe::new);
        this.removeHiddenRecipes(registry);
    }

    private void removeHiddenRecipes(EmiRegistry registry) {
    }

    public static void addItems(WidgetHolder widgets, int left, int top, boolean vertical, List<EmiIngredient> ingredients) {
        int slots = ingredients.size();
        if (vertical) {
            top -= 10 * (slots - 1);
        } else {
            left -= 10 * (slots - 1);
        }
        for (int i = 0; i < slots; ++i) {
            int offset = i * 20;
            int offsetLeft = left + 1 + (vertical ? 0 : offset);
            int offsetTop = top + 1 + (vertical ? offset : 0);
            widgets.addSlot(ingredients.get(i), offsetLeft, offsetTop).drawBack(false);
        }
    }

    public static EmiIngredient convertIngredientWithCount(IngredientWithCount ingredient) {
        return EmiIngredient.of((class_1856)ingredient.ingredient, (long)ingredient.count);
    }

    public static List<EmiIngredient> convertIngredientWithCounts(List<IngredientWithCount> ingredients) {
        return ingredients.stream().map(EMIHandler::convertIngredientWithCount).toList();
    }

    public static EmiIngredient convertSpiritWithCount(SpiritWithCount spirit) {
        return EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)spirit.type.spiritShard.get()}), (long)spirit.count);
    }

    public static List<EmiIngredient> convertSpiritWithCounts(List<SpiritWithCount> spirits) {
        return spirits.stream().map(EMIHandler::convertSpiritWithCount).toList();
    }
}

