/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.sammy.malum.common.block.blight.ClingingBlightBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeFeature;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.registry.common.block.BlockTagRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2919;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3543;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5821;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class SoulwoodTreeFeature
extends class_3031<class_3111> {
    public static final LodestoneBlockFiller.LodestoneLayerToken LOGS = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken HANGING_LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken BLIGHT = new LodestoneBlockFiller.LodestoneLayerToken();
    private static final class_3543 BLIGHT_NOISE = new class_3543((class_5819)new class_2919((class_5819)new class_5820(1234L)), (List)ImmutableList.of((Object)0));

    public SoulwoodTreeFeature() {
        super(class_3111.field_24893);
    }

    private static class_2680 makeClingingBlight(ClingingBlightBlock.BlightType blightType, class_2350 direction) {
        return (class_2680)((class_2680)((class_2248)BlockRegistry.CLINGING_BLIGHT.get()).method_9564().method_11657(ClingingBlightBlock.BLIGHT_TYPE, (Comparable)((Object)blightType))).method_11657((class_2769)class_2741.field_12481, (Comparable)direction);
    }

    private int getSapBlockCount(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)5, (int)7);
    }

    private int getTrunkHeight(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)10, (int)15);
    }

    private int getTwistCooldown(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)3, (int)5);
    }

    private int getTrunkTwistAmount(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)2, (int)6);
    }

    private int getSideTrunkHeight(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)1, (int)3);
    }

    private int getDownwardsBranchOffset(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)2, (int)4);
    }

    private int getBranchLength(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)3, (int)5);
    }

    private int getBranchTwistAmount(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)0, (int)2);
    }

    private int getBranchHeight(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)5, (int)6);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        int i;
        Object direction;
        class_2338 pos;
        class_5281 level = context.method_33652();
        if (level.method_22347((pos = context.method_33655()).method_10074()) || !((class_2248)BlockRegistry.SOULWOOD_GROWTH.get()).method_9564().method_26184((class_4538)level, pos)) {
            return false;
        }
        class_5819 rand = context.method_33654();
        ArrayList<Pair> validSoulwoodSpikePositions = new ArrayList<Pair>();
        class_2680 logState = ((class_2248)BlockRegistry.SOULWOOD_LOG.get()).method_9564();
        class_2680 blightedLogState = ((class_2248)BlockRegistry.BLIGHTED_SOULWOOD.get()).method_9564();
        LodestoneBlockFiller filler = new LodestoneBlockFiller().addLayers(new LodestoneBlockFiller.LodestoneLayerToken[]{LOGS, LEAVES, HANGING_LEAVES, BLIGHT});
        int sapBlockCount = this.getSapBlockCount(rand);
        int trunkHeight = this.getTrunkHeight(rand);
        int twistCooldown = this.getTwistCooldown(rand);
        int twistDirectionIndex = rand.method_43048(WorldgenHelper.DIRECTIONS.length);
        int remainingTwists = this.getTrunkTwistAmount(rand);
        int twistCutoffPoint = trunkHeight - 5;
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)pos);
        for (int i2 = 0; i2 <= trunkHeight; ++i2) {
            int j;
            if (i2 < twistCutoffPoint) {
                for (j = 0; j < 4; ++j) {
                    direction = class_2350.method_10139((int)j);
                    validSoulwoodSpikePositions.add(Pair.of((Object)direction.method_10153(), (Object)mutable.method_10093((class_2350)direction)));
                }
                if (twistCooldown == 0 && remainingTwists != 0) {
                    class_2350 twistDirection = class_2350.method_10139((int)(twistDirectionIndex % 4));
                    if (rand.method_43057() < 0.75f) {
                        ++twistDirectionIndex;
                    }
                    if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                        return false;
                    }
                    filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
                    filler.getLayer(BLIGHT).put(mutable.method_10084(), LodestoneBlockFiller.create((class_2680)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.ROOTED_BLIGHT, twistDirection)));
                    mutable.method_10098(twistDirection);
                    twistCooldown = this.getTwistCooldown(rand);
                    --remainingTwists;
                }
            }
            if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                return false;
            }
            for (j = 0; j < 4; ++j) {
                direction = class_2350.method_10139((int)j);
                validSoulwoodSpikePositions.add(Pair.of((Object)direction.method_10153(), (Object)mutable.method_10093((class_2350)direction)));
            }
            filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)(i2 == 0 ? blightedLogState : logState)));
            mutable.method_10098(class_2350.field_11036);
            --twistCooldown;
        }
        class_2338 trunkTop = mutable.method_10062();
        for (i = 0; i < 4; ++i) {
            direction = class_2350.method_10139((int)i);
            int sideTrunkHeight = this.getSideTrunkHeight(rand);
            mutable.method_10101((class_2382)pos).method_10098((class_2350)direction);
            class_2338 trunkBottom = this.addDownwardsTrunkConnections(logState, level, filler, (class_2338)mutable);
            for (int j = 0; j < sideTrunkHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
                mutable.method_10098(class_2350.field_11036);
            }
            filler.getLayer(LOGS).put(trunkBottom, LodestoneBlockFiller.create((class_2680)blightedLogState));
            filler.getLayer(BLIGHT).put(trunkBottom.method_10093((class_2350)direction), LodestoneBlockFiller.create((class_2680)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.ROOTED_BLIGHT, direction.method_10153())));
        }
        for (i = 0; i < 4; ++i) {
            int j;
            direction = class_2350.method_10139((int)i);
            int downwardsBranchOffset = this.getDownwardsBranchOffset(rand);
            int branchLength = this.getBranchLength(rand);
            int branchHeight = this.getBranchHeight(rand);
            remainingTwists = this.getBranchTwistAmount(rand);
            twistCooldown = 1;
            mutable.method_10101((class_2382)trunkTop);
            mutable.method_10104(class_2350.field_11033, downwardsBranchOffset);
            for (j = 1; j < branchLength; ++j) {
                mutable.method_10098((class_2350)direction);
                if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                    return false;
                }
                class_2350.class_2351 axis = direction.method_10166();
                if (twistCooldown <= 0) {
                    filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)((class_2680)logState.method_11657((class_2769)class_2465.field_11459, (Comparable)axis))));
                    mutable.method_10098(class_2350.field_11036);
                    twistCooldown = this.getTwistCooldown(rand);
                    --remainingTwists;
                }
                boolean start = j == 1;
                class_2350 opposite = direction.method_10153();
                filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)((class_2680)logState.method_11657((class_2769)class_2465.field_11459, (Comparable)axis))));
                filler.getLayer(BLIGHT).put(mutable.method_10074(), LodestoneBlockFiller.create((class_2680)SoulwoodTreeFeature.makeClingingBlight(start ? ClingingBlightBlock.BlightType.HANGING_BLIGHT : ClingingBlightBlock.BlightType.HANGING_ROOTS, opposite)));
                if (start) {
                    filler.getLayer(BLIGHT).put(mutable.method_10087(2), LodestoneBlockFiller.create((class_2680)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.HANGING_BLIGHT_CONNECTION, opposite)));
                }
                if (remainingTwists <= 0) continue;
                --twistCooldown;
            }
            for (j = 0; j < branchHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
                mutable.method_10098(class_2350.field_11036);
            }
            SoulwoodTreeFeature.makeLeafBlob(filler, rand, (class_2338)mutable.method_10104(class_2350.field_11033, branchHeight - 1));
        }
        SoulwoodTreeFeature.makeLeafBlob(filler, rand, (class_2338)mutable.method_10101((class_2382)trunkTop));
        SoulwoodTreeFeature.generateBlight((class_5425)level, filler, pos.method_10074(), 8);
        ArrayList sapBlockPositions = new ArrayList(filler.getLayer(LOGS).keySet());
        Collections.shuffle(sapBlockPositions);
        for (class_2338 blockPos : sapBlockPositions.subList(0, sapBlockCount)) {
            LodestoneBlockFiller.BlockStateEntry entry = (LodestoneBlockFiller.BlockStateEntry)filler.getLayer(LOGS).get((Object)blockPos);
            if (entry.getState().method_26204().equals(BlockRegistry.BLIGHTED_SOULWOOD.get())) continue;
            filler.getLayer(LOGS).replace(blockPos, e -> LodestoneBlockFiller.create((class_2680)BlockHelper.getBlockStateWithExistingProperties((class_2680)e.getState(), (class_2680)((class_2248)BlockRegistry.EXPOSED_SOULWOOD_LOG.get()).method_9564())).build());
        }
        int spikeCount = 6;
        Collections.shuffle(validSoulwoodSpikePositions);
        for (Pair entry : validSoulwoodSpikePositions) {
            class_2338 entryPos = (class_2338)entry.getSecond();
            if (filler.getLayer(BLIGHT).containsKey((Object)entryPos)) continue;
            filler.getLayer(BLIGHT).put(entryPos, LodestoneBlockFiller.create((class_2680)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.SOULWOOD_SPIKE, (class_2350)entry.getFirst())));
            if (spikeCount == 0) break;
            --spikeCount;
        }
        filler.fill((class_1936)level);
        WorldgenHelper.updateLeaves((class_1936)level, filler.getLayer(LOGS).keySet());
        return true;
    }

    public class_2338 addDownwardsTrunkConnections(class_2680 logState, class_5281 level, LodestoneBlockFiller filler, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        while (true) {
            mutable.method_10098(class_2350.field_11033);
            if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                return mutable.method_10084();
            }
            filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
        }
    }

    public static void makeLeafBlob(LodestoneBlockFiller filler, class_5819 rand, class_2338 pos) {
        int color;
        int size;
        int i;
        class_2338.class_2339 mutable = pos.method_25503();
        int[] leafSizes = new int[]{1, 2, 3, 3, 3, 2, 1};
        int[] leafColors = new int[]{4, 3, 2, 1, 2, 3, 4};
        for (i = 0; i < 7; ++i) {
            size = leafSizes[i];
            color = leafColors[i];
            SoulwoodTreeFeature.makeLeafSlice(filler, rand, mutable, size, color, false);
            mutable.method_10098(class_2350.field_11036);
        }
        mutable.method_10104(class_2350.field_11033, 7);
        for (i = 0; i < 3; ++i) {
            size = leafSizes[i];
            color = leafColors[i];
            SoulwoodTreeFeature.makeLeafSlice(filler, rand, mutable, size, color, true);
            mutable.method_10098(class_2350.field_11036);
        }
    }

    public static void makeLeafSlice(LodestoneBlockFiller filler, class_5819 rand, class_2338.class_2339 pos, int leavesSize, int leavesColor, boolean makeHangingLeaves) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            int offsetColor = leavesColor + class_3532.method_15395((class_5819)rand, (int)(leavesColor == 0 ? 0 : -1), (int)(leavesColor == 4 ? 0 : 1));
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                class_2338 leavesPos = pos.method_10069(x, 0, z);
                if (makeHangingLeaves && (x != 0 || z != 0)) {
                    if (!(rand.method_43057() < 0.4f + (float)leavesSize * 0.2f)) continue;
                    int length = leavesSize - 2 + RandomHelper.randomBetween((class_5819)rand, (int)0, (int)leavesSize);
                    if (length < 2) {
                        length -= 2;
                    }
                    if (length < 2) continue;
                    int spawnHeight = rand.method_43048(2);
                    class_2338.class_2339 hangingLeavesPos = leavesPos.method_25503().method_10104(class_2350.field_11036, spawnHeight);
                    for (int i = -spawnHeight; i <= length; ++i) {
                        int gradient = class_3532.method_15340((int)(leavesColor + 1 + i), (int)0, (int)4);
                        class_2338 vinePos = hangingLeavesPos.method_10098(class_2350.field_11033).method_10062();
                        boolean hanging = i == length;
                        class_2248 block = (class_2248)(hanging ? BlockRegistry.HANGING_SOULWOOD_LEAVES : BlockRegistry.BUDDING_SOULWOOD_LEAVES).get();
                        LodestoneBlockFiller.BlockStateEntryBuilder entry = LodestoneBlockFiller.create((class_2680)((class_2680)block.method_9564().method_11657((class_2769)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(gradient))));
                        if (hanging) {
                            entry.setDiscardPredicate((l, p, s) -> !filler.getLayer(LEAVES).containsKey((Object)p.method_10084()) || filler.getLayer(LOGS).containsKey((Object)p.method_10084()));
                        }
                        filler.getLayer(hanging ? HANGING_LEAVES : LEAVES).put((Object)vinePos, (Object)entry.build());
                    }
                    continue;
                }
                filler.getLayer(LEAVES).put(leavesPos, LodestoneBlockFiller.create((class_2680)((class_2680)((class_2248)BlockRegistry.SOULWOOD_LEAVES.get()).method_9564().method_11657((class_2769)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(offsetColor)))));
            }
        }
    }

    public static Map<Integer, Double> generateBlight(class_5425 level, LodestoneBlockFiller filler, class_2338 pos, int radius) {
        HashMap<Integer, Double> noiseValues = new HashMap<Integer, Double>();
        for (int i = 0; i <= 360; ++i) {
            noiseValues.put(i, BLIGHT_NOISE.method_16451((double)((float)(pos.method_10263() + pos.method_10260()) + (float)i * 0.02f), (double)((float)pos.method_10264() / 0.05f), true) * 2.5);
        }
        SoulwoodTreeFeature.generateBlight(level, filler, noiseValues, pos, radius);
        return noiseValues;
    }

    public static void generateBlight(class_5425 level, LodestoneBlockFiller filler, Map<Integer, Double> noiseValues, class_2338 pos, int radius) {
        SoulwoodTreeFeature.generateBlight(level, filler, pos, radius * 2, radius, noiseValues);
        filler.fill((class_1936)level);
    }

    public static void generateBlight(class_5425 level, LodestoneBlockFiller filler, class_2338 center, int coverage, int radius, Map<Integer, Double> noiseValues) {
        int x = center.method_10263();
        int z = center.method_10260();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int saplingsPlaced = 0;
        class_243 lastSaplingPos = null;
        for (int i = 0; i < coverage * 2 + 1; ++i) {
            for (int j = 0; j < coverage * 2 + 1; ++j) {
                class_5819 random;
                class_2680 plantState;
                int floor;
                int xp = x + i - coverage;
                int zp = z + j - coverage;
                blockPos.method_10103(xp, center.method_10264(), zp);
                double theta = 180.0 + 57.29577951308232 * Math.atan2(x - xp, z - zp);
                double naturalNoiseValue = noiseValues.get(class_3532.method_15357((double)theta));
                if (naturalNoiseValue > 1.0) {
                    naturalNoiseValue *= naturalNoiseValue;
                }
                if (!((double)(floor = (int)Math.floor(SoulwoodTreeFeature.pointDistancePlane(xp, zp, x, z))) <= (double)radius + Math.floor(naturalNoiseValue) - 1.0)) continue;
                int verticalRange = 4;
                for (int i1 = 0; level.method_16358((class_2338)blockPos, s -> !s.method_26215()) && i1 < verticalRange; ++i1) {
                    blockPos.method_10098(class_2350.field_11036);
                }
                for (int k = 0; level.method_16358((class_2338)blockPos, class_4970.class_4971::method_26215) && k < verticalRange; ++k) {
                    blockPos.method_10098(class_2350.field_11033);
                }
                while (!(plantState = level.method_8320((class_2338)blockPos)).method_26215() && !plantState.method_26164(BlockTagRegistry.BLIGHTED_PLANTS) && (plantState.method_45474() || plantState.method_26164(class_3481.field_44471) || plantState.method_26164(class_3481.field_20339))) {
                    class_2338 immutable = blockPos.method_10062();
                    if (!filler.getLayer(BLIGHT).containsKey((Object)blockPos)) {
                        filler.getLayer(BLIGHT).put(immutable, LodestoneBlockFiller.create((class_2680)class_2246.field_10124.method_9564()).setForcePlace());
                    }
                    blockPos.method_10098(class_2350.field_11033);
                }
                if (!level.method_8320((class_2338)blockPos).method_26164(class_3481.field_28622)) continue;
                filler.getLayer(BLIGHT).put(blockPos.method_10062(), LodestoneBlockFiller.create((class_2680)((class_2248)BlockRegistry.BLIGHTED_SOIL.get()).method_9564()).setForcePlace());
                if (level.method_8320((class_2338)blockPos.method_10100(0, -1, 0)).method_26164(class_3481.field_29822)) {
                    filler.getLayer(BLIGHT).put(blockPos.method_10062(), LodestoneBlockFiller.create((class_2680)((class_2248)BlockRegistry.BLIGHTED_EARTH.get()).method_9564()).setForcePlace());
                }
                if (!((random = level.method_8409()).method_43057() < 0.75f)) continue;
                class_2338 plantPos = blockPos.method_10069(0, 2, 0);
                class_2680 blockState = level.method_8320(plantPos);
                if (naturalNoiseValue > 2.5 && (lastSaplingPos == null || lastSaplingPos.method_1028((double)plantPos.method_10263(), (double)plantPos.method_10264(), (double)plantPos.method_10260()) > 5.0) && BlockHelper.fromBlockPos((class_2338)center).method_1028((double)plantPos.method_10263(), (double)plantPos.method_10264(), (double)plantPos.method_10260()) > 4.0 && (double)random.method_43057() < 0.5 / Math.pow(saplingsPlaced + 1, 2.0)) {
                    filler.getLayer(BLIGHT).put(plantPos, LodestoneBlockFiller.create((class_2680)((class_2248)BlockRegistry.SOULWOOD_GROWTH.get()).method_9564()));
                    lastSaplingPos = new class_243((double)plantPos.method_10263(), (double)plantPos.method_10264(), (double)plantPos.method_10260());
                    ++saplingsPlaced;
                }
                if (filler.getLayer(BLIGHT).containsKey((Object)plantPos)) continue;
                class_2680 state = ((class_2248)BlockRegistry.BLIGHTED_GROWTH.get()).method_9564();
                if (random.method_43057() < 0.4f) {
                    state = (class_2680)((class_2680)((class_2248)BlockRegistry.CLINGING_BLIGHT.get()).method_9564().method_11657(ClingingBlightBlock.BLIGHT_TYPE, (Comparable)((Object)ClingingBlightBlock.BlightType.GROUNDED_ROOTS))).method_11657((class_2769)class_2741.field_12481, (Comparable)WorldgenHelper.DIRECTIONS[random.method_43048(4)]);
                }
                if (!blockState.method_26215() && !blockState.method_45474() || blockState.method_26164(BlockTagRegistry.BLIGHTED_PLANTS)) continue;
                filler.getLayer(BLIGHT).put(plantPos, LodestoneBlockFiller.create((class_2680)state));
            }
        }
    }

    public static float pointDistancePlane(double x1, double z1, double x2, double z2) {
        return (float)Math.hypot(x1 - x2, z1 - z2);
    }
}

