/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.tree;

import com.sammy.malum.common.block.blight.BlightedGrowthBlock;
import com.sammy.malum.common.block.nature.MalumHangingLeavesBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.common.block.nature.MalumSaplingBlock;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeConfiguration;
import com.sammy.malum.registry.common.block.BlockRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class RunewoodTreeFeature
extends class_3031<RunewoodTreeConfiguration> {
    public static final LodestoneBlockFiller.LodestoneLayerToken LOGS = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken HANGING_LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();

    public RunewoodTreeFeature() {
        super(RunewoodTreeConfiguration.CODEC);
    }

    private int getSapBlockCount(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)2, (int)3);
    }

    private int getTrunkHeight(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)7, (int)10);
    }

    private int getSideTrunkHeight(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)0, (int)2);
    }

    private int getDownwardsBranchOffset(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)2, (int)4);
    }

    private int getBranchLength(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)2, (int)3);
    }

    private int getBranchHeight(class_5819 random) {
        return class_3532.method_15395((class_5819)random, (int)3, (int)5);
    }

    public boolean method_13151(class_5821<RunewoodTreeConfiguration> context) {
        class_2350 direction;
        int i;
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        RunewoodTreeConfiguration config = (RunewoodTreeConfiguration)context.method_33656();
        if (level.method_22347(pos.method_10074()) || !config.sapling.method_9564().method_26184((class_4538)level, pos)) {
            return false;
        }
        class_5819 rand = context.method_33654();
        class_2248 log = config.log;
        class_2680 logState = log.method_9564();
        LodestoneBlockFiller filler = new LodestoneBlockFiller().addLayers(new LodestoneBlockFiller.LodestoneLayerToken[]{LOGS, LEAVES, HANGING_LEAVES});
        int sapBlockCount = this.getSapBlockCount(rand);
        int trunkHeight = this.getTrunkHeight(rand);
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)pos);
        for (i = 0; i <= trunkHeight; ++i) {
            if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                return false;
            }
            filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
            mutable.method_10098(class_2350.field_11036);
        }
        for (i = 0; i < 4; ++i) {
            direction = class_2350.method_10139((int)i);
            int sideTrunkHeight = this.getSideTrunkHeight(rand);
            if (sideTrunkHeight == 0) continue;
            mutable.method_10101((class_2382)pos).method_10098(direction);
            this.addDownwardsTrunkConnections(logState, level, filler, (class_2338)mutable);
            for (int j = 0; j < sideTrunkHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
                mutable.method_10098(class_2350.field_11036);
            }
        }
        for (i = 0; i < 4; ++i) {
            int j;
            direction = class_2350.method_10139((int)i);
            int downwardsBranchOffset = this.getDownwardsBranchOffset(rand);
            int branchLength = this.getBranchLength(rand);
            int branchHeight = this.getBranchHeight(rand);
            mutable.method_10101((class_2382)pos);
            mutable.method_10104(class_2350.field_11036, trunkHeight - downwardsBranchOffset);
            for (j = 0; j < branchLength; ++j) {
                mutable.method_10098(direction);
                if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)((class_2680)logState.method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()))));
            }
            for (j = 0; j < branchHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
                mutable.method_10098(class_2350.field_11036);
            }
            this.makeLeafBlob(config, filler, (class_2338)mutable.method_10104(class_2350.field_11033, branchHeight));
        }
        this.makeLeafBlob(config, filler, (class_2338)mutable.method_10101((class_2382)pos).method_10104(class_2350.field_11036, trunkHeight - 1));
        ArrayList sapBlockPositions = new ArrayList(filler.getLayer(LOGS).keySet());
        Collections.shuffle(sapBlockPositions);
        for (class_2338 blockPos : sapBlockPositions.subList(0, sapBlockCount)) {
            filler.getLayer(LOGS).replace(blockPos, e -> LodestoneBlockFiller.create((class_2680)BlockHelper.getBlockStateWithExistingProperties((class_2680)e.getState(), (class_2680)((class_2248)BlockRegistry.EXPOSED_RUNEWOOD_LOG.get()).method_9564())).build());
        }
        filler.fill((class_1936)level);
        WorldgenHelper.updateLeaves((class_1936)level, filler.getLayer(LOGS).keySet());
        return true;
    }

    public void addDownwardsTrunkConnections(class_2680 logState, class_5281 level, LodestoneBlockFiller filler, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        while (true) {
            mutable.method_10098(class_2350.field_11033);
            if (!RunewoodTreeFeature.canPlace(level, (class_2338)mutable)) break;
            filler.getLayer(LOGS).put(mutable.method_10062(), LodestoneBlockFiller.create((class_2680)logState));
        }
    }

    public void makeLeafBlob(RunewoodTreeConfiguration config, LodestoneBlockFiller filler, class_2338 pos) {
        int i;
        int[] leafSizes = new int[]{1, 2, 2, 2, 1};
        int[] leafColors = new int[]{0, 1, 2, 3, 4};
        class_2338.class_2339 mutable = pos.method_25503();
        class_2680 leavesState = config.leaves.method_9564();
        class_2680 hangingLeavesState = config.hangingLeaves.method_9564();
        for (i = 0; i < 5; ++i) {
            mutable.method_10098(class_2350.field_11036);
            LodestoneBlockFiller.BlockStateEntry leavesEntry = LodestoneBlockFiller.create((class_2680)((class_2680)leavesState.method_11657((class_2769)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(leafColors[i])))).build();
            this.makeLeafSlice(filler.getLayer(LEAVES), (class_2338)mutable, leafSizes[i], leavesEntry);
        }
        mutable.method_10101((class_2382)pos).method_10098(class_2350.field_11033);
        for (i = 0; i < 2; ++i) {
            mutable.method_10098(class_2350.field_11036);
            LodestoneBlockFiller.BlockStateEntry hangingLeavesEntry = LodestoneBlockFiller.create((class_2680)((class_2680)hangingLeavesState.method_11657((class_2769)MalumHangingLeavesBlock.COLOR, (Comparable)Integer.valueOf(leafColors[i])))).setDiscardPredicate((l, p, s) -> !filler.getLayer(LEAVES).containsKey((Object)p.method_10084())).build();
            this.makeLeafSlice(filler.getLayer(HANGING_LEAVES), (class_2338)mutable, leafSizes[i], hangingLeavesEntry);
        }
    }

    public void makeLeafSlice(LodestoneBlockFiller.LodestoneBlockFillerLayer layer, class_2338 pos, int leavesSize, LodestoneBlockFiller.BlockStateEntry entry) {
        this.makeLeafSlice(layer, pos, leavesSize, () -> entry);
    }

    public void makeLeafSlice(LodestoneBlockFiller.LodestoneBlockFillerLayer layer, class_2338 pos, int leavesSize, Supplier<LodestoneBlockFiller.BlockStateEntry> entry) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                layer.put((Object)pos.method_10069(x, 0, z), (Object)entry.get());
            }
        }
    }

    public static boolean canPlace(class_5281 level, class_2338 pos) {
        if (level.method_31606(pos)) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        return state.method_26204() instanceof MalumSaplingBlock || state.method_26204() instanceof BlightedGrowthBlock || level.method_22347(pos) || state.method_45474();
    }
}

