/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.registry.common.worldgen.StructureRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class WeepingWellStructure
extends class_3195 {
    public static final Codec<WeepingWellStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeepingWellStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.fieldOf("size").forGetter(provider -> provider.size), (App)Codec.INT.fieldOf("min_y").forGetter(provider -> provider.min), (App)Codec.INT.fieldOf("max_y").forGetter(provider -> provider.max), (App)Codec.INT.fieldOf("offset_in_ground").forGetter(provider -> provider.offsetInGround), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, WeepingWellStructure::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final int min;
    private final int max;
    private final int offsetInGround;
    private final int maxDistanceFromCenter;

    public WeepingWellStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, int min, int max, int offsetInGround, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.min = min;
        this.max = max;
        this.offsetInGround = offsetInGround;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 pContext) {
        class_2338 blockPos = new class_2338(pContext.comp_568().method_8326(), 0, pContext.comp_568().method_8328());
        class_2338 validPos = new class_2338(blockPos.method_10263(), this.getValidY(pContext.comp_562().method_26261(blockPos.method_10263(), blockPos.method_10260(), pContext.comp_569(), pContext.comp_564())), blockPos.method_10260());
        if (validPos.method_10264() != this.min - 1 && this.isSufficientlyFlat(pContext, validPos, 8)) {
            return class_3778.method_30419((class_3195.class_7149)pContext, this.startPool, this.startJigsawName, (int)this.size, (class_2338)validPos.method_10087(-this.offsetInGround), (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
        }
        return Optional.empty();
    }

    public boolean isSufficientlyFlat(class_3195.class_7149 context, class_2338 origin, int check) {
        ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
        for (int x = -check; x < check; ++x) {
            for (int z = -check; z < check; ++z) {
                blockPosList.add(origin.method_10069(x, 0, z));
            }
        }
        int count = 0;
        for (class_2338 pos : blockPosList) {
            class_4966 blockView = context.comp_562().method_26261(pos.method_10263(), pos.method_10260(), context.comp_569(), context.comp_564());
            if (!blockView.method_32892(pos.method_10264()).method_26215() || blockView.method_32892(pos.method_10074().method_10264()).method_26215()) continue;
            ++count;
        }
        return count >= check * check * 2;
    }

    public int getValidY(class_4966 sample) {
        int maxLength = 0;
        int currentLength = 0;
        int maxIndex = this.min - 1;
        for (int i = this.min; i < this.max; i += this.size) {
            if (sample.method_32892(i).method_26215()) {
                int j;
                for (j = i + 1; j < this.max && sample.method_32892(j).method_26215(); ++j) {
                }
                int sequenceLength = j - i;
                if (sequenceLength < this.size) continue;
                if ((currentLength += sequenceLength) > maxLength) {
                    maxLength = currentLength;
                    maxIndex = i;
                }
                i = j - 1;
                continue;
            }
            currentLength = 0;
        }
        return maxIndex;
    }

    public class_7151<?> method_41618() {
        return (class_7151)StructureRegistry.WEEPING_WELL.get();
    }
}

