/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldevent;

import com.sammy.malum.common.block.blight.BlightedSoilBlock;
import com.sammy.malum.common.worldgen.tree.SoulwoodTreeFeature;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.WorldEventTypes;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5425;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class ActiveBlightEvent
extends WorldEventInstance {
    public int blightTimer;
    public int intensity;
    public int rate;
    public int times;
    public class_2338 sourcePos;
    public Map<Integer, Double> noiseValues;

    public ActiveBlightEvent() {
        super(WorldEventTypes.ACTIVE_BLIGHT);
    }

    public ActiveBlightEvent setBlightData(int intensity, int rate, int times) {
        this.intensity = intensity;
        this.rate = rate;
        this.times = times;
        return this;
    }

    public ActiveBlightEvent setPosition(class_2338 sourcePos) {
        this.sourcePos = sourcePos;
        return this;
    }

    public void tick(class_1937 level) {
        if (this.times == 0) {
            this.end(level);
            return;
        }
        if (this.blightTimer == 0) {
            this.blightTimer = this.rate;
            --this.times;
            this.createBlight((class_3218)level);
            this.intensity += 2;
        } else {
            --this.blightTimer;
        }
    }

    public void createBlight(class_3218 level) {
        LodestoneBlockFiller filler = new LodestoneBlockFiller(new LodestoneBlockFiller.LodestoneBlockFillerLayer[]{new LodestoneBlockFiller.LodestoneBlockFillerLayer(SoulwoodTreeFeature.BLIGHT)});
        if (this.noiseValues == null) {
            this.noiseValues = SoulwoodTreeFeature.generateBlight((class_5425)level, filler, this.sourcePos, this.intensity);
        } else {
            SoulwoodTreeFeature.generateBlight((class_5425)level, filler, this.noiseValues, this.sourcePos, this.intensity);
        }
        ActiveBlightEvent.createBlightVFX(level, filler);
        level.method_8396(null, this.sourcePos, (class_3414)SoundRegistry.MAJOR_BLIGHT_MOTIF.get(), class_3419.field_15245, 1.0f, 1.8f);
    }

    public static void createBlightVFX(class_3218 level, LodestoneBlockFiller filler) {
        filler.getLayer(SoulwoodTreeFeature.BLIGHT).entrySet().stream().filter(e -> ((LodestoneBlockFiller.BlockStateEntry)e.getValue()).getState().method_26204() instanceof BlightedSoilBlock).map(Map.Entry::getKey).forEach(p -> ParticleEffectTypeRegistry.BLIGHTING_MIST.createPositionedEffect(level, new PositionEffectData((class_2338)p)));
    }
}

