/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class TotemicRiteType {
    public final List<MalumSpiritType> spirits;
    public final String identifier;
    public final TotemicRiteEffect effect;
    public final TotemicRiteEffect corruptedEffect;

    public TotemicRiteType(String identifier, MalumSpiritType ... spirits) {
        this.identifier = identifier;
        this.spirits = new ArrayList<MalumSpiritType>(Arrays.asList(spirits));
        this.effect = this.getNaturalRiteEffect();
        this.corruptedEffect = this.getCorruptedEffect();
    }

    public List<class_2561> makeDetailedDescriptor(boolean corrupted) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_124 spiritStyleModifier = this.getIdentifyingSpirit().getItemRarity().field_8908;
        TotemicRiteEffect riteEffect = this.getRiteEffect(corrupted);
        TotemicRiteEffect.MalumRiteEffectCategory riteCategory = riteEffect.category;
        tooltip.add((class_2561)class_2561.method_43471((String)this.translationIdentifier(corrupted)).method_27692(spiritStyleModifier));
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.type", riteCategory.getTranslationKey()));
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.medium", "malum.gui.rite.medium." + (corrupted ? "soulwood" : "runewood")));
        if (!riteCategory.equals((Object)TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT)) {
            tooltip.add(this.makeDescriptorComponent("malum.gui.rite.coverage", riteEffect.getRiteCoverageDescriptor()));
        }
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.effect", "malum.gui.book.entry.page.text." + (corrupted ? "corrupt_" : "") + this.identifier + ".hover"));
        return tooltip;
    }

    public final class_2561 makeDescriptorComponent(String translationKey1, String translationKey2) {
        return class_2561.method_43471((String)translationKey1).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43471((String)translationKey2).method_27692(class_124.field_1054));
    }

    public String translationIdentifier(boolean corrupt) {
        return "malum.gui.rite." + (corrupt ? "corrupted_" : "") + this.identifier;
    }

    public class_2960 getIcon() {
        return MalumMod.malumPath("textures/vfx/rite/" + this.identifier.replace("greater_", "").replace("_rite", "") + ".png");
    }

    public MalumSpiritType getIdentifyingSpirit() {
        return this.spirits.get(this.spirits.size() - 1);
    }

    protected abstract TotemicRiteEffect getNaturalRiteEffect();

    protected abstract TotemicRiteEffect getCorruptedEffect();

    public final TotemicRiteEffect getRiteEffect(boolean corrupted) {
        return corrupted ? this.corruptedEffect : this.effect;
    }

    public void executeRite(TotemBaseBlockEntity totemBase) {
        this.getRiteEffect(totemBase.isSoulwood).doRiteEffect(totemBase);
    }
}

