/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.registry.common.block.BlockTagRegistry;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import team.lodestar.lodestone.helpers.BlockHelper;

public abstract class TotemicRiteEffect {
    public final MalumRiteEffectCategory category;

    protected TotemicRiteEffect(MalumRiteEffectCategory category) {
        this.category = category;
    }

    public final void doRiteEffect(TotemBaseBlockEntity totemBase) {
        class_1937 class_19372 = totemBase.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.doRiteEffect(totemBase, serverLevel);
        }
    }

    protected abstract void doRiteEffect(TotemBaseBlockEntity var1, class_3218 var2);

    public class_2338 getRiteEffectCenter(TotemBaseBlockEntity totemBase) {
        if (this.category.equals((Object)MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT)) {
            return totemBase.method_11016().method_10074().method_10079(totemBase.getDirection(), 3);
        }
        return totemBase.method_11016();
    }

    public String getRiteCoverageDescriptor() {
        int yCoverage;
        int coverage = this.getRiteEffectHorizontalRadius();
        if (coverage > 1) {
            coverage = coverage * 2 + 1;
        }
        if ((yCoverage = this.getRiteEffectVerticalRadius()) > 1) {
            yCoverage = yCoverage * 2 + 1;
        }
        return coverage + "x" + yCoverage + "x" + coverage;
    }

    public int getRiteEffectHorizontalRadius() {
        return this.category.effectWidth;
    }

    public int getRiteEffectVerticalRadius() {
        return this.category.effectHeight;
    }

    public int getRiteEffectTickRate() {
        return this.category.tickRate;
    }

    public <T extends class_1297> Stream<T> getNearbyEntities(TotemBaseBlockEntity totemBase, Class<T> clazz) {
        return this.getNearbyEntities(totemBase, clazz, e -> true);
    }

    public <T extends class_1297> Stream<T> getNearbyEntities(TotemBaseBlockEntity totemBase, Class<T> clazz, Predicate<T> predicate) {
        int horizontal = this.getRiteEffectHorizontalRadius();
        int vertical = this.getRiteEffectVerticalRadius();
        class_238 area = new class_238(this.getRiteEffectCenter(totemBase)).method_1009((double)horizontal, (double)vertical, (double)horizontal);
        return totemBase.method_10997().method_18467(clazz, area).stream().filter(predicate);
    }

    public Stream<class_2338> getNearbyBlocks(TotemBaseBlockEntity totemBase, Class<?> clazz) {
        int horizontal = this.getRiteEffectHorizontalRadius();
        int vertical = this.getRiteEffectVerticalRadius();
        return BlockHelper.getBlocksStream((class_2338)this.getRiteEffectCenter(totemBase), (int)horizontal, (int)vertical, (int)horizontal, p -> this.canAffectBlock(totemBase, clazz, (class_2338)p));
    }

    public Stream<class_2338> getBlocksAhead(TotemBaseBlockEntity totemBase) {
        return BlockHelper.getPlaneOfBlocksStream((class_2338)this.getRiteEffectCenter(totemBase), (int)this.getRiteEffectHorizontalRadius(), p -> this.canAffectBlock(totemBase, (class_2338)p));
    }

    public final boolean canAffectBlock(TotemBaseBlockEntity totemBase, Class<?> clazz, class_2338 pos) {
        class_2680 state = totemBase.method_10997().method_8320(pos);
        return clazz.isInstance(state.method_26204()) && this.canAffectBlock(totemBase, state, pos);
    }

    public final boolean canAffectBlock(TotemBaseBlockEntity totemBase, class_2338 pos) {
        class_2680 state = totemBase.method_10997().method_8320(pos);
        return this.canAffectBlock(totemBase, state, pos);
    }

    public boolean canAffectBlock(TotemBaseBlockEntity totemBase, class_2680 state, class_2338 pos) {
        return !state.method_26164(BlockTagRegistry.RITE_IMMUNE);
    }

    public static enum MalumRiteEffectCategory {
        AURA(40, 8),
        LIVING_ENTITY_EFFECT(40, 4),
        DIRECTIONAL_BLOCK_EFFECT(160, 2, 1),
        RADIAL_BLOCK_EFFECT(80, 5),
        ONE_TIME_EFFECT(0, 0);

        private final int tickRate;
        private final int effectWidth;
        private final int effectHeight;

        private MalumRiteEffectCategory(int tickRate, int range) {
            this(tickRate, range, range);
        }

        private MalumRiteEffectCategory(int tickRate, int effectWidth, int effectHeight) {
            this.tickRate = tickRate;
            this.effectWidth = effectWidth;
            this.effectHeight = effectHeight;
        }

        public String getTranslationKey() {
            return "malum.gui.rite.category." + this.name().toLowerCase(Locale.ROOT);
        }
    }
}

