/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractSpiritListMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritRepairRecipe
extends AbstractSpiritListMalumRecipe {
    public static final String NAME = "spirit_repair";
    public final float durabilityPercentage;
    public final List<class_1792> inputs;
    public final IngredientWithCount repairMaterial;

    public SpiritRepairRecipe(class_2960 id, float durabilityPercentage, List<class_1792> inputs, IngredientWithCount repairMaterial, List<SpiritWithCount> spirits) {
        super(id, (class_1865)RecipeSerializerRegistry.REPAIR_RECIPE_SERIALIZER.get(), (class_3956)RecipeTypeRegistry.SPIRIT_REPAIR.get(), spirits);
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = repairMaterial;
        this.inputs = inputs;
    }

    public boolean doesInputMatch(class_1799 input) {
        return this.inputs.stream().anyMatch(i -> i.equals(input.method_7909()));
    }

    public boolean doesRepairMatch(class_1799 input) {
        return this.repairMaterial.matches(input);
    }

    public static SpiritRepairRecipe getRecipe(class_1937 level, class_1799 stack, class_1799 repairStack, List<class_1799> spirits) {
        if (stack.method_7963() && !stack.method_7986()) {
            return null;
        }
        return SpiritRepairRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doesRepairMatch(repairStack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritRepairRecipe getRecipe(class_1937 level, Predicate<SpiritRepairRecipe> predicate) {
        return SpiritRepairRecipe.getRecipe(level, (class_3956)RecipeTypeRegistry.SPIRIT_REPAIR.get(), predicate);
    }

    public static List<SpiritRepairRecipe> getRecipes(class_1937 level) {
        return SpiritRepairRecipe.getRecipes(level, (class_3956)RecipeTypeRegistry.SPIRIT_REPAIR.get());
    }

    public static class_1799 getRepairRecipeOutput(class_1799 input) {
        return input.method_7909() instanceof IRepairOutputOverride ? new class_1799((class_1935)((IRepairOutputOverride)input.method_7909()).overrideRepairResult(), input.method_7947(), Optional.ofNullable(input.method_7969())) : input;
    }

    public static interface IRepairOutputOverride {
        default public class_1792 overrideRepairResult() {
            return class_1802.field_8162;
        }

        default public boolean ignoreDuringLookup() {
            return false;
        }
    }

    public static class Serializer
    implements class_1865<SpiritRepairRecipe> {
        public static List<class_1792> REPAIRABLE;

        public SpiritRepairRecipe fromJson(class_2960 recipeId, JsonObject json) {
            if (REPAIRABLE == null) {
                REPAIRABLE = class_7923.field_41178.method_10220().filter(class_1792::method_7846).collect(Collectors.toList());
            }
            float durabilityPercentage = json.getAsJsonPrimitive("durabilityPercentage").getAsFloat();
            String itemIdRegex = json.get("itemIdRegex").getAsString();
            String modIdRegex = json.get("modIdRegex").getAsString();
            JsonArray inputsArray = json.getAsJsonArray("inputs");
            ArrayList<class_1792> inputs = new ArrayList<class_1792>();
            for (JsonElement jsonElement : inputsArray) {
                class_1792 input = (class_1792)class_7923.field_41178.method_10223(new class_2960(jsonElement.getAsString()));
                if (input == null) continue;
                inputs.add(input);
            }
            for (class_1792 item : REPAIRABLE) {
                IRepairOutputOverride repairOutputOverride;
                if (!class_7923.field_41178.method_10221((Object)item).method_12832().matches(itemIdRegex) || !modIdRegex.equals("") && !class_7923.field_41178.method_10221((Object)item).method_12836().matches(modIdRegex) || item instanceof IRepairOutputOverride && (repairOutputOverride = (IRepairOutputOverride)item).ignoreDuringLookup() || inputs.contains(item)) continue;
                inputs.add(item);
            }
            if (inputs.isEmpty()) {
                return null;
            }
            JsonObject repairObject = json.getAsJsonObject("repairMaterial");
            IngredientWithCount repair = IngredientWithCount.deserialize((JsonObject)repairObject);
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            return new SpiritRepairRecipe(recipeId, durabilityPercentage, inputs, repair, spirits);
        }

        @Nullable
        public SpiritRepairRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            float durabilityPercentage = buffer.readFloat();
            int inputCount = buffer.readInt();
            ArrayList<class_1792> inputs = new ArrayList<class_1792>();
            for (int i = 0; i < inputCount; ++i) {
                inputs.add(buffer.method_10819().method_7909());
            }
            IngredientWithCount repair = IngredientWithCount.read((class_2540)buffer);
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.method_10819()));
            }
            return new SpiritRepairRecipe(recipeId, durabilityPercentage, inputs, repair, spirits);
        }

        public void toNetwork(class_2540 buffer, SpiritRepairRecipe recipe) {
            buffer.writeFloat(recipe.durabilityPercentage);
            buffer.writeInt(recipe.inputs.size());
            for (class_1792 class_17922 : recipe.inputs) {
                buffer.method_10793(class_17922.method_7854());
            }
            recipe.repairMaterial.write(buffer);
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount spiritWithCount : recipe.spirits) {
                buffer.method_10793(spiritWithCount.getStack());
            }
        }
    }
}

