/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractSpiritListMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritInfusionRecipe
extends AbstractSpiritListMalumRecipe {
    public static final String NAME = "spirit_infusion";
    public final IngredientWithCount input;
    public final boolean useNbtFromInput;
    public final class_1799 output;
    public final List<IngredientWithCount> extraItems;

    public SpiritInfusionRecipe(class_2960 id, IngredientWithCount input, boolean useNbtFromInput, class_1799 output, List<SpiritWithCount> spirits, List<IngredientWithCount> extraItems) {
        super(id, (class_1865)RecipeSerializerRegistry.INFUSION_RECIPE_SERIALIZER.get(), (class_3956)RecipeTypeRegistry.SPIRIT_INFUSION.get(), spirits);
        this.input = input;
        this.useNbtFromInput = useNbtFromInput;
        this.output = output;
        this.extraItems = extraItems;
    }

    public boolean doesInputMatch(class_1799 input) {
        return this.input.matches(input);
    }

    public boolean doesOutputMatch(class_1799 output) {
        return output.method_7909().equals(this.output.method_7909());
    }

    public static SpiritInfusionRecipe getRecipe(class_1937 level, class_1799 stack, List<class_1799> spirits) {
        return SpiritInfusionRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritInfusionRecipe getRecipe(class_1937 level, Predicate<SpiritInfusionRecipe> predicate) {
        return SpiritInfusionRecipe.getRecipe(level, (class_3956)RecipeTypeRegistry.SPIRIT_INFUSION.get(), predicate);
    }

    public static List<SpiritInfusionRecipe> getRecipes(class_1937 level) {
        return SpiritInfusionRecipe.getRecipes(level, (class_3956)RecipeTypeRegistry.SPIRIT_INFUSION.get());
    }

    public static class Serializer
    implements class_1865<SpiritInfusionRecipe> {
        public SpiritInfusionRecipe fromJson(class_2960 recipeId, JsonObject json) {
            JsonObject inputObject = json.getAsJsonObject("input");
            IngredientWithCount input = IngredientWithCount.deserialize((JsonObject)inputObject);
            boolean useNbtFromInput = !json.has("useNbtFromInput") || json.getAsJsonPrimitive("useNbtFromInput").getAsBoolean();
            JsonObject outputObject = json.getAsJsonObject("output");
            class_1799 output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            JsonArray extraItemsArray = json.getAsJsonArray("extra_items");
            ArrayList<IngredientWithCount> extraItems = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < extraItemsArray.size(); ++i) {
                JsonObject extraItemObject = extraItemsArray.get(i).getAsJsonObject();
                extraItems.add(IngredientWithCount.deserialize((JsonObject)extraItemObject));
            }
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            if (spirits.isEmpty()) {
                return null;
            }
            return new SpiritInfusionRecipe(recipeId, input, useNbtFromInput, output, spirits, extraItems);
        }

        @Nullable
        public SpiritInfusionRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            IngredientWithCount input = IngredientWithCount.read((class_2540)buffer);
            boolean useNbtFromInput = buffer.readBoolean();
            class_1799 output = buffer.method_10819();
            int extraItemCount = buffer.readInt();
            ArrayList<IngredientWithCount> extraItems = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < extraItemCount; ++i) {
                extraItems.add(IngredientWithCount.read((class_2540)buffer));
            }
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.method_10819()));
            }
            return new SpiritInfusionRecipe(recipeId, input, useNbtFromInput, output, spirits, extraItems);
        }

        public void toNetwork(class_2540 buffer, SpiritInfusionRecipe recipe) {
            recipe.input.write(buffer);
            buffer.writeBoolean(recipe.useNbtFromInput);
            buffer.method_10793(recipe.output);
            buffer.writeInt(recipe.extraItems.size());
            for (IngredientWithCount ingredientWithCount : recipe.extraItems) {
                ingredientWithCount.write(buffer);
            }
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount spiritWithCount : recipe.spirits) {
                buffer.method_10793(spiritWithCount.getStack());
            }
        }
    }
}

