/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractSpiritListMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class SpiritFocusingRecipe
extends AbstractSpiritListMalumRecipe {
    public static final String NAME = "spirit_focusing";
    public final int time;
    public final int durabilityCost;
    public final class_1856 input;
    public final class_1799 output;

    public SpiritFocusingRecipe(class_2960 id, int time, int durabilityCost, class_1856 input, class_1799 output, List<SpiritWithCount> spirits) {
        super(id, (class_1865)RecipeSerializerRegistry.FOCUSING_RECIPE_SERIALIZER.get(), (class_3956)RecipeTypeRegistry.SPIRIT_FOCUSING.get(), spirits);
        this.time = time;
        this.durabilityCost = durabilityCost;
        this.input = input;
        this.output = output;
    }

    public boolean doesInputMatch(class_1799 input) {
        return this.input.method_8093(input);
    }

    public boolean doesOutputMatch(class_1799 output) {
        return output.method_7909().equals(this.output.method_7909());
    }

    public static SpiritFocusingRecipe getRecipe(class_1937 level, class_1799 stack, List<class_1799> spirits) {
        return SpiritFocusingRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritFocusingRecipe getRecipe(class_1937 level, Predicate<SpiritFocusingRecipe> predicate) {
        return SpiritFocusingRecipe.getRecipe(level, (class_3956)RecipeTypeRegistry.SPIRIT_FOCUSING.get(), predicate);
    }

    public static List<SpiritFocusingRecipe> getRecipes(class_1937 level) {
        return SpiritFocusingRecipe.getRecipes(level, (class_3956)RecipeTypeRegistry.SPIRIT_FOCUSING.get());
    }

    public static class Serializer
    implements class_1865<SpiritFocusingRecipe> {
        public SpiritFocusingRecipe fromJson(class_2960 recipeId, JsonObject json) {
            int time = json.getAsJsonPrimitive("time").getAsInt();
            int durabilityCost = json.getAsJsonPrimitive("durabilityCost").getAsInt();
            JsonObject inputObject = json.getAsJsonObject("input");
            class_1856 input = class_1856.method_52177((JsonElement)inputObject);
            JsonObject outputObject = json.getAsJsonObject("output");
            class_1799 output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            if (spirits.isEmpty()) {
                return null;
            }
            return new SpiritFocusingRecipe(recipeId, time, durabilityCost, input, output, spirits);
        }

        @Nullable
        public SpiritFocusingRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int time = buffer.readInt();
            int durabilityCost = buffer.readInt();
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            class_1799 output = buffer.method_10819();
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.method_10819()));
            }
            return new SpiritFocusingRecipe(recipeId, time, durabilityCost, input, output, spirits);
        }

        public void toNetwork(class_2540 buffer, SpiritFocusingRecipe recipe) {
            buffer.writeInt(recipe.time);
            buffer.writeInt(recipe.durabilityCost);
            recipe.input.method_8088(buffer);
            buffer.method_10793(recipe.output);
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount item : recipe.spirits) {
                buffer.method_10793(item.getStack());
            }
        }
    }
}

