/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractMalumRecipe;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class RunicWorkbenchRecipe
extends AbstractMalumRecipe {
    public static final String NAME = "runeworking";
    public final IngredientWithCount primaryInput;
    public final IngredientWithCount secondaryInput;
    public final class_1799 output;

    public RunicWorkbenchRecipe(class_2960 id, IngredientWithCount primaryInput, IngredientWithCount secondaryInput, class_1799 output) {
        super(id, (class_1865)RecipeSerializerRegistry.RUNEWORKING_RECIPE_SERIALIZER.get(), (class_3956)RecipeTypeRegistry.RUNEWORKING.get());
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = output;
    }

    public boolean doesPrimaryInputMatch(class_1799 input) {
        return this.primaryInput.matches(input);
    }

    public boolean doesSecondaryInputMatch(class_1799 input) {
        return this.secondaryInput.matches(input);
    }

    public boolean doesOutputMatch(class_1799 output) {
        return output.method_7909().equals(this.output.method_7909());
    }

    public static RunicWorkbenchRecipe getRecipe(class_1937 level, class_1799 primaryStack, class_1799 secondaryStack) {
        return RunicWorkbenchRecipe.getRecipe(level, c -> c.doesPrimaryInputMatch(primaryStack) && c.doesSecondaryInputMatch(secondaryStack));
    }

    public static RunicWorkbenchRecipe getRecipe(class_1937 level, Predicate<RunicWorkbenchRecipe> predicate) {
        return RunicWorkbenchRecipe.getRecipe(level, (class_3956)RecipeTypeRegistry.RUNEWORKING.get(), predicate);
    }

    public static List<RunicWorkbenchRecipe> getRecipes(class_1937 level) {
        return RunicWorkbenchRecipe.getRecipes(level, (class_3956)RecipeTypeRegistry.RUNEWORKING.get());
    }

    public static class Serializer
    implements class_1865<RunicWorkbenchRecipe> {
        public RunicWorkbenchRecipe fromJson(class_2960 recipeId, JsonObject json) {
            IngredientWithCount primaryInput = IngredientWithCount.deserialize((JsonObject)json.getAsJsonObject("primaryInput"));
            IngredientWithCount secondaryInput = IngredientWithCount.deserialize((JsonObject)json.getAsJsonObject("secondaryInput"));
            JsonObject outputObject = json.getAsJsonObject("output");
            class_1799 output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            return new RunicWorkbenchRecipe(recipeId, primaryInput, secondaryInput, output);
        }

        @Nullable
        public RunicWorkbenchRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            IngredientWithCount primaryInput = IngredientWithCount.read((class_2540)buffer);
            IngredientWithCount secondaryInput = IngredientWithCount.read((class_2540)buffer);
            class_1799 output = buffer.method_10819();
            return new RunicWorkbenchRecipe(recipeId, primaryInput, secondaryInput, output);
        }

        public void toNetwork(class_2540 buffer, RunicWorkbenchRecipe recipe) {
            recipe.primaryInput.write(buffer);
            recipe.secondaryInput.write(buffer);
            buffer.method_10793(recipe.output);
        }
    }
}

