/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.base.spirit;

import com.sammy.malum.common.packets.particle.base.PositionBasedParticleEffectPacket;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.List;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;

public abstract class SpiritBasedParticleEffectPacket
extends PositionBasedParticleEffectPacket {
    protected final List<String> spirits;

    public SpiritBasedParticleEffectPacket(List<String> spirits, double posX, double posY, double posZ) {
        super(posX, posY, posZ);
        this.spirits = spirits;
    }

    public SpiritBasedParticleEffectPacket(class_2540 buf) {
        super(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.spirits = SpiritBasedParticleEffectPacket.readSpirits(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.method_10814(string);
        }
        super.encode(buf);
    }

    protected static List<String> readSpirits(class_2540 buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.method_19772());
        }
        return spirits;
    }

    public void executeClient(class_310 client, class_634 listener, PacketSender responseSender, SimpleChannel channel) {
        super.executeClient(client, listener, responseSender, channel);
        for (String string : this.spirits) {
            this.execute(client, listener, responseSender, channel, SpiritHarvestHandler.getSpiritType(string));
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract void execute(class_310 var1, class_634 var2, PacketSender var3, SimpleChannel var4, MalumSpiritType var5);

    public static <T extends SpiritBasedParticleEffectPacket> T decode(PacketProvider<T> provider, class_2540 buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.method_19772());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return provider.getPacket(spirits, posX, posY, posZ);
    }

    public static interface PacketProvider<T extends SpiritBasedParticleEffectPacket> {
        public T getPacket(List<String> var1, double var2, double var4, double var6);
    }
}

