/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.RitualRegistry;
import com.sammy.malum.visual_effects.ScreenParticleEffects;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class RitualShardItem
extends class_1792
implements ParticleEmitterHandler.ItemParticleSupplier {
    public static final String RITUAL_TYPE = "stored_ritual";
    public static final String STORED_SPIRITS = "stored_spirits";

    public RitualShardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1814 method_7862(class_1799 pStack) {
        MalumRitualType ritualType = RitualShardItem.getRitualType(pStack);
        if (ritualType != null) {
            return ritualType.spirit.getItemRarity();
        }
        return super.method_7862(pStack);
    }

    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltip, class_1836 pFlag) {
        MalumRitualType ritualType = RitualShardItem.getRitualType(pStack);
        MalumRitualTier ritualTier = RitualShardItem.getRitualTier(pStack);
        if (ritualType != null && ritualTier != null) {
            pTooltip.addAll(ritualType.makeRitualShardDescriptor(ritualTier));
        }
    }

    public void spawnLateParticles(ScreenParticleHolder target, class_1937 level, float partialTick, class_1799 stack, float x, float y) {
        MalumRitualType ritualType = RitualShardItem.getRitualType(stack);
        MalumRitualTier ritualTier = RitualShardItem.getRitualTier(stack);
        if (ritualType != null && ritualTier != null) {
            MalumSpiritType type = ritualType.spirit;
            ScreenParticleEffects.spawnSpiritShardScreenParticles(target, type);
            if (ritualTier.isGreaterThan(MalumRitualTier.DIM)) {
                float distance = 2.0f + (float)ritualTier.potency;
                class_5819 rand = class_310.method_1551().field_1687.method_8409();
                for (int i = 0; i < 2; ++i) {
                    float time = ((i == 1 ? 3.14f : 0.0f) + ((float)level.method_8510() + partialTick) * 0.05f) % 6.28f;
                    float scalar = 0.4f + 0.15f * (float)ritualTier.potency;
                    if (time > 1.57f && time < 4.71f) {
                        scalar *= Easing.QUAD_IN.ease(Math.abs(3.14f - time) / 1.57f, 0.0f, 1.0f, 1.0f);
                    }
                    double xOffset = Math.sin(time) * (double)distance;
                    double yOffset = Math.cos(time) * (double)distance * 0.5;
                    ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.create((float)RandomHelper.randomBetween((class_5819)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData(GenericParticleData.create((float)(RandomHelper.randomBetween((class_5819)rand, (float)0.2f, (float)0.3f) * scalar), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData(type.createColorData().build()).setLifetime(RandomHelper.randomBetween((class_5819)rand, (int)80, (int)120)).setRandomOffset((double)0.1f).spawnOnStack(xOffset, yOffset);
                    if (!ritualTier.isGreaterThan(MalumRitualTier.BRIGHT)) break;
                }
            }
        }
    }

    public static MalumRitualType getRitualType(class_1799 stack) {
        return stack.method_7985() ? RitualRegistry.get(new class_2960(stack.method_7969().method_10558(RITUAL_TYPE))) : null;
    }

    public static MalumRitualTier getRitualTier(class_1799 stack) {
        return stack.method_7985() ? MalumRitualTier.figureOutTier(stack.method_7969().method_10550(STORED_SPIRITS)) : null;
    }
}

