/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.food;

import com.sammy.malum.common.item.food.BottledDrinkItem;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.gluttony.AbsorbGluttonyParticleEffect;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.TrinketsHelper;

public class ConcentratedGluttonyItem
extends BottledDrinkItem {
    public static final Collection<Supplier<class_1792>> ROTTEN_TRINKETS = new ArrayList<RegistryObject<class_1792>>(List.of(ItemRegistry.RING_OF_DESPERATE_VORACITY, ItemRegistry.GLUTTONOUS_BROOCH, ItemRegistry.BELT_OF_THE_STARVED));

    public ConcentratedGluttonyItem(class_1792.class_1793 builder) {
        super(builder);
    }

    @Override
    public class_1799 method_7861(class_1799 pStack, class_1937 pLevel, class_1309 pEntityLiving) {
        class_1293 gluttonyEffect = ConcentratedGluttonyItem.createGluttonyEffect((class_1297)pEntityLiving);
        pEntityLiving.method_6092(gluttonyEffect);
        pEntityLiving.method_5783((class_3414)SoundRegistry.CONCENTRATED_GLUTTONY_DRINK.get(), 1.0f, RandomHelper.randomBetween((class_5819)pLevel.field_9229, (float)1.5f, (float)2.0f));
        if (!pLevel.field_9236) {
            ConcentratedGluttonyItem.createGluttonyVFX(pEntityLiving, gluttonyEffect.field_5893);
        }
        return super.method_7861(pStack, pLevel, pEntityLiving);
    }

    public static class_1293 createGluttonyEffect(@Nullable class_1297 source) {
        return ConcentratedGluttonyItem.createGluttonyEffect(source, 1.0f);
    }

    public static class_1293 createGluttonyEffect(@Nullable class_1297 source, float durationScalar) {
        int amplifier = 3;
        int duration = 20;
        if (source instanceof class_1309) {
            class_1309 livingEntity = (class_1309)source;
            if (TrinketsHelper.hasTrinketEquipped((class_1309)livingEntity, (class_1792)((class_1792)ItemRegistry.RING_OF_GRUESOME_CONCENTRATION.get()))) {
                ++amplifier;
                duration += 40;
            }
            for (Supplier<class_1792> rottenTrinket : ROTTEN_TRINKETS) {
                if (!TrinketsHelper.hasTrinketEquipped((class_1309)livingEntity, (class_1792)rottenTrinket.get())) continue;
                ++amplifier;
                duration += 10;
            }
        }
        return new class_1293((class_1291)MobEffectRegistry.GLUTTONY.get(), (int)((float)(duration * 20) * durationScalar), amplifier);
    }

    public static void createGluttonyVFX(class_1309 target, int amplifier) {
        ConcentratedGluttonyItem.createGluttonyVFX(target, 1.0f + (float)amplifier * 0.05f);
    }

    public static void createGluttonyVFX(class_1309 target, float potency) {
        class_243 position = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.GLUTTONY_ABSORB.createPositionedEffect(serverLevel, new PositionEffectData(position), AbsorbGluttonyParticleEffect.createData(potency));
        }
    }
}

