/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.entity.bolt.DrainingBoltEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class ErosionScepterItem
extends AbstractStaffItem {
    public static final Color MALIGNANT_PURPLE = new Color(68, 11, 61);
    public static final Color MALIGNANT_BLACK = new Color(12, 4, 11);
    public static final ColorParticleData MALIGNANT_COLOR_DATA = ColorParticleData.create((Color)MALIGNANT_PURPLE, (Color)MALIGNANT_BLACK).setEasing(Easing.BOUNCE_IN_OUT).setCoefficient(1.2f).build();

    public ErosionScepterItem(class_1832 tier, float magicDamage, class_1792.class_1793 builderIn) {
        super(tier, 10, magicDamage, builderIn);
    }

    @Override
    public void hurtEvent(LivingHurtEvent event, class_1309 attacker, class_1309 target, class_1799 stack) {
        if (!(event.getSource().method_5526() instanceof AbstractBoltProjectileEntity) && !event.getSource().method_48789(LodestoneDamageTypeTags.IS_MAGIC)) {
            class_1291 silenced = (class_1291)MobEffectRegistry.SILENCED.get();
            class_1293 effect = target.method_6112(silenced);
            if (effect == null) {
                target.method_6092(new class_1293(silenced, 300, 1, true, true, true));
            } else {
                EntityHelper.amplifyEffect((class_1293)effect, (class_1309)target, (int)2, (int)9);
                EntityHelper.extendEffect((class_1293)effect, (class_1309)target, (int)60, (int)600);
            }
            attacker.method_37908().method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), (class_3414)SoundRegistry.DRAINING_MOTIF.get(), attacker.method_5634(), 1.0f, 1.25f);
        }
        super.hurtEvent(event, attacker, target, stack);
    }

    @Override
    public int getCooldownDuration(class_1937 level, class_1309 livingEntity) {
        return 80;
    }

    @Override
    public int getProjectileCount(class_1937 level, class_1309 livingEntity, float pct) {
        return pct == 1.0f ? 2 : 0;
    }

    @Override
    public void fireProjectile(class_1309 player, class_1799 stack, class_1937 level, class_1268 hand, float chargePercentage, int count) {
        int spawnDelay = count * 5;
        float pitchOffset = (float)count * 1.5f;
        float velocity = 4.0f;
        float magicDamage = (float)player.method_6127().method_26852((class_1320)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()) * 0.3f;
        class_243 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        for (int i = 0; i < 4; ++i) {
            float xSpread = RandomHelper.randomBetween((class_5819)level.field_9229, (float)-0.125f, (float)0.125f);
            float ySpread = RandomHelper.randomBetween((class_5819)level.field_9229, (float)-0.025f, (float)0.025f);
            DrainingBoltEntity entity = new DrainingBoltEntity(level, pos.field_1352, pos.field_1351, pos.field_1350);
            if (i > 1) {
                entity.method_5803(true);
            }
            entity.setData((class_1297)player, magicDamage, spawnDelay);
            entity.method_16940(stack);
            entity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), -pitchOffset, velocity, 0.0f);
            class_243 projectileDirection = entity.method_18798();
            float yRot = (float)(class_3532.method_15349((double)projectileDirection.field_1352, (double)projectileDirection.field_1350) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            class_243 left = new class_243(-Math.cos(yaw), 0.0, Math.sin(yaw));
            class_243 up = left.method_1036(projectileDirection);
            entity.method_18799(entity.method_18798().method_1019(left.method_1021((double)xSpread)).method_1019(up.method_1021((double)ySpread)));
            level.method_8649((class_1297)entity);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void spawnChargeParticles(class_1937 pLevel, class_1309 pLivingEntity, class_243 pos, class_1799 pStack, float pct) {
        class_5819 random = pLevel.field_9229;
        SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)random, (float)0.25f, (float)0.5f).setSpinOffset(RandomHelper.randomBetween((class_5819)random, (float)0.0f, (float)6.28f)).build();
        WorldParticleBuilder.create(ParticleRegistry.CIRCLE, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(pLivingEntity.method_5720().method_1029())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.8f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)MALIGNANT_BLACK, (Color)MALIGNANT_BLACK).build()).setLifetime(5).setLifeDelay(2).setMotion(pLivingEntity.method_5720().method_1029().method_1021((double)0.05f)).enableNoClip().enableForcedSpawn().setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.field_1352, pos.field_1351, pos.field_1350);
    }
}

