/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.entity.bolt.AuricFlameBoltEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class AuricFlameStaffItem
extends AbstractStaffItem {
    public static final ColorParticleData AURIC_COLOR_DATA = EthericNitrateEntity.AURIC_COLOR_DATA;

    public AuricFlameStaffItem(class_1832 tier, float magicDamage, class_1792.class_1793 builderIn) {
        super(tier, -0.2f, 30, magicDamage, builderIn);
    }

    @Override
    public void hurtEvent(LivingHurtEvent event, class_1309 attacker, class_1309 target, class_1799 stack) {
        if (!(event.getSource().method_5526() instanceof AbstractBoltProjectileEntity)) {
            target.method_5639(4);
            attacker.method_37908().method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), (class_3414)SoundRegistry.AURIC_FLAME_MOTIF.get(), attacker.method_5634(), 1.0f, 1.25f);
        }
        super.hurtEvent(event, attacker, target, stack);
    }

    @Override
    public int getCooldownDuration(class_1937 level, class_1309 livingEntity) {
        return 160;
    }

    @Override
    public int getProjectileCount(class_1937 level, class_1309 livingEntity, float pct) {
        return pct == 1.0f ? 5 : 0;
    }

    @Override
    public void fireProjectile(class_1309 player, class_1799 stack, class_1937 level, class_1268 hand, float chargePercentage, int count) {
        float ceil = (float)Math.ceil((float)count / 2.0f);
        float spread = count > 0 ? ceil * 0.05f * (float)((long)count % 2L == 0L ? 1 : -1) : 0.0f;
        float pitchOffset = count > 0 ? 4.0f + (2.0f - ceil * 4.0f) : -2.5f;
        int spawnDelay = 1 + count * 2;
        float velocity = 2.0f;
        float magicDamage = (float)player.method_6127().method_26852((class_1320)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()) - 2.0f;
        class_243 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        AuricFlameBoltEntity entity = new AuricFlameBoltEntity(level, pos.field_1352, pos.field_1351, pos.field_1350);
        entity.setData((class_1297)player, magicDamage, spawnDelay);
        entity.method_16940(stack);
        entity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), -pitchOffset, velocity, 0.0f);
        class_243 projectileDirection = entity.method_18798();
        float yRot = (float)(class_3532.method_15349((double)projectileDirection.field_1352, (double)projectileDirection.field_1350) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        class_243 left = new class_243(-Math.cos(yaw), 0.0, Math.sin(yaw));
        entity.method_18799(entity.method_18798().method_1019(left.method_1021((double)spread)));
        level.method_8649((class_1297)entity);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void spawnChargeParticles(class_1937 pLevel, class_1309 pLivingEntity, class_243 pos, class_1799 pStack, float pct) {
        class_5819 random = pLevel.field_9229;
        SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)random, (float)0.25f, (float)0.5f).setSpinOffset(RandomHelper.randomBetween((class_5819)random, (float)0.0f, (float)6.28f)).build();
        WorldParticleBuilder.create(ParticleRegistry.HEXAGON, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(pLivingEntity.method_5720().method_1029())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.35f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(spinData).setColorData(AURIC_COLOR_DATA).setLifetime(5).setMotion(pLivingEntity.method_5720().method_1029().method_1021((double)0.05f)).enableNoClip().enableForcedSpawn().setLifeDelay(2).spawn(pLevel, pos.field_1352, pos.field_1351, pos.field_1350).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.field_1352, pos.field_1351, pos.field_1350);
    }
}

