/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.google.common.collect.ImmutableMultimap;
import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumPlayerDataComponent;
import com.sammy.malum.common.enchantment.ReplenishingEnchantment;
import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.ModCombatItem;

public abstract class AbstractStaffItem
extends ModCombatItem
implements IMalumEventResponderItem {
    public final float chargeDuration;
    public final float magicDamage;

    public AbstractStaffItem(class_1832 tier, float attackSpeed, int chargeDuration, float magicDamage, class_1792.class_1793 builderIn) {
        super(tier, 1.0f, -2.8f + attackSpeed, builderIn);
        this.chargeDuration = chargeDuration;
        this.magicDamage = magicDamage;
    }

    public AbstractStaffItem(class_1832 tier, int chargeDuration, float magicDamage, class_1792.class_1793 builderIn) {
        this(tier, 0.0f, chargeDuration, magicDamage, builderIn);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void spawnChargeParticles(class_1937 var1, class_1309 var2, class_243 var3, class_1799 var4, float var5);

    public abstract int getCooldownDuration(class_1937 var1, class_1309 var2);

    public abstract int getProjectileCount(class_1937 var1, class_1309 var2, float var3);

    public abstract void fireProjectile(class_1309 var1, class_1799 var2, class_1937 var3, class_1268 var4, float var5, int var6);

    public ImmutableMultimap.Builder<class_1320, class_1322> createExtraAttributes() {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)((class_1320)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()), (Object)new class_1322((UUID)LodestoneAttributeRegistry.UUIDS.get(LodestoneAttributeRegistry.MAGIC_DAMAGE), "Weapon magic damage", (double)this.magicDamage, class_1322.class_1323.field_6328));
        return builder;
    }

    public void hurtEvent(LivingHurtEvent event, class_1309 attacker, class_1309 target, class_1799 stack) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (!(event.getSource().method_5526() instanceof AbstractBoltProjectileEntity)) {
                class_1937 level = player.method_37908();
                MalumScytheItem.spawnSweepParticles(player, (class_2400)ParticleRegistry.STAFF_SLAM_PARTICLE.get());
                level.method_8396(null, target.method_24515(), (class_3414)SoundRegistry.STAFF_STRIKES.get(), attacker.method_5634(), 0.75f, class_3532.method_15344((class_5819)level.field_9229, (float)0.5f, (float)1.0f));
                if (event.getSource().method_48789(LodestoneDamageTypeTags.IS_MAGIC)) {
                    ReplenishingEnchantment.replenishStaffCooldown(attacker, stack);
                }
            }
        }
    }

    public void method_7840(class_1799 pStack, class_1937 pLevel, class_1309 pLivingEntity, int pTimeCharged) {
        float chargePercentage = Math.min(this.chargeDuration, (float)(this.method_7881(pStack) - pTimeCharged)) / this.chargeDuration;
        int projectileCount = this.getProjectileCount(pLevel, pLivingEntity, chargePercentage);
        if (projectileCount > 0) {
            class_1268 hand = pLivingEntity.method_6058();
            if (!pLevel.field_9236) {
                float magicDamage = (float)pLivingEntity.method_6127().method_26852((class_1320)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
                if (magicDamage == 0.0f) {
                    float pitch = class_3532.method_15344((class_5819)pLevel.field_9229, (float)0.5f, (float)0.8f);
                    pLevel.method_8396(null, pLivingEntity.method_24515(), (class_3414)SoundRegistry.STAFF_SIZZLES.get(), class_3419.field_15248, 0.5f, pitch);
                    pLivingEntity.method_23667(hand, true);
                    return;
                }
                for (int i = 0; i < projectileCount; ++i) {
                    this.fireProjectile(pLivingEntity, pStack, pLevel, hand, chargePercentage, i);
                }
                if (pLivingEntity instanceof class_1657) {
                    class_1657 player = (class_1657)pLivingEntity;
                    player.method_7259(class_3468.field_15372.method_14956((Object)this));
                    if (!player.method_31549().field_7477) {
                        pStack.method_7956(2, (class_1309)player, p_220009_1_ -> p_220009_1_.method_20236(hand));
                        MalumPlayerDataComponent capability = (MalumPlayerDataComponent)MalumComponents.MALUM_PLAYER_COMPONENT.get((Object)player);
                        if (capability.reserveStaffChargeHandler.chargeCount > 0) {
                            --capability.reserveStaffChargeHandler.chargeCount;
                        } else {
                            player.method_7357().method_7906((class_1792)this, this.getCooldownDuration(pLevel, pLivingEntity));
                        }
                    }
                    player.method_23667(hand, true);
                }
            }
        } else {
            float pitch = class_3532.method_15344((class_5819)pLevel.field_9229, (float)0.5f, (float)0.8f);
            pLevel.method_8396(null, pLivingEntity.method_24515(), (class_3414)SoundRegistry.STAFF_SIZZLES.get(), class_3419.field_15248, 0.5f, pitch);
        }
        super.method_7840(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    public void method_7852(class_1937 pLevel, class_1309 pLivingEntity, class_1799 pStack, int pRemainingUseDuration) {
        int useDuration = this.method_7881(pStack);
        float chargePercentage = Math.min(this.chargeDuration, (float)(useDuration - pRemainingUseDuration)) / this.chargeDuration;
        if (pLevel.field_9236) {
            class_1268 hand = pLivingEntity.method_6058();
            class_243 pos = this.getProjectileSpawnPos(pLivingEntity, hand, 1.5f, 0.6f);
            this.spawnChargeParticles(pLevel, pLivingEntity, pos, pStack, chargePercentage);
        }
        if ((float)pRemainingUseDuration == (float)useDuration - this.chargeDuration) {
            float pitch = class_3532.method_15344((class_5819)pLevel.field_9229, (float)1.2f, (float)1.6f);
            pLevel.method_8396(null, pLivingEntity.method_24515(), (class_3414)SoundRegistry.STAFF_CHARGED.get(), class_3419.field_15248, 1.25f, pitch);
        } else if ((float)pRemainingUseDuration > (float)useDuration - this.chargeDuration && pRemainingUseDuration % 5 == 0) {
            float pitch = 0.25f + chargePercentage + class_3532.method_15344((class_5819)pLevel.field_9229, (float)0.2f, (float)0.6f);
            pLevel.method_8396(null, pLivingEntity.method_24515(), (class_3414)SoundRegistry.STAFF_POWERS_UP.get(), class_3419.field_15248, 0.75f, pitch);
        } else if (pRemainingUseDuration % 5 == 0) {
            float pitch = class_3532.method_15344((class_5819)pLevel.field_9229, (float)0.2f, (float)0.6f);
            pLevel.method_8396(null, pLivingEntity.method_24515(), (class_3414)SoundRegistry.STAFF_POWERS_UP.get(), class_3419.field_15248, 0.5f, pitch);
        }
        super.method_7852(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pHand) {
        class_1799 itemstack = pPlayer.method_5998(pHand);
        if (pPlayer.method_7357().method_7904(itemstack.method_7909())) {
            return class_1271.method_22431((Object)itemstack);
        }
        pPlayer.method_6019(pHand);
        return class_1271.method_22428((Object)itemstack);
    }

    public int method_7881(class_1799 pStack) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 pStack) {
        return class_1839.field_8953;
    }

    public class_243 getProjectileSpawnPos(class_1309 player, class_1268 hand, float distance, float spread) {
        int angle = hand == class_1268.field_5808 ? 225 : 90;
        double radians = Math.toRadians((float)angle - player.field_6241);
        return player.method_19538().method_1019(player.method_5720().method_1021((double)distance)).method_1031((double)spread * Math.sin(radians), (double)(player.method_17682() * 0.9f), (double)spread * Math.cos(radians));
    }
}

