/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities;

import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3468;

public class CatalystFlingerItem
extends class_1792 {
    public static final String STATE = "malum:state";
    public static final String STASHED_STATE = "malum:stashed_state";
    public static final String TIMER = "malum:timer";
    public final Function<class_1657, AbstractNitrateEntity> entitySupplier;

    public CatalystFlingerItem(class_1792.class_1793 pProperties, Function<class_1657, AbstractNitrateEntity> entitySupplier) {
        super(pProperties);
        this.entitySupplier = entitySupplier;
    }

    public void method_7888(class_1799 pStack, class_1937 pLevel, class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        class_2487 tag;
        int state;
        if (pStack.method_7985() && (state = (tag = pStack.method_7969()).method_10550(STATE)) != 0) {
            int timer = tag.method_10550(TIMER);
            if (pIsSelected && timer > 0) {
                tag.method_10551(TIMER);
                return;
            }
            if (!pIsSelected) {
                ++timer;
            }
            if (timer >= 100) {
                tag.method_10569(STASHED_STATE, state);
                tag.method_10551(STATE);
                tag.method_10551(TIMER);
                pEntity.method_5783((class_3414)SoundRegistry.CATALYST_LOBBER_LOCKED.get(), 1.2f, 0.8f);
                return;
            }
            tag.method_10569(TIMER, timer);
        }
        super.method_7888(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_3414 sound;
        class_1799 itemstack = playerIn.method_5998(handIn);
        class_2487 tag = itemstack.method_7948();
        int state = tag.method_10550(STATE);
        int cooldown = 0;
        switch (state) {
            case 0: {
                cooldown = 100;
                state = Math.max(1, tag.method_10550(STASHED_STATE));
                sound = (class_3414)SoundRegistry.CATALYST_LOBBER_UNLOCKED.get();
                break;
            }
            case 1: {
                class_1799 ammo = class_1799.field_8037;
                for (int i = 0; i < playerIn.method_31548().method_5439(); ++i) {
                    class_1799 maybeAmmo = playerIn.method_31548().method_5438(i);
                    if (!maybeAmmo.method_7909().equals(ItemRegistry.AURIC_EMBERS.get())) continue;
                    ammo = maybeAmmo;
                    break;
                }
                if (ammo.method_7960()) {
                    return class_1271.method_22431((Object)itemstack);
                }
                cooldown = 20;
                state = 2;
                ammo.method_7934(1);
                sound = (class_3414)SoundRegistry.CATALYST_LOBBER_PRIMED.get();
                break;
            }
            case 2: {
                if (!worldIn.field_9236) {
                    AbstractNitrateEntity bombEntity = this.entitySupplier.apply(playerIn);
                    int angle = handIn == class_1268.field_5808 ? 225 : 90;
                    class_243 pos = playerIn.method_19538().method_1019(playerIn.method_5720().method_1021(0.5)).method_1031(0.5 * Math.sin(Math.toRadians((float)angle - playerIn.field_6241)), (double)(playerIn.method_17682() * 2.0f / 3.0f), 0.5 * Math.cos(Math.toRadians((float)angle - playerIn.field_6241)));
                    float pitch = -10.0f;
                    bombEntity.method_24919((class_1297)playerIn, playerIn.method_36455(), playerIn.method_36454(), pitch, 1.25f, 0.9f);
                    bombEntity.method_33574(pos);
                    worldIn.method_8649((class_1297)bombEntity);
                }
                playerIn.method_7259(class_3468.field_15372.method_14956((Object)this));
                if (!playerIn.method_31549().field_7477) {
                    itemstack.method_7956(1, (class_1309)playerIn, p -> p.method_20236(handIn));
                }
                state = 1;
                sound = (class_3414)SoundRegistry.CATALYST_LOBBER_FIRED.get();
                break;
            }
            default: {
                tag.method_10551(STATE);
                throw new IllegalStateException("Nitrate lobber used with an invalid state.");
            }
        }
        tag.method_10569(STATE, state);
        if (cooldown != 0) {
            playerIn.method_7357().method_7906((class_1792)this, cooldown);
        }
        playerIn.method_5783(sound, 1.0f, 1.0f);
        return class_1271.method_29237((Object)itemstack, (boolean)worldIn.method_8608());
    }
}

