/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment;

import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class AbstractAugmentItem
extends class_1792 {
    public final MalumSpiritType spiritType;

    public AbstractAugmentItem(class_1792.class_1793 pProperties, MalumSpiritType spiritType) {
        super(pProperties);
        this.spiritType = spiritType;
    }

    public float getSpeedIncrease() {
        return 0.0f;
    }

    public float getFuelUsageRateIncrease() {
        return 0.0f;
    }

    public float getInstabilityIncrease() {
        return 0.0f;
    }

    public float getFortuneChance() {
        return 0.0f;
    }

    public float getChainFocusingChance() {
        return 0.0f;
    }

    public float getShieldingChance() {
        return 0.0f;
    }

    public float getRestorationChance() {
        return 0.0f;
    }

    public float getWeakestAttributeMultiplier() {
        return 0.0f;
    }

    public float getTuningStrengthIncrease() {
        return 0.0f;
    }

    public static Optional<AbstractAugmentItem> getAugmentType(class_1799 stack) {
        Optional<AbstractAugmentItem> optional;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)class_17922;
            optional = Optional.of(augmentItem);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltip, class_1836 pFlag) {
        pTooltip.add((class_2561)class_2561.method_43471((String)"malum.gui.augment.slot").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43471((String)("malum.gui.augment.type." + this.getAugmentTypeTranslator())).method_27692(class_124.field_1054)));
    }

    public static void addAugmentAttributeTooltip(class_1799 itemStack, class_1657 player, List<class_2561> components, class_1836 tooltipFlag) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)class_17922;
            List<class_2561> tooltip = components;
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43471((String)"malum.gui.augment.installed").method_27692(class_124.field_1065));
            AbstractAugmentItem.addAugmentStatComponent(tooltip, "malum.gui.crucible.attribute.tuning_potency", augmentItem.getTuningStrengthIncrease());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, "malum.gui.crucible.attribute.weakest_boost", augmentItem.getWeakestAttributeMultiplier());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.RESTORATION_CHANCE, augmentItem.getRestorationChance());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.SHIELDING_CHANCE, augmentItem.getShieldingChance());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.CHAIN_FOCUSING_CHANCE, augmentItem.getChainFocusingChance());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.FORTUNE_CHANCE, augmentItem.getFortuneChance());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.INSTABILITY, augmentItem.getInstabilityIncrease());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.FUEL_USAGE_RATE, augmentItem.getFuelUsageRateIncrease());
            AbstractAugmentItem.addAugmentStatComponent(tooltip, CrucibleTuning.CrucibleAttributeType.FOCUSING_SPEED, augmentItem.getSpeedIncrease());
        }
    }

    public String getAugmentTypeTranslator() {
        return "augment";
    }

    public static void addAugmentStatComponent(List<class_2561> tooltip, CrucibleTuning.CrucibleAttributeType attributeType, float value) {
        boolean inverse = attributeType.equals((Object)CrucibleTuning.CrucibleAttributeType.FUEL_USAGE_RATE) || attributeType.equals((Object)CrucibleTuning.CrucibleAttributeType.INSTABILITY);
        AbstractAugmentItem.makeAugmentStatComponent(attributeType, value, inverse).ifPresent(tooltip::add);
    }

    public static void addAugmentStatComponent(List<class_2561> tooltip, String id, float value) {
        AbstractAugmentItem.makeAugmentStatComponent(id, value, false).ifPresent(tooltip::add);
    }

    public static Optional<class_2561> makeAugmentStatComponent(CrucibleTuning.CrucibleAttributeType attributeType, float value, boolean inverse) {
        return AbstractAugmentItem.makeAugmentStatComponent(attributeType.translation(), value, inverse);
    }

    public static Optional<class_2561> makeAugmentStatComponent(String id, float value, boolean inverse) {
        if (value == 0.0f) {
            return Optional.empty();
        }
        boolean isPositive = value > 0.0f;
        String modifierSign = isPositive ? "attribute.modifier.plus.0" : "attribute.modifier.take.0";
        class_124 style = class_124.field_1078;
        if (inverse && isPositive || !inverse && !isPositive) {
            style = class_124.field_1061;
        }
        return Optional.of(class_2561.method_43469((String)modifierSign, (Object[])new Object[]{class_1799.field_8029.format(Math.abs(value)), class_2561.method_43471((String)id)}).method_27692(style));
    }
}

