/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.thrown;

import com.sammy.malum.common.item.food.ConcentratedGluttonyItem;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ThrownConcentratedGluttony
extends class_3857 {
    protected static final class_2940<Boolean> DATA_FADING_AWAY = class_2945.method_12791(ThrownConcentratedGluttony.class, (class_2941)class_2943.field_13323);
    public final List<TrailPointBuilder> trails = new ArrayList<TrailPointBuilder>(List.of(TrailPointBuilder.create((int)4), TrailPointBuilder.create((int)8), TrailPointBuilder.create((int)12)));
    public float spinOffset = (float)((double)this.field_5974.method_43057() * Math.PI * 2.0);
    public int age;
    public boolean fadingAway;
    public int fadingTimer;

    public ThrownConcentratedGluttony(class_1937 pLevel) {
        super((class_1299)EntityRegistry.THROWN_GLUTTONY.get(), pLevel);
    }

    public ThrownConcentratedGluttony(class_1937 pLevel, class_1309 pShooter) {
        super((class_1299)EntityRegistry.THROWN_GLUTTONY.get(), pShooter, pLevel);
    }

    public ThrownConcentratedGluttony(class_1937 pLevel, double pX, double pY, double pZ) {
        super((class_1299)EntityRegistry.THROWN_GLUTTONY.get(), pX, pY, pZ, pLevel);
    }

    protected void method_5693() {
        this.method_5841().method_12784(DATA_FADING_AWAY, (Object)false);
        super.method_5693();
    }

    public void method_5674(class_2940<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.field_6011.method_12789(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.method_18799(this.method_18798().method_1021((double)0.02f));
            }
        }
        super.method_5674(pKey);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.age != 0) {
            compound.method_10569("age", this.age);
        }
        if (this.fadingAway) {
            compound.method_10556("fadingAway", true);
            compound.method_10569("fadingTimer", this.fadingTimer);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.age = compound.method_10550("age");
        this.method_5841().method_12778(DATA_FADING_AWAY, (Object)compound.method_10577("fadingAway"));
    }

    protected class_1792 method_16942() {
        return (class_1792)ItemRegistry.SPLASH_OF_GLUTTONY.get();
    }

    protected float method_7490() {
        return this.fadingAway ? 0.0f : 0.05f;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            for (int i = 0; i < 3; ++i) {
                TrailPointBuilder trailPointBuilder = this.trails.get(i);
                float offsetScale = (float)i * 0.1f;
                if (this.fadingAway) {
                    offsetScale *= 1.0f + (float)this.fadingTimer / 4.0f;
                }
                for (int j = 0; j < 2; ++j) {
                    float progress = (float)(j + 1) * 0.5f;
                    class_243 position = this.method_30950(progress);
                    float scalar = ((float)i * 2.35f + (float)this.age + progress) / 2.0f;
                    double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                    double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                    trailPointBuilder.addTrailPoint(position.method_1031(xOffset, 0.0, zOffset));
                }
                trailPointBuilder.tickTrailPoints();
            }
        }
        ++this.age;
        if (this.fadingAway) {
            ++this.fadingTimer;
            if (this.fadingTimer >= 40) {
                this.method_31472();
            }
        }
    }

    protected void method_7488(class_239 pResult) {
        class_1297 class_12972;
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        if (this.fadingAway) {
            return;
        }
        if (pResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)pResult;
            class_12972 = entityHitResult.method_17782();
        } else {
            class_12972 = null;
        }
        class_1297 impactedEntity = class_12972;
        this.method_5841().method_12778(DATA_FADING_AWAY, (Object)true);
        this.method_18799(this.method_18798().method_1021((double)0.05f));
        level.method_20290(2002, this.method_24515(), ((class_1291)MobEffectRegistry.GLUTTONY.get()).method_5556());
        level.method_8396(null, this.method_24515(), (class_3414)SoundRegistry.CONCENTRATED_GLUTTONY_DRINK.get(), class_3419.field_15248, 0.5f, 1.25f + level.field_9229.method_43057() * 0.25f);
        ParticleEffectTypeRegistry.THROWN_GLUTTONY_IMPACT.createPositionedEffect(level, new PositionEffectData(this.method_19538()));
        this.applyGluttony(level, impactedEntity);
        super.method_7488(pResult);
    }

    private void applyGluttony(class_3218 level, @Nullable class_1297 impactedEntity) {
        List targets = level.method_18467(class_1309.class, this.method_5829().method_1009(3.0, 2.0, 3.0));
        if (!targets.isEmpty()) {
            class_1297 owner = this.method_37225();
            class_1293 gluttony = ConcentratedGluttonyItem.createGluttonyEffect(owner);
            for (class_1309 target : targets) {
                float durationScalar;
                int newDuration;
                double distance;
                if (!target.method_6086() || !((distance = this.method_5858((class_1297)target)) < 6.0) || (newDuration = gluttony.method_48558(arg_0 -> ThrownConcentratedGluttony.lambda$applyGluttony$0(durationScalar = target.equals((Object)impactedEntity) ? 1.0f : (float)(1.0 - Math.sqrt(distance) / 4.0), arg_0))) <= 20) continue;
                class_1293 appliedGluttony = ConcentratedGluttonyItem.createGluttonyEffect(owner, durationScalar);
                target.method_37222(appliedGluttony, owner);
                ConcentratedGluttonyItem.createGluttonyVFX(target, 0.25f);
            }
        }
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        } else if (this.fadingAway) {
            effectScalar = effectScalar * (float)(40 - this.fadingTimer) / 40.0f;
        }
        return effectScalar;
    }

    private static /* synthetic */ int lambda$applyGluttony$0(float durationScalar, int d) {
        return (int)((double)durationScalar * (double)d + 0.5);
    }
}

