/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.spirit;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;

public class SpiritItemEntity
extends FloatingItemEntity {
    public int soundCooldown;

    public SpiritItemEntity(class_1937 level) {
        super((class_1299<? extends FloatingEntity>)((class_1299)EntityRegistry.NATURAL_SPIRIT.get()), level);
        this.soundCooldown = 20 + this.field_5974.method_43048(100);
        this.maxAge = 4000;
    }

    public SpiritItemEntity(class_1937 level, UUID ownerUUID, class_1799 stack, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        this(level);
        this.setOwner(ownerUUID);
        this.setItem(stack);
        this.method_5814(posX, posY, posZ);
        this.method_18800(velX, velY, velZ);
        this.maxAge = 800;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof SpiritShardItem) {
            SpiritShardItem spiritShardItem = (SpiritShardItem)class_17922;
            this.setSpirit(spiritShardItem.type);
        }
    }

    @Override
    public void collect() {
        class_1799 stack = this.getItem();
        if (stack.method_7909() instanceof SpiritShardItem) {
            SpiritHarvestHandler.pickupSpirit(this.owner, stack);
        } else {
            ItemHelper.giveItemToEntity((class_1309)this.owner, (class_1799)stack);
        }
        if (this.field_5974.method_43057() < 0.6f) {
            this.method_37908().method_8396(null, this.method_24515(), (class_3414)SoundRegistry.SPIRIT_PICKUP.get(), class_3419.field_15254, 0.3f, class_3532.method_15344((class_5819)this.field_5974, (float)1.1f, (float)2.0f));
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.soundCooldown-- == 0) {
            if (this.field_5974.method_43057() < 0.4f) {
                this.method_37908().method_8396(null, this.method_24515(), (class_3414)SoundRegistry.ARCANE_WHISPERS.get(), class_3419.field_15254, 0.3f, class_3532.method_15344((class_5819)this.field_5974, (float)0.8f, (float)2.0f));
            }
            this.soundCooldown = this.field_5974.method_43048(40) + 40;
        }
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        class_243 motion = this.method_18798();
        class_243 norm = motion.method_1029().method_1021((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.method_37908(), new class_243(x, y, z), this.spiritType);
        lightSpecs.getBuilder().setMotion(norm);
        lightSpecs.getBloomBuilder().setMotion(norm);
        lightSpecs.spawnParticles();
    }

    @Override
    public float getMotionCoefficient() {
        return 0.01f;
    }
}

