/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.awt.Color;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class EthericNitrateEntity
extends AbstractNitrateEntity {
    public static final Color AURIC_YELLOW = new Color(239, 215, 75);
    public static final Color AURIC_PURPLE = new Color(236, 54, 163);
    public static final ColorParticleData AURIC_COLOR_DATA = ColorParticleData.create((Color)AURIC_YELLOW, (Color)AURIC_PURPLE).setEasing(Easing.SINE_IN_OUT).setCoefficient(0.9f).build();

    public EthericNitrateEntity(class_1937 level) {
        super((class_1299<? extends AbstractNitrateEntity>)((class_1299)EntityRegistry.ETHERIC_NITRATE.get()), level);
    }

    public EthericNitrateEntity(class_1309 owner) {
        super((class_1299<? extends AbstractNitrateEntity>)((class_1299)EntityRegistry.ETHERIC_NITRATE.get()), owner, owner.method_37908());
    }

    @Override
    public float getExplosionRadius() {
        return 2.25f;
    }

    @Override
    public int getMaxPierce() {
        return 3;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.ETHERIC_NITRATE_IMPACT;
    }

    @Override
    public ColorEffectData getImpactParticleEffectColor() {
        return new ColorEffectData(AURIC_YELLOW, AURIC_PURPLE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void spawnParticles() {
        float scalar;
        float f = scalar = this.age > 1190 ? 1.0f - (float)(this.age - 1200 + 10) / 10.0f : 1.0f;
        if (this.age < 5) {
            scalar = (float)this.age / 5.0f;
        }
        class_243 norm = this.method_18798().method_1029().method_1021((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.method_37908(), this.method_19538(), AURIC_COLOR_DATA);
        lightSpecs.getBuilder().multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.spawnParticles();
        Color startingSmokeColor = this.age < 3 ? AbstractNitrateEntity.SECOND_SMOKE_COLOR : AURIC_YELLOW;
        for (int i = 0; i < 3; ++i) {
            int lifetime = (int)((float)RandomHelper.randomBetween((class_5819)this.field_5974, (int)60, (int)80) * (1.0f - (float)i / 3.0f));
            SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)this.field_5974, (float)0.0f, (float)RandomHelper.randomBetween((class_5819)this.field_5974, (float)0.0f, (float)0.4f), (float)0.0f).randomSpinOffset(this.field_5974).build();
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.98f));
            WorldParticleBuilder.create(ParticleRegistry.STRANGE_SMOKE).setTransparencyData(GenericParticleData.create((float)(0.7f * scalar), (float)(0.9f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar), (float)(0.6f * scalar)).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)startingSmokeColor, (Color)AbstractNitrateEntity.SECOND_SMOKE_COLOR).setEasing(Easing.QUINTIC_OUT).build()).setLifetime(Math.min(6 + this.age * 3, lifetime)).setLifeDelay(1).enableNoClip().enableForcedSpawn().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).addTickActor(behavior).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(this.method_37908(), this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350);
        }
    }
}

