/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.NitrateExplosion;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractNitrateEntity
extends class_1682 {
    protected static final class_2940<Boolean> DATA_FADING_AWAY = class_2945.method_12791(AbstractNitrateEntity.class, (class_2941)class_2943.field_13323);
    public static final int MAX_AGE = 1200;
    public static final Color SECOND_SMOKE_COLOR = new Color(30, 30, 30);
    public static final float MAIN_TRAIL_LENGTH = 12.0f;
    public final TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)12);
    public final TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)6);
    public float spinOffset = (float)((double)this.field_5974.method_43057() * Math.PI * 2.0);
    public int age;
    public int timesExploded;
    public boolean fadingAway;

    public AbstractNitrateEntity(class_1299<? extends AbstractNitrateEntity> type, class_1937 level) {
        super(type, level);
    }

    public AbstractNitrateEntity(class_1299<? extends AbstractNitrateEntity> type, class_1309 owner, class_1937 level) {
        super(type, owner, level);
    }

    public void onExplode() {
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void spawnParticles();

    public abstract int getMaxPierce();

    public abstract float getExplosionRadius();

    public abstract ParticleEffectType getImpactParticleEffect();

    public abstract ColorEffectData getImpactParticleEffectColor();

    protected void method_5693() {
        this.method_5841().method_12784(DATA_FADING_AWAY, (Object)false);
    }

    public void method_5674(class_2940<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.field_6011.method_12789(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.age = 1180;
            }
        }
        super.method_5674(pKey);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.age != 0) {
            compound.method_10569("age", this.age);
        }
        if (this.timesExploded != 0) {
            compound.method_10569("timesExploded", this.timesExploded);
        }
        if (this.fadingAway) {
            compound.method_10556("fadingAway", true);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.age = compound.method_10550("age");
        this.timesExploded = compound.method_10550("pierce");
        this.method_5841().method_12778(DATA_FADING_AWAY, (Object)compound.method_10577("fadingAway"));
    }

    protected void method_7488(class_239 pResult) {
        if (this.fadingAway) {
            return;
        }
        NitrateExplosion.explode(this.method_37908(), (class_1297)this, this.method_23317(), this.method_23323(0.0625), this.method_23321(), this.getExplosionRadius(), class_1927.class_4179.field_18687);
        this.onExplode();
        if (!this.method_37908().field_9236) {
            this.getImpactParticleEffect().createPositionedEffect((class_3218)this.method_37908(), new PositionEffectData(this.method_19538()), this.getImpactParticleEffectColor());
        }
        if (this.timesExploded++ >= this.getMaxPierce()) {
            this.method_5841().method_12778(DATA_FADING_AWAY, (Object)true);
            this.method_18799(this.method_18798().method_1021((double)0.05f));
        }
        super.method_7488(pResult);
    }

    public void method_5773() {
        int i;
        super.method_5773();
        class_243 motion = this.method_18798();
        if (!this.fadingAway) {
            this.method_18800(motion.field_1352 * (double)0.99f, (motion.field_1351 - (double)0.015f) * (double)0.99f, motion.field_1350 * (double)0.99f);
        }
        float radialOffsetScale = this.fadingAway ? 0.0f : 0.15f;
        float randomOffsetScale = this.age > 5 ? Math.min((float)(this.age - 5) * 0.02f, 0.2f) : 0.0f;
        for (i = 0; i < 2; ++i) {
            float progress = (float)i * 0.5f;
            final class_243 position = this.method_30950(progress);
            final class_243 randomizedPosition = position.method_1031((double)(this.field_5974.method_43057() * randomOffsetScale), (double)(this.field_5974.method_43057() * randomOffsetScale), (double)(this.field_5974.method_43057() * randomOffsetScale));
            this.trailPointBuilder.addTrailPoint(new TrailPoint(position, i){

                public class_243 getPosition() {
                    return new class_243(class_3532.method_16436((double)((float)this.getTimeActive() / 12.0f), (double)position.field_1352, (double)randomizedPosition.field_1352), class_3532.method_16436((double)((float)this.getTimeActive() / 12.0f), (double)position.field_1351, (double)randomizedPosition.field_1351), class_3532.method_16436((double)((float)this.getTimeActive() / 12.0f), (double)position.field_1350, (double)randomizedPosition.field_1350));
                }
            });
            this.spinningTrailPointBuilder.addTrailPoint(new TrailPoint(position.method_1031(Math.cos(this.spinOffset + ((float)this.age + progress) / 2.0f) * (double)radialOffsetScale, 0.0, Math.sin(this.spinOffset + ((float)this.age + progress) / 2.0f) * (double)radialOffsetScale), i));
        }
        for (i = 0; i < (this.fadingAway || this.age > 1180 ? 2 : 1); ++i) {
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
        }
        ++this.age;
        if (this.age > 1200) {
            this.method_31472();
        }
        if (this.method_37908().field_9236 && !this.fadingAway && this.age > 1) {
            this.spawnParticles();
        }
    }

    public float getVisualEffectScalar() {
        float effectScalar;
        float f = effectScalar = this.fadingAway ? 1.0f - (float)(this.age - 1200 + 10) / 10.0f : 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        }
        return effectScalar;
    }

    public boolean method_5799() {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    public float method_5871() {
        return 4.0f;
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5659() {
        return true;
    }
}

