/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class HexBoltEntity
extends AbstractBoltProjectileEntity {
    public HexBoltEntity(class_1937 level) {
        super((class_1299<? extends AbstractBoltProjectileEntity>)((class_1299)EntityRegistry.HEX_BOLT.get()), level);
        this.field_5960 = false;
    }

    public HexBoltEntity(class_1937 level, double pX, double pY, double pZ) {
        this(level);
        this.method_5814(pX, pY, pZ);
        this.field_5960 = false;
    }

    @Override
    public int getMaxAge() {
        return 40;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.HEX_BOLT_IMPACT;
    }

    protected class_1792 method_16942() {
        return (class_1792)ItemRegistry.MNEMONIC_HEX_STAFF.get();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void spawnParticles() {
        class_1937 level = this.method_37908();
        class_243 position = this.method_19538();
        float scalar = this.getVisualEffectScalar();
        class_243 norm = this.method_18798().method_1029().method_1021((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, SpiritTypeRegistry.WICKED_SPIRIT);
        lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)this.field_5974, (float)RandomHelper.randomBetween((class_5819)this.field_5974, (float)0.25f, (float)0.5f)).randomSpinOffset(this.field_5974).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.95f));
        WorldParticleBuilder.create(ParticleRegistry.SAW, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(this.method_18798().method_1029())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(SpiritTypeRegistry.WICKED_SPIRIT.createColorData().build()).setLifetime(Math.min(6 + this.age * 3, 30)).enableNoClip().enableForcedSpawn().addTickActor(behavior).spawn(level, position.field_1352, position.field_1351, position.field_1350).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }
}

