/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AuricFlameStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_3999;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;

public class AuricFlameBoltEntity
extends AbstractBoltProjectileEntity {
    public AuricFlameBoltEntity(class_1937 level) {
        super((class_1299<? extends AbstractBoltProjectileEntity>)((class_1299)EntityRegistry.AURIC_FLAME_BOLT.get()), level);
        this.field_5960 = false;
    }

    public AuricFlameBoltEntity(class_1937 level, double pX, double pY, double pZ) {
        this(level);
        this.method_5814(pX, pY, pZ);
        this.field_5960 = false;
    }

    @Override
    protected void method_24920(class_3965 pResult) {
        class_238 boundingBox = this.method_5829();
        this.method_5857(boundingBox.method_1011(0.5));
        class_239 hitresult = class_1675.method_49997((class_1297)this, this::method_26958);
        if (hitresult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitresult;
            super.method_24920(blockHitResult);
        }
        this.method_5857(boundingBox);
    }

    @Override
    protected void method_7454(class_3966 result) {
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        class_1297 class_12972 = result.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 livingentity = (class_1309)class_12972;
            livingentity.method_5639(4);
        }
        super.method_7454(result);
    }

    public void method_5783(class_3414 pSound, float pVolume, float pPitch) {
        super.method_5783(pSound, pVolume, pPitch);
        super.method_5783((class_3414)SoundRegistry.AURIC_FLAME_MOTIF.get(), pVolume + 0.1f, pPitch + 0.6f);
    }

    @Override
    public int getMaxAge() {
        return 80;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.AURIC_BOLT_IMPACT;
    }

    protected class_1792 method_16942() {
        return (class_1792)ItemRegistry.STAFF_OF_THE_AURIC_FLAME.get();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void spawnParticles() {
        class_1937 level = this.method_37908();
        class_243 position = this.method_19538();
        float scalar = this.getVisualEffectScalar();
        class_243 norm = this.method_18798().method_1029().method_1021((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, AuricFlameStaffItem.AURIC_COLOR_DATA);
        lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.98f));
        float min = Math.min(1.0f, 2.0f * scalar);
        WorldParticleBuilder.create(ParticleRegistry.BOLT, (LodestoneBehaviorComponent)new SparkBehaviorComponent(GenericParticleData.create((float)(2.0f * min), (float)(0.2f * min)).setEasing(Easing.CUBIC_IN).build())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.5f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.6f * scalar), (float)(0.1f * min)).setEasing(Easing.QUAD_OUT).build()).setColorData(AuricFlameStaffItem.AURIC_COLOR_DATA).setLifetime(Math.min(6 + this.age * 3, 15)).setMotion(norm).enableNoClip().enableForcedSpawn().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX).addTickActor(behavior).spawn(level, position.field_1352, position.field_1351, position.field_1350).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, position.field_1352, position.field_1351, position.field_1350);
    }
}

