/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.staff.HexBoltImpactParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractBoltProjectileEntity
extends class_3857 {
    protected static final class_2940<Boolean> DATA_FADING_AWAY = class_2945.method_12791(AbstractBoltProjectileEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> DATA_SPAWN_DELAY = class_2945.method_12791(AbstractBoltProjectileEntity.class, (class_2941)class_2943.field_13327);
    public final TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)8);
    public final TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)16);
    public float spinOffset = (float)((double)this.field_5974.method_43057() * Math.PI * 2.0);
    protected float magicDamage;
    public int age;
    public int spawnDelay;
    public boolean fadingAway;
    public int fadingTimer;

    public AbstractBoltProjectileEntity(class_1299<? extends AbstractBoltProjectileEntity> pEntityType, class_1937 level) {
        super(pEntityType, level);
        this.field_5960 = false;
    }

    public void setData(class_1297 owner, float magicDamage, int spawnDelay) {
        this.method_7432(owner);
        this.magicDamage = magicDamage;
        this.method_5841().method_12778(DATA_SPAWN_DELAY, (Object)spawnDelay);
        if (!this.method_37908().field_9236 && spawnDelay == 0) {
            this.method_5783((class_3414)SoundRegistry.STAFF_FIRES.get(), 0.5f, class_3532.method_15344((class_5819)this.field_5974, (float)0.9f, (float)1.5f));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void spawnParticles();

    public abstract int getMaxAge();

    public abstract ParticleEffectType getImpactParticleEffect();

    public float getOrbitingTrailDistance() {
        return 0.3f;
    }

    public void onDealDamage(class_1309 target) {
    }

    protected void method_5693() {
        this.method_5841().method_12784(DATA_FADING_AWAY, (Object)false);
        this.method_5841().method_12784(DATA_SPAWN_DELAY, (Object)0);
        super.method_5693();
    }

    public void method_5674(class_2940<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.field_6011.method_12789(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.age = this.getMaxAge() - 10;
                this.method_18799(this.method_18798().method_1021((double)0.02f));
            }
        }
        if (DATA_SPAWN_DELAY.equals(pKey)) {
            this.spawnDelay = (Integer)this.field_6011.method_12789(DATA_SPAWN_DELAY);
        }
        super.method_5674(pKey);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.magicDamage != 0.0f) {
            compound.method_10548("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.method_10569("age", this.age);
        }
        if (this.spawnDelay != 0) {
            compound.method_10569("spawnDelay", this.spawnDelay);
        }
        if (this.fadingAway) {
            compound.method_10556("fadingAway", true);
            compound.method_10569("fadingTimer", this.fadingTimer);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.magicDamage = compound.method_10583("magicDamage");
        this.age = compound.method_10550("age");
        this.method_5841().method_12778(DATA_SPAWN_DELAY, (Object)compound.method_10550("spawnDelay"));
        this.method_5841().method_12778(DATA_FADING_AWAY, (Object)compound.method_10577("fadingAway"));
    }

    protected void method_24920(class_3965 pResult) {
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        if (!this.method_37908().field_9236) {
            this.getImpactParticleEffect().createPositionedEffect((class_3218)this.method_37908(), new PositionEffectData(this.method_19538().method_1019(this.method_18798().method_1021(0.25))), new ColorEffectData(SpiritTypeRegistry.WICKED_SPIRIT), HexBoltImpactParticleEffect.createData(this.method_18798().method_22882().method_1029()));
            this.method_5783((class_3414)SoundRegistry.STAFF_STRIKES.get(), 0.5f, class_3532.method_15344((class_5819)this.field_5974, (float)0.9f, (float)1.5f));
            this.method_5841().method_12778(DATA_FADING_AWAY, (Object)true);
            class_243 direction = pResult.method_17784().method_1020(this.method_19538());
            class_243 offset = direction.method_1029().method_1021(0.5);
            this.method_23327(this.method_23317() - offset.field_1352, this.method_23318() - offset.field_1351, this.method_23321() - offset.field_1350);
        }
        super.method_24920(pResult);
    }

    protected boolean method_26958(class_1297 pTarget) {
        if (pTarget.equals((Object)this.method_24921())) {
            return false;
        }
        if (pTarget instanceof AbstractBoltProjectileEntity) {
            return false;
        }
        return super.method_26958(pTarget);
    }

    protected void method_7454(class_3966 result) {
        if (this.method_37908().field_9236 || this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 staffOwner = (class_1309)class_12972;
            class_1297 target = result.method_17782();
            target.field_6008 = 0;
            class_1282 source = DamageTypeRegistry.create(this.method_37908(), DamageTypeRegistry.VOODOO, (class_1297)this, (class_1297)staffOwner);
            boolean success = target.method_5643(source, this.magicDamage);
            if (success && target instanceof class_1309) {
                class_1309 livingentity = (class_1309)target;
                this.onDealDamage(livingentity);
                class_1799 staff = this.method_7495();
                ItemHelper.applyEnchantments((class_1309)staffOwner, (class_1297)livingentity, (class_1799)staff);
                int i = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)staff);
                if (i > 0) {
                    livingentity.method_5639(i * 4);
                }
                this.method_5841().method_12778(DATA_FADING_AWAY, (Object)true);
                this.getImpactParticleEffect().createPositionedEffect((class_3218)this.method_37908(), new PositionEffectData(this.method_19538().method_1019(this.method_18798().method_1021(0.5))), new ColorEffectData(SpiritTypeRegistry.WICKED_SPIRIT), HexBoltImpactParticleEffect.createData(this.method_18798().method_22882().method_1029()));
                this.method_5783((class_3414)SoundRegistry.STAFF_STRIKES.get(), 0.75f, class_3532.method_15344((class_5819)this.field_5974, (float)1.0f, (float)1.4f));
                this.method_18799(this.method_18798().method_1021((double)0.05f));
            }
        }
        super.method_7454(result);
    }

    public void method_5773() {
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            if (this.spawnDelay == 0 && !this.method_37908().field_9236) {
                this.spawnDelay = -1;
                this.method_5783((class_3414)SoundRegistry.STAFF_FIRES.get(), 0.5f, class_3532.method_15344((class_5819)this.field_5974, (float)0.9f, (float)1.5f));
            }
            return;
        }
        super.method_5773();
        ++this.age;
        if (this.fadingAway) {
            ++this.fadingTimer;
        } else {
            class_243 motion = this.method_18798();
            float scalar = 0.96f;
            this.method_18800(motion.field_1352 * (double)scalar, (motion.field_1351 - (double)0.015f) * (double)scalar, motion.field_1350 * (double)scalar);
        }
        if (this.method_37908().field_9236) {
            float offsetScale = this.fadingAway ? 0.0f : this.getOrbitingTrailDistance();
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                class_243 position = this.method_30950(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.trailPointBuilder.addTrailPoint(position);
                this.spinningTrailPointBuilder.addTrailPoint(position.method_1031(xOffset, 0.0, zOffset));
            }
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
            if (!this.fadingAway) {
                this.spawnParticles();
            }
        } else if (this.age >= this.getMaxAge()) {
            if (this.fadingAway) {
                this.method_31472();
            } else {
                this.method_5841().method_12778(DATA_FADING_AWAY, (Object)true);
            }
        }
    }

    public void method_5750(double pX, double pY, double pZ) {
        this.method_18800(pX, pY, pZ);
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double d0 = Math.sqrt(pX * pX + pZ * pZ);
            this.method_36457((float)(class_3532.method_15349((double)pY, (double)d0) * 57.2957763671875));
            this.method_36456((float)(class_3532.method_15349((double)pX, (double)pZ) * 57.2957763671875));
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        }
    }

    public void method_24919(class_1297 shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -class_3532.method_15374((float)(rotationYaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -class_3532.method_15374((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(rotationYaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitch * ((float)Math.PI / 180)));
        this.method_7485(f, f1, f2, velocity, innacuracy);
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        } else if (this.fadingAway) {
            effectScalar /= (float)(this.fadingTimer + 2) / 2.0f;
        }
        return effectScalar;
    }

    public boolean method_5799() {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    public float method_5871() {
        return 4.0f;
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5659() {
        return true;
    }
}

