/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class FloatingEntity
extends class_1297 {
    public final TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)10);
    public int age;
    public int maxAge;
    public float windUp;
    public float hoverOffset;
    public UUID ownerUUID;
    public class_1309 owner;

    public FloatingEntity(class_1299<? extends FloatingEntity> type, class_1937 level) {
        super(type, level);
        this.field_5960 = false;
        this.hoverOffset = (float)(Math.random() * Math.PI * 2.0);
    }

    public void spawnParticles(double x, double y, double z) {
    }

    public class_243 getDestination() {
        if (this.owner != null) {
            return this.owner.method_19538().method_1031(0.0, (double)(this.owner.method_17682() / 3.0f), 0.0);
        }
        return null;
    }

    public abstract void collect();

    public abstract float getMotionCoefficient();

    public float getFriction() {
        return 0.95f;
    }

    public void method_5652(class_2487 compound) {
        compound.method_10569("age", this.age);
        compound.method_10569("maxAge", this.maxAge);
        compound.method_10548("windUp", this.windUp);
        if (this.ownerUUID != null) {
            compound.method_25927("ownerUUID", this.ownerUUID);
        }
    }

    public void method_5749(class_2487 compound) {
        this.age = compound.method_10550("age");
        this.maxAge = compound.method_10550("maxAge");
        this.windUp = compound.method_10583("windUp");
        if (compound.method_10545("ownerUUID")) {
            this.setOwner(compound.method_25926("ownerUUID"));
        }
    }

    public void method_5773() {
        class_3965 result;
        super.method_5773();
        this.method_5670();
        this.hoverOffset = this.getHoverStart(0.0f);
        ++this.age;
        if (this.age > this.maxAge) {
            this.method_31472();
        }
        float friction = this.getFriction();
        this.method_18799(this.method_18798().method_18805((double)friction, (double)friction, (double)friction));
        if (this.method_5805()) {
            class_243 destination;
            class_1657 playerEntity;
            if (!(this.owner != null && this.owner.method_5805() || this.method_37908().method_8510() % 40L != 0L || (playerEntity = this.method_37908().method_18460((class_1297)this, 50.0)) == null)) {
                this.setOwner(playerEntity.method_5667());
            }
            if ((destination = this.getDestination()) != null) {
                if (this.windUp < 1.0f) {
                    this.windUp += 0.02f;
                }
                float velocity = class_3532.method_15363((float)(this.windUp - 0.25f), (float)0.0f, (float)0.75f) * 5.0f;
                class_243 desiredMotion = destination.method_1020(this.method_19538()).method_1029().method_18805((double)velocity, (double)velocity, (double)velocity);
                float easing = this.getMotionCoefficient();
                float xMotion = (float)class_3532.method_16436((double)easing, (double)this.method_18798().field_1352, (double)desiredMotion.field_1352);
                float yMotion = (float)class_3532.method_16436((double)easing, (double)this.method_18798().field_1351, (double)desiredMotion.field_1351);
                float zMotion = (float)class_3532.method_16436((double)easing, (double)this.method_18798().field_1350, (double)desiredMotion.field_1350);
                class_243 resultingMotion = new class_243((double)xMotion, (double)yMotion, (double)zMotion);
                this.method_18799(resultingMotion);
                float distance = (float)this.method_5707(destination);
                if (distance < 0.4f) {
                    this.collect();
                    this.method_5650(class_1297.class_5529.field_26999);
                    return;
                }
            }
        }
        if ((result = this.method_37908().method_17742(new class_3959(this.method_19538(), this.method_19538().method_1019(this.method_18798()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this))).method_17783() == class_239.class_240.field_1332) {
            class_2586 blockentity;
            class_2338 blockpos = result.method_17777();
            class_2680 blockstate = this.method_37908().method_8320(blockpos);
            if (blockstate.method_27852(class_2246.field_10316)) {
                this.method_5717(blockpos);
            } else if (blockstate.method_27852(class_2246.field_10613) && (blockentity = this.method_37908().method_8321(blockpos)) instanceof class_2643 && class_2643.method_30276((class_1297)this)) {
                class_2643.method_11409((class_1937)this.method_37908(), (class_2338)blockpos, (class_2680)blockstate, (class_1297)this, (class_2643)((class_2643)blockentity));
            }
        }
        this.method_5852();
        class_243 movement = this.method_18798();
        double nextX = this.method_23317() + movement.field_1352;
        double nextY = this.method_23318() + movement.field_1351;
        double nextZ = this.method_23321() + movement.field_1350;
        double distance = movement.method_37267();
        float xRot = FloatingEntity.lerpRotation(this.field_6004, (float)(class_3532.method_15349((double)movement.field_1351, (double)distance) * 57.2957763671875));
        float yRot = FloatingEntity.lerpRotation(this.field_5982, (float)(class_3532.method_15349((double)movement.field_1352, (double)movement.field_1350) * 57.2957763671875));
        this.method_36457(xRot);
        this.method_36456(yRot);
        this.method_5814(nextX, nextY, nextZ);
        class_1675.method_7484((class_1297)this, (float)0.2f);
        if (this.method_37908().field_9236) {
            double x = this.field_6038;
            double y = this.field_5971 + (double)this.getYOffset(0.0f);
            double z = this.field_5989;
            this.spawnParticles(x, y, z);
            for (int i = 0; i < 2; ++i) {
                float f;
                float progress = (float)(i + 1) * 0.5f;
                class_243 position = this.method_30950(progress).method_1031(0.0, (double)this.getYOffset(progress), 0.0);
                this.trailPointBuilder.addTrailPoint(position);
                if (i == 0) {
                    f = 0.0f;
                }
                if (i != 1) continue;
                f = 0.0f;
            }
            this.trailPointBuilder.tickTrailPoints();
        }
    }

    public void method_5750(double pX, double pY, double pZ) {
        this.method_18800(pX, pY, pZ);
        this.method_22862();
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, this.owner == null ? 0 : this.owner.method_5628());
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return class_3532.method_16439((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    public float getYOffset(float partialTicks) {
        return class_3532.method_15374((float)(((float)this.age + partialTicks) / 10.0f + this.getHoverStart(partialTicks))) * 0.1f + 0.35f;
    }

    public float getRotation(float partialTicks) {
        return ((float)this.age + partialTicks) / 20.0f + this.getHoverStart(partialTicks) / 2.0f;
    }

    public float getHoverStart(float partialTicks) {
        return this.hoverOffset + (1.0f - Easing.SINE_OUT.ease(Math.min(1.0f, ((float)this.age + partialTicks) / 60.0f), 0.0f, 1.0f, 1.0f)) * 0.35f;
    }

    public void setOwner(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.owner = (class_1309)serverLevel.method_14190(ownerUUID);
        }
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }
}

