/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.jar;

import com.sammy.malum.common.item.curiosities.SpiritPouchItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.container.ItemInventory;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class SpiritJarBlockEntity
extends LodestoneBlockEntity {
    public MalumSpiritType type;
    public int count;
    private long lastClickTime;
    private UUID lastClickUUID;
    public final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(){

        public int getSlotCount() {
            return 2;
        }

        @NotNull
        public class_1799 getStackInSlot(int slot) {
            if (slot == 0 && SpiritJarBlockEntity.this.type != null) {
                return new class_1799((class_1935)SpiritJarBlockEntity.this.type.spiritShard.get(), SpiritJarBlockEntity.this.count);
            }
            return class_1799.field_8037;
        }

        public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_1792 class_17922;
            if (slot == 1 && (class_17922 = resource.getItem()) instanceof SpiritShardItem) {
                SpiritShardItem spiritItem = (SpiritShardItem)class_17922;
                if (SpiritJarBlockEntity.this.type == null || spiritItem.type == SpiritJarBlockEntity.this.type) {
                    if (SpiritJarBlockEntity.this.type == null) {
                        SpiritJarBlockEntity.this.type = spiritItem.type;
                    }
                    SpiritJarBlockEntity.this.count += resource.toStack().method_7947();
                    if (!((SpiritJarBlockEntity)SpiritJarBlockEntity.this).field_11863.field_9236) {
                        BlockHelper.updateAndNotifyState((class_1937)SpiritJarBlockEntity.this.field_11863, (class_2338)SpiritJarBlockEntity.this.field_11867);
                    }
                }
            }
            return super.insertSlot(slot, resource, maxAmount, transaction);
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return Math.min(64, SpiritJarBlockEntity.this.count);
            }
            return 64;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            class_1792 class_17922 = resource.getItem();
            if (!(class_17922 instanceof SpiritShardItem)) return false;
            SpiritShardItem spiritItem = (SpiritShardItem)class_17922;
            if (spiritItem.type != SpiritJarBlockEntity.this.type) return false;
            return true;
        }
    });

    public SpiritJarBlockEntity(class_2591<? extends SpiritJarBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SpiritJarBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends SpiritJarBlockEntity>)((class_2591)BlockEntityRegistry.SPIRIT_JAR.get()), pos, state);
    }

    public class_1799 extractItem(int slot, int amount) {
        if (slot != 0 || this.count <= 0) {
            return class_1799.field_8037;
        }
        MalumSpiritType extractedType = this.type;
        if (extractedType == null) {
            return class_1799.field_8037;
        }
        int amountToExtract = Math.min(this.count, amount);
        this.count -= amountToExtract;
        if (this.count == 0) {
            this.type = null;
        }
        if (!this.field_11863.field_9236) {
            BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
        }
        return new class_1799((class_1935)extractedType.spiritShard.get(), amountToExtract);
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (this.method_10997() == null) {
            return class_1269.field_5811;
        }
        int count = this.method_10997().method_8510() - this.lastClickTime < 10L && player.method_5667().equals(this.lastClickUUID) ? this.insertAllSpirits(player) : this.insertHeldItem(player);
        this.lastClickTime = this.method_10997().method_8510();
        this.lastClickUUID = player.method_5667();
        if (count != 0) {
            if (player.method_37908().field_9236) {
                this.spawnUseParticles(this.field_11863, this.field_11867, this.type);
            } else {
                BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
            }
        }
        return class_1269.method_29236((boolean)player.method_37908().field_9236);
    }

    public int insertHeldItem(class_1657 player) {
        int count = 0;
        class_1799 playerStack = player.method_31548().method_7391();
        if (!playerStack.method_7960()) {
            count = this.insertFromStack(playerStack);
        }
        return count;
    }

    public int insertAllSpirits(class_1657 player) {
        if (this.type == null) {
            return 0;
        }
        int count = 0;
        int n = player.method_31548().method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 subStack = player.method_31548().method_5438(i);
            if (subStack.method_7960()) continue;
            int subCount = this.insertFromStack(subStack);
            if (subCount > 0 && subStack.method_7947() == 0) {
                player.method_31548().method_5447(i, class_1799.field_8037);
            }
            count += subCount;
        }
        return count;
    }

    public int insertFromStack(class_1799 stack) {
        int inserted = 0;
        if (stack.method_7909() instanceof SpiritPouchItem) {
            if (this.type != null) {
                ItemInventory inventory = SpiritPouchItem.getInventory(stack);
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 spiritStack = inventory.method_5438(i);
                    class_1792 class_17922 = spiritStack.method_7909();
                    if (!(class_17922 instanceof SpiritShardItem)) continue;
                    SpiritShardItem spiritItem = (SpiritShardItem)class_17922;
                    MalumSpiritType type = spiritItem.type;
                    if (!type.identifier.equals(this.type.identifier)) continue;
                    inventory.method_5447(i, class_1799.field_8037);
                    inserted += spiritStack.method_7947();
                    this.count += spiritStack.method_7947();
                }
            }
        } else {
            class_1792 class_17923 = stack.method_7909();
            if (class_17923 instanceof SpiritShardItem) {
                SpiritShardItem spiritSplinterItem = (SpiritShardItem)class_17923;
                if (this.type == null || this.type.equals(spiritSplinterItem.type)) {
                    this.type = spiritSplinterItem.type;
                    inserted += stack.method_7947();
                    this.count += stack.method_7947();
                    stack.method_7934(stack.method_7947());
                }
            }
        }
        return inserted;
    }

    public void onPlace(class_1309 placer, class_1799 stack) {
        if (stack.method_7985()) {
            this.method_11014(stack.method_7969());
        }
        this.method_5431();
    }

    protected void method_11007(class_2487 compound) {
        if (this.type != null) {
            compound.method_10582("spirit", this.type.identifier);
        }
        compound.method_10569("count", this.count);
    }

    public void method_11014(@NotNull class_2487 compound) {
        this.type = compound.method_10545("spirit") ? SpiritHarvestHandler.getSpiritType(compound.method_10558("spirit")) : null;
        this.count = compound.method_10550("count");
        super.method_11014(compound);
    }

    public void tick() {
        if (this.field_11863.field_9236 && this.type != null) {
            SpiritLightSpecs.rotatingLightSpecs(this.field_11863, this.getItemPos(), this.type, 0.4f, 3);
        }
    }

    public class_243 getItemPos() {
        double time = (float)this.field_11863.method_8510() * 0.05f % 6.28f;
        double x = (float)this.method_11016().method_10263() + 0.5f;
        double y = (float)this.method_11016().method_10264() + 0.5f + (float)Math.sin(time) * 0.2f;
        double z = (float)this.method_11016().method_10260() + 0.5f;
        return new class_243(x, y, z);
    }

    @Environment(value=EnvType.CLIENT)
    public void spawnUseParticles(class_1937 level, class_2338 pos, MalumSpiritType type) {
        Color color = type.getPrimaryColor();
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.15f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.2f).build()).setColorData(ColorParticleData.create((Color)color, (Color)color.darker()).build()).setLifetime(20).setRandomMotion((double)0.02f).setRandomOffset((double)0.1f, (double)0.1f).enableNoClip().repeat(level, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f) + Math.sin((float)level.method_8510() / 20.0f) * (double)0.2f, (double)((float)pos.method_10260() + 0.5f), 10);
    }
}

