/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.ether;

import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.common.block.ether.EtherTorchBlock;
import com.sammy.malum.common.block.ether.EtherWallTorchBlock;
import com.sammy.malum.common.item.ether.AbstractEtherItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2555;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class EtherBlockEntity
extends LodestoneBlockEntity {
    public Color firstColor;
    public Color secondColor;

    public EtherBlockEntity(class_2591<? extends EtherBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public EtherBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends EtherBlockEntity>)((class_2591)BlockEntityRegistry.ETHER.get()), pos, state);
    }

    public void setFirstColor(int rgb) {
        this.firstColor = new Color(rgb);
    }

    public void setSecondColor(int rgb) {
        this.secondColor = new Color(rgb);
    }

    public void method_11014(class_2487 compound) {
        this.setFirstColor(compound.method_10545("firstColor") ? compound.method_10550("firstColor") : 15712278);
        class_1792 class_17922 = this.method_11010().method_26204().method_8389();
        if (class_17922 instanceof AbstractEtherItem) {
            AbstractEtherItem etherItem = (AbstractEtherItem)class_17922;
            if (etherItem.iridescent) {
                this.setSecondColor(compound.method_10545("secondColor") ? compound.method_10550("secondColor") : 4607909);
            }
        }
        super.method_11014(compound);
    }

    protected void method_11007(class_2487 compound) {
        class_1792 class_17922;
        if (this.firstColor != null) {
            compound.method_10569("firstColor", this.firstColor.getRGB());
        }
        if ((class_17922 = this.method_11010().method_26204().method_8389()) instanceof AbstractEtherItem) {
            AbstractEtherItem etherItem = (AbstractEtherItem)class_17922;
            if (etherItem.iridescent && this.secondColor != null && this.secondColor.getRGB() != 4607909) {
                compound.method_10569("secondColor", this.secondColor.getRGB());
            }
        }
        super.method_11007(compound);
    }

    public void onPlace(class_1309 placer, class_1799 stack) {
        AbstractEtherItem item = (AbstractEtherItem)stack.method_7909();
        this.setFirstColor(item.getFirstColor(stack));
        if (item.iridescent) {
            this.setSecondColor(item.getSecondColor(stack));
        }
    }

    public class_1799 onClone(class_2680 state, class_1922 level, class_2338 pos) {
        class_1799 stack = state.method_26204().method_8389().method_7854();
        AbstractEtherItem etherItem = (AbstractEtherItem)stack.method_7909();
        if (this.firstColor != null) {
            etherItem.setFirstColor(stack, this.firstColor.getRGB());
        }
        if (this.secondColor != null) {
            etherItem.setSecondColor(stack, this.secondColor.getRGB());
        }
        return super.onClone(state, level, pos);
    }

    public void init() {
        if (!this.field_11863.field_9236) {
            BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
        }
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            float velocity;
            float scale;
            if (this.firstColor == null) {
                return;
            }
            class_5819 random = this.field_11863.field_9229;
            class_2248 block = this.method_11010().method_26204();
            Color firstColor = ColorHelper.darker((Color)this.firstColor, (int)1);
            Color secondColor = this.secondColor == null ? firstColor : ColorHelper.brighter((Color)this.secondColor, (int)1);
            double x = (float)this.field_11867.method_10263() + 0.5f;
            double y = (float)this.field_11867.method_10264() + 0.5f;
            double z = (float)this.field_11867.method_10260() + 0.5f;
            if (block instanceof EtherWallTorchBlock) {
                float offset = 0.15f;
                class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2555.field_11731);
                x -= (double)((float)direction.method_10163().method_10263() * 0.15f);
                y += (double)0.4f;
                z -= (double)((float)direction.method_10163().method_10260() * 0.15f);
            } else if (block instanceof EtherTorchBlock) {
                y += (double)0.3f;
            } else if (block instanceof EtherBrazierBlock) {
                y -= (double)0.05f;
            }
            ColorParticleData colorData = ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.5f).setEasing(Easing.BOUNCE_IN_OUT).build();
            if (this.field_11863.method_8510() % 8L == 0L) {
                int lifeTime = RandomHelper.randomBetween((class_5819)random, (int)40, (int)60);
                scale = RandomHelper.randomBetween((class_5819)random, (float)0.6f, (float)0.7f);
                velocity = RandomHelper.randomBetween((class_5819)random, (float)0.02f, (float)0.03f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.field_11863, new class_243(x, y, z), colorData);
                lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(lifeTime).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.3f, (float)0.6f, (float)0.0f).build()).addMotion(0.0, (double)(velocity * 1.2f), 0.0);
                lightSpecs.spawnParticlesRaw();
            }
            if (this.field_11863.method_8510() % 2L == 0L) {
                int lifeTime = RandomHelper.randomBetween((class_5819)random, (int)12, (int)14);
                scale = RandomHelper.randomBetween((class_5819)random, (float)0.16f, (float)0.2f);
                velocity = RandomHelper.randomBetween((class_5819)random, (float)0.02f, (float)0.03f);
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build()).setTransparencyData(GenericParticleData.create((float)0.4f, (float)0.8f, (float)0.2f).setEasing(Easing.QUAD_OUT).build()).setColorData(colorData).setSpinData(SpinParticleData.create((float)0.2f, (float)0.4f).setSpinOffset((float)this.field_11863.method_8510() * 0.2f % 6.28f).setEasing(Easing.QUARTIC_IN).build()).setLifetime(lifeTime).addMotion(0.0, (double)(velocity * 1.5f), 0.0).enableNoClip().spawn(this.field_11863, x, y, z);
                lifeTime = 20;
                scale = 0.4f;
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.TWINKLE_PARTICLE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).build()).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.8f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setEasing(Easing.SINE_IN).setCoefficient(0.5f).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.0f, (float)0.4f).setEasing(Easing.QUARTIC_IN).build()).setLifetime(lifeTime).enableNoClip().spawn(this.field_11863, x, y, z);
            }
            if (this.field_11863.method_8510() % 4L == 0L) {
                long gameTime = this.field_11863.method_8510();
                float scale2 = RandomHelper.randomBetween((class_5819)random, (float)0.6f, (float)0.75f);
                float velocity2 = RandomHelper.randomBetween((class_5819)random, (float)0.0f, (float)0.02f);
                float angle = (float)(gameTime % 24L) / 24.0f * (float)Math.PI * 2.0f;
                class_243 offset = new class_243(Math.sin(angle), 0.0, Math.cos(angle)).method_1029();
                class_243 offsetPosition = new class_243(x + offset.field_1352 * (double)0.075f, y - (double)0.05f, z + offset.field_1350 * (double)0.075f);
                WorldParticleBuilder.create(ParticleRegistry.SPIRIT_FLAME_PARTICLE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(GenericParticleData.create((float)(scale2 * 0.75f), (float)scale2, (float)0.0f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setEasing(Easing.CIRC_IN_OUT).setCoefficient(2.5f).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)1.0f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.QUAD_IN).setCoefficient(3.5f).build()).addMotion(0.0, (double)velocity2, 0.0).addTickActor(p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)(1.0f - random.method_43057() * 0.0f)))).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(this.field_11863, offsetPosition.field_1352, offsetPosition.field_1351, offsetPosition.field_1350);
            }
        }
    }
}

