/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.weeping_well;

import com.sammy.malum.common.recipe.FavorOfTheVoidRecipe;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.RadiantParticleEffects;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class VoidConduitBlockEntity
extends LodestoneBlockEntity
implements CustomRenderBoundingBoxBlockEntity {
    public final List<class_1799> eatenItems = new ArrayList<class_1799>();
    public int progress;
    public int streak;
    public int lingeringRadiance;

    public VoidConduitBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntityRegistry.VOID_CONDUIT.get(), pos, state);
    }

    protected void method_11007(class_2487 compound) {
        if (!this.eatenItems.isEmpty()) {
            compound.method_10569("itemCount", this.eatenItems.size());
            for (int i = 0; i < this.eatenItems.size(); ++i) {
                class_2487 itemTag = new class_2487();
                class_1799 stack = this.eatenItems.get(i);
                stack.method_7953(itemTag);
                compound.method_10566("item_" + i, (class_2520)itemTag);
            }
        }
        compound.method_10569("progress", this.progress);
        compound.method_10569("streak", this.streak);
        compound.method_10569("lingeringRadiance", this.lingeringRadiance);
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        this.eatenItems.clear();
        for (int i = 0; i < compound.method_10550("itemCount"); ++i) {
            class_2487 itemTag = compound.method_10562("item_" + i);
            this.eatenItems.add(class_1799.method_7915((class_2487)itemTag));
        }
        this.progress = compound.method_10550("progress");
        this.streak = compound.method_10550("streak");
        this.lingeringRadiance = compound.method_10550("lingeringRadiance");
        super.method_11014(compound);
    }

    public void tick() {
        class_1937 class_19372;
        super.tick();
        if (this.lingeringRadiance > 0) {
            --this.lingeringRadiance;
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (serverLevel.method_8510() % 100L == 0L) {
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.UNCANNY_VALLEY.get(), class_3419.field_15251, 1.0f, class_3532.method_15344((class_5819)this.field_11863.method_8409(), (float)0.55f, (float)1.75f));
            }
            if (serverLevel.method_8510() % 20L == 0L) {
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.VOID_HEARTBEAT.get(), class_3419.field_15251, 1.5f, class_3532.method_15344((class_5819)this.field_11863.method_8409(), (float)0.95f, (float)1.15f));
            }
            if (serverLevel.method_8510() % 40L == 0L) {
                this.eatItems(serverLevel);
            }
            if (!this.eatenItems.isEmpty()) {
                ++this.progress;
                if (this.progress >= 80) {
                    int resultingProgress = 60;
                    ParticleEffectType particleEffectType = ParticleEffectTypeRegistry.WEEPING_WELL_REACTS;
                    class_1799 stack = this.eatenItems.get(this.eatenItems.size() - 1);
                    if (stack.method_7909().equals(ItemRegistry.BLIGHTED_GUNK.get())) {
                        resultingProgress = (int)((float)resultingProgress + (float)this.streak / 2.0f);
                        ++this.streak;
                        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.VOID_EATS_GUNK.get(), class_3419.field_15248, 0.7f, 0.6f + this.field_11863.field_9229.method_43057() * 0.3f + (float)this.streak * 0.05f);
                        this.field_11863.method_8396(null, this.field_11867, class_3417.field_20614, class_3419.field_15248, 0.7f, 0.6f + this.field_11863.field_9229.method_43057() * 0.2f + (float)this.streak * 0.05f);
                    } else {
                        class_1792 result = this.spitOutItem(stack);
                        if (result.equals(ItemRegistry.FUSED_CONSCIOUSNESS.get())) {
                            this.lingeringRadiance = 400;
                            particleEffectType = ParticleEffectTypeRegistry.WEEPING_WELL_EMITS_RADIANCE;
                        }
                    }
                    this.progress = resultingProgress;
                    this.eatenItems.remove(this.eatenItems.size() - 1);
                    particleEffectType.createPositionedEffect(serverLevel, new PositionEffectData((float)this.field_11867.method_10263() + 0.5f, (float)this.field_11867.method_10264() + 0.6f, (float)this.field_11867.method_10260() + 0.5f));
                    BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
                }
                if (this.eatenItems.isEmpty()) {
                    this.progress = 0;
                }
            } else if (this.streak != 0) {
                this.streak = 0;
            }
        } else if (this.lingeringRadiance <= 100) {
            WeepingWellParticleEffects.passiveWeepingWellParticles(this);
        } else {
            RadiantParticleEffects.radiantWeepingWellParticles(this);
        }
    }

    public void eatItems(class_3218 serverLevel) {
        List<class_1542> items = serverLevel.method_18467(class_1542.class, new class_238(this.field_11867.method_10069(1, -3, 1), this.field_11867.method_10069(-1, -1, -1)).method_1014(1.0)).stream().sorted(Comparator.comparingInt(itemEntity -> itemEntity.field_7204)).toList();
        for (class_1542 entity : items) {
            class_1799 item = entity.method_6983();
            if (item.method_7909().equals(ItemRegistry.BLIGHTED_GUNK.get())) {
                this.progress += 20;
            }
            this.eatenItems.add(item);
            entity.method_31472();
        }
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public class_1792 spitOutItem(class_1799 stack) {
        FavorOfTheVoidRecipe recipe = FavorOfTheVoidRecipe.getRecipe(this.field_11863, stack);
        float pitch = class_3532.method_15344((class_5819)this.field_11863.method_8409(), (float)0.85f, (float)1.35f) + (float)this.streak * 0.1f;
        if (recipe != null) {
            int count;
            ++this.streak;
            for (int amount = recipe.output.method_7947() * stack.method_7947(); amount > 0; amount -= count) {
                count = Math.min(64, amount);
                class_1799 outputStack = new class_1799((class_1935)recipe.output.method_7909(), count);
                outputStack.method_7980(recipe.output.method_7969());
                class_1542 entity = new class_1542(this.field_11863, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), outputStack);
                entity.method_18800(0.0, (double)0.65f, (double)0.15f);
                this.field_11863.method_8649((class_1297)entity);
            }
            this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.VOID_TRANSMUTATION.get(), class_3419.field_15251, 2.0f, pitch);
            return recipe.output.method_7909();
        }
        class_1542 entity = new class_1542(this.field_11863, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), stack);
        entity.method_18800(0.0, (double)0.65f, (double)0.15f);
        this.field_11863.method_8649((class_1297)entity);
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.VOID_REJECTION.get(), class_3419.field_15251, 2.0f, pitch);
        return stack.method_7909();
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.field_11867;
        return new class_238((double)(pos.method_10263() - 3), (double)(pos.method_10264() - 1), (double)(pos.method_10260() - 3), (double)(pos.method_10263() + 4), (double)(pos.method_10264() + 2), (double)(pos.method_10260() + 4));
    }
}

