/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.void_depot;

import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class VoidDepotBlockEntity
extends LodestoneBlockEntity {
    public final List<VoidDepotGoal> goals = new ArrayList<VoidDepotGoal>();
    public final List<String> textToDisplay = new ArrayList<String>();
    public boolean repeatable = false;
    public boolean oncePerPlayer = true;
    public List<UUID> playersWhoCompleted = new ArrayList<UUID>();
    public int nearTimer;
    public float textVisibility = 0.0f;
    public static final class_3542.class_7292<VoidDepotGoal.VoidDepotGoalType> CODEC = class_3542.method_28140(VoidDepotGoal.VoidDepotGoalType::values);

    public VoidDepotBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntityRegistry.VOID_DEPOT.get(), pos, state);
    }

    protected void method_11007(class_2487 compound) {
        super.method_11007(compound);
        class_2487 textTag = new class_2487();
        if (!this.textToDisplay.isEmpty()) {
            for (int i = 0; i < this.textToDisplay.size(); ++i) {
                String text = this.textToDisplay.get(i);
                textTag.method_10582("line_" + i, text);
            }
        }
        compound.method_10566("textDisplay", (class_2520)textTag);
        class_2487 goalsTag = new class_2487();
        if (!this.goals.isEmpty()) {
            int goalsSize = this.goals.size();
            for (int i = 0; i < goalsSize; ++i) {
                VoidDepotGoal goal = this.goals.get(i);
                class_2487 goalTag = goal.serialize();
                goalTag.method_10582("goalName", goal.index);
                goalTag.method_10582("type", goal.type.name);
                goalTag.method_10556("completed", goal.completed);
                goalsTag.method_10566("goal_" + i, (class_2520)goalTag);
            }
            goalsTag.method_10556("repeatable", this.repeatable);
            goalsTag.method_10556("oncePerPlayer", this.oncePerPlayer);
            if (!this.playersWhoCompleted.isEmpty()) {
                class_2487 playerList = new class_2487();
                for (int i = 0; i < this.playersWhoCompleted.size(); ++i) {
                    playerList.method_25927("player_" + i, this.playersWhoCompleted.get(i));
                }
                goalsTag.method_10566("playersWhoCompleted", (class_2520)playerList);
            }
            compound.method_10566("goals", (class_2520)goalsTag);
        }
    }

    public void method_11014(class_2487 compound) {
        int i;
        super.method_11014(compound);
        if (compound.method_10545("textDisplay")) {
            this.textToDisplay.clear();
            class_2487 textTag = compound.method_10562("textDisplay");
            int lineCount = textTag.method_10546();
            for (i = 0; i < lineCount; ++i) {
                if (!textTag.method_10545("line_" + i)) continue;
                this.textToDisplay.add(textTag.method_10558("line_" + i));
            }
        }
        if (compound.method_10545("goals")) {
            this.goals.clear();
            class_2487 goalsTag = compound.method_10562("goals");
            int goalCount = goalsTag.method_10546();
            for (i = 0; i < goalCount; ++i) {
                class_2487 goalTag;
                VoidDepotGoal.VoidDepotGoalType type;
                if (!goalsTag.method_10545("goal_" + i) || (type = (VoidDepotGoal.VoidDepotGoalType)CODEC.method_42633((goalTag = goalsTag.method_10562("goal_" + i)).method_10558("type"))) == null) continue;
                VoidDepotGoal goal = type.deserializer.apply(goalTag);
                goal.setCompleted(goalTag.method_10577("completed"));
                this.goals.add(goal);
            }
            this.playersWhoCompleted.clear();
            class_2487 playerList = goalsTag.method_10562("playersWhoCompleted");
            if (!playerList.method_33133()) {
                int playerCount = playerList.method_10546();
                for (int i2 = 0; i2 < playerCount; ++i2) {
                    if (!playerList.method_10545("player_" + i2)) continue;
                    this.playersWhoCompleted.add(playerList.method_25926("player_" + i2));
                }
            }
            this.repeatable = goalsTag.method_10577("repeatable");
            this.oncePerPlayer = goalsTag.method_10577("oncePerPlayer");
        }
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (!this.goals.isEmpty()) {
            if (player.method_5998(hand).method_7909().equals(ItemRegistry.CREATIVE_SCYTHE.get())) {
                ArrayList<VoidDepotGoal> newGoals = new ArrayList<VoidDepotGoal>();
                for (VoidDepotGoal goal : this.goals) {
                    int amount;
                    if (goal instanceof ItemGoal) {
                        ItemGoal itemGoal = (ItemGoal)goal;
                        amount = Math.max(itemGoal.amount / 2, 1);
                        newGoals.add(new ItemGoal(itemGoal.index, itemGoal.item, amount, Math.min(itemGoal.deliveredAmount, amount)));
                    }
                    if (!(goal instanceof ExperienceGoal)) continue;
                    ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                    amount = Math.max(experienceGoal.amount / 2, 1);
                    newGoals.add(new ExperienceGoal(experienceGoal.index, amount, Math.min(experienceGoal.deliveredAmount, amount)));
                }
                this.goals.clear();
                this.goals.addAll(newGoals);
                BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.method_11016());
                return class_1269.field_5812;
            }
            if (player.method_5998(hand).method_7909().equals(ItemRegistry.VOID_CONDUIT.get())) {
                ArrayList<VoidDepotGoal> newGoals = new ArrayList<VoidDepotGoal>();
                for (VoidDepotGoal goal : this.goals) {
                    if (goal instanceof ItemGoal) {
                        ItemGoal itemGoal = (ItemGoal)goal;
                        newGoals.add(new ItemGoal(itemGoal.index, itemGoal.item, itemGoal.amount * 2, itemGoal.deliveredAmount));
                    }
                    if (!(goal instanceof ExperienceGoal)) continue;
                    ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                    newGoals.add(new ExperienceGoal(experienceGoal.index, experienceGoal.amount * 2, experienceGoal.deliveredAmount));
                }
                this.goals.clear();
                this.goals.addAll(newGoals);
                BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.method_11016());
                return class_1269.field_5812;
            }
            if (this.oncePerPlayer && this.playersWhoCompleted.contains(player.method_5667())) {
                return class_1269.field_5811;
            }
            boolean isSuccessful = false;
            for (VoidDepotGoal goal : this.goals) {
                int givenQuantity;
                if (goal.isCompleted()) continue;
                if (goal instanceof ItemGoal) {
                    int givenQuantity2;
                    ItemGoal itemGoal = (ItemGoal)goal;
                    class_1799 stack = player.method_5998(hand);
                    if (stack.method_7909().equals(itemGoal.item) && (givenQuantity2 = Math.min(stack.method_7947(), itemGoal.amount - itemGoal.deliveredAmount)) > 0) {
                        if (!this.field_11863.field_9236) {
                            itemGoal.deliveredAmount += givenQuantity2;
                            stack.method_7934(givenQuantity2);
                            if (itemGoal.deliveredAmount >= itemGoal.amount) {
                                itemGoal.setCompleted(true);
                            }
                        }
                        isSuccessful = true;
                    }
                }
                if (!(goal instanceof ExperienceGoal)) continue;
                ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                if (!hand.equals((Object)class_1268.field_5808) || !player.method_5998(hand).method_7960() || (givenQuantity = Math.min(player.field_7495, experienceGoal.amount - experienceGoal.deliveredAmount)) <= 0) continue;
                if (!this.field_11863.field_9236) {
                    experienceGoal.deliveredAmount += givenQuantity;
                    player.method_7255(-givenQuantity);
                    if (experienceGoal.deliveredAmount >= experienceGoal.amount) {
                        experienceGoal.setCompleted(true);
                    }
                }
                isSuccessful = true;
            }
            if (isSuccessful) {
                boolean isCompleted = this.goals.stream().allMatch(VoidDepotGoal::isCompleted);
                if (isCompleted) {
                    this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 40);
                    if (this.oncePerPlayer) {
                        this.playersWhoCompleted.add(player.method_5667());
                    }
                }
                class_5819 random = this.field_11863.field_9229;
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.VOID_EATS_GUNK.get(), class_3419.field_15248, 0.7f, 0.6f + random.method_43057() * 0.3f);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_20614, class_3419.field_15248, 0.7f, 0.6f + random.method_43057() * 0.2f);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14627, class_3419.field_15248, 0.1f, (random.method_43057() - random.method_43057()) * 0.35f + 0.9f);
                BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.method_11016());
                return class_1269.field_5812;
            }
        }
        return super.onUse(player, hand);
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            class_2338 blockPos;
            class_1657 nearestPlayer;
            WeepingWellParticleEffects.passiveVoidDepotParticles(this);
            if ((float)this.field_11863.method_8510() % 5.0f == 0.0f && (nearestPlayer = this.field_11863.method_18459((double)(blockPos = this.method_11016()).method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 6.0, false)) != null) {
                this.nearTimer = 10;
            }
            --this.nearTimer;
            if (this.nearTimer > 0 && this.textVisibility < 40.0f) {
                this.textVisibility += 1.0f;
            } else if (this.textVisibility > 0.0f) {
                this.textVisibility -= 1.0f;
            }
        }
    }

    public void onCompletion() {
        float pitch = class_3532.method_15344((class_5819)this.field_11863.method_8409(), (float)1.5f, (float)1.75f);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.WEEPING_WELL_REACTS.createPositionedEffect(serverLevel, new PositionEffectData((float)this.field_11867.method_10263() + 0.5f, (float)this.field_11867.method_10264() + 0.9f, (float)this.field_11867.method_10260() + 0.5f));
        }
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.FLESH_RING_ABSORBS.get(), class_3419.field_15251, 0.7f, pitch);
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.VOID_TRANSMUTATION.get(), class_3419.field_15251, 2.0f, pitch);
        if (this.repeatable) {
            for (VoidDepotGoal goal : this.goals) {
                goal.reset();
            }
        }
        BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.method_11016());
    }

    public static abstract class VoidDepotGoal {
        public final VoidDepotGoalType type;
        public final String index;
        public final int amount;
        public int deliveredAmount;
        public boolean completed;

        public VoidDepotGoal(VoidDepotGoalType type, String index, int amount, int deliveredAmount) {
            this.type = type;
            this.index = index;
            this.amount = amount;
            this.deliveredAmount = deliveredAmount;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void reset() {
            this.deliveredAmount = 0;
            this.completed = false;
        }

        public class_2487 serialize() {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10569("amount", this.amount);
            compoundTag.method_10569("deliveredAmount", this.deliveredAmount);
            return compoundTag;
        }

        public static enum VoidDepotGoalType implements class_3542
        {
            ITEM("item", ItemGoal::deserialize),
            EXPERIENCE("experience", ExperienceGoal::deserialize);

            public final String name;
            public final Function<class_2487, VoidDepotGoal> deserializer;

            private VoidDepotGoalType(String name, Function<class_2487, VoidDepotGoal> deserializer) {
                this.name = name;
                this.deserializer = deserializer;
            }

            public String method_15434() {
                return this.name;
            }
        }
    }

    public static class ItemGoal
    extends VoidDepotGoal {
        public final class_1792 item;

        public ItemGoal(String index, class_1792 item, int amount, int deliveredAmount) {
            super(VoidDepotGoal.VoidDepotGoalType.ITEM, index, amount, deliveredAmount);
            this.item = item;
        }

        @Override
        public class_2487 serialize() {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582("itemType", class_7923.field_41178.method_10221((Object)this.item).toString());
            compoundTag.method_10569("amount", this.amount);
            compoundTag.method_10569("deliveredAmount", this.deliveredAmount);
            return compoundTag;
        }

        public static ItemGoal deserialize(class_2487 compoundTag) {
            return new ItemGoal(compoundTag.method_10558("goalName"), (class_1792)class_7923.field_41178.method_10223(new class_2960(compoundTag.method_10558("itemType"))), compoundTag.method_10550("amount"), compoundTag.method_10550("deliveredAmount"));
        }
    }

    public static class ExperienceGoal
    extends VoidDepotGoal {
        public ExperienceGoal(String index, int amount, int deliveredAmount) {
            super(VoidDepotGoal.VoidDepotGoalType.EXPERIENCE, index, amount, deliveredAmount);
        }

        public static ExperienceGoal deserialize(class_2487 compoundTag) {
            return new ExperienceGoal(compoundTag.method_10558("goalName"), compoundTag.method_10550("amount"), compoundTag.method_10550("deliveredAmount"));
        }
    }
}

