/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.item.curiosities.tools.TotemicStaffItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.TotemParticleEffects;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemPoleBlockEntity
extends LodestoneBlockEntity {
    public MalumSpiritType type;
    public TotemPoleState totemPoleState = TotemPoleState.INACTIVE;
    public TotemBaseBlockEntity totemBase;
    public int totemBaseYLevel;
    public int chargeProgress;
    public final boolean isSoulwood;
    public final class_2248 logBlock;
    public final class_2350 direction;

    public TotemPoleBlockEntity(class_2591<? extends TotemPoleBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.isSoulwood = ((TotemPoleBlock)state.method_26204()).isSoulwood;
        this.logBlock = ((TotemPoleBlock)state.method_26204()).logBlock.get();
        this.direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
    }

    public TotemPoleBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends TotemPoleBlockEntity>)((class_2591)BlockEntityRegistry.TOTEM_POLE.get()), pos, state);
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        boolean success = false;
        if (held.method_7909() instanceof TotemicStaffItem && !this.totemPoleState.equals((Object)TotemPoleState.ACTIVE) && !this.totemPoleState.equals((Object)TotemPoleState.CHARGING)) {
            if (this.field_11863.field_9236) {
                return class_1269.field_5812;
            }
            this.totemPoleState = this.totemPoleState.equals((Object)TotemPoleState.INACTIVE) ? TotemPoleState.VISUAL_ONLY : TotemPoleState.INACTIVE;
            success = true;
        } else if (held.canPerformAction(ToolActions.AXE_STRIP)) {
            if (this.field_11863.field_9236) {
                return class_1269.field_5812;
            }
            if (this.type != null) {
                this.field_11863.method_8501(this.field_11867, this.logBlock.method_9564());
                success = true;
                this.onBreak(player);
            }
        }
        if (success) {
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                ParticleEffectTypeRegistry.TOTEM_POLE_ACTIVATED.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867));
            }
            this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.TOTEM_ENGRAVE.get(), class_3419.field_15245, 1.0f, class_3532.method_15344((class_5819)this.field_11863.field_9229, (float)0.9f, (float)1.1f));
            if (this.isSoulwood) {
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.MAJOR_BLIGHT_MOTIF.get(), class_3419.field_15245, 1.0f, 1.0f);
            }
            BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
            return class_1269.field_5812;
        }
        return super.onUse(player, hand);
    }

    protected void method_11007(class_2487 compound) {
        if (this.type != null) {
            compound.method_10582("type", this.type.identifier);
        }
        if (!this.totemPoleState.equals((Object)TotemPoleState.INACTIVE)) {
            compound.method_10569("totemPoleState", this.totemPoleState.ordinal());
        }
        if (this.chargeProgress != 0) {
            compound.method_10569("chargeProgress", this.chargeProgress);
        }
        if (this.totemBaseYLevel != 0) {
            compound.method_10569("totemBaseYLevel", this.totemBaseYLevel);
        }
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10545("type")) {
            this.type = SpiritHarvestHandler.getSpiritType(compound.method_10558("type"));
        }
        this.totemPoleState = compound.method_10545("totemPoleState") ? TotemPoleState.values()[compound.method_10550("totemPoleState")] : TotemPoleState.INACTIVE;
        this.chargeProgress = compound.method_10550("chargeProgress");
        this.totemBaseYLevel = compound.method_10550("totemBaseYLevel");
        super.method_11014(compound);
    }

    public void init() {
        super.init();
        class_2586 class_25862 = this.field_11863.method_8321(new class_2338(this.method_11016().method_10263(), this.totemBaseYLevel, this.method_11016().method_10260()));
        if (class_25862 instanceof TotemBaseBlockEntity) {
            TotemBaseBlockEntity totemBaseBlockEntity;
            this.totemBase = totemBaseBlockEntity = (TotemBaseBlockEntity)class_25862;
        }
    }

    public void tick() {
        super.tick();
        if (this.totemPoleState.equals((Object)TotemPoleState.INACTIVE)) {
            this.chargeProgress = this.chargeProgress > 0 ? this.chargeProgress - 1 : 0;
        } else {
            int cap = this.totemPoleState.equals((Object)TotemPoleState.CHARGING) ? 10 : 20;
            int n = this.chargeProgress = this.chargeProgress < cap ? this.chargeProgress + 1 : cap;
        }
        if (this.field_11863.field_9236 && this.type != null && this.totemPoleState.equals((Object)TotemPoleState.ACTIVE)) {
            TotemParticleEffects.activeTotemPoleParticles(this);
        }
    }

    public void setSpirit(MalumSpiritType type) {
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.TOTEM_ENGRAVE.get(), class_3419.field_15245, 1.0f, class_3532.method_15344((class_5819)this.field_11863.field_9229, (float)0.9f, (float)1.1f));
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14675, class_3419.field_15245, 1.0f, class_3532.method_15344((class_5819)this.field_11863.field_9229, (float)0.9f, (float)1.1f));
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.TOTEM_POLE_ACTIVATED.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867));
        }
        this.type = type;
        this.chargeProgress = 10;
        BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void riteStarting(TotemBaseBlockEntity totemBase, int height) {
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.TOTEM_CHARGE.get(), class_3419.field_15245, 1.0f, 0.9f + 0.2f * (float)height);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.TOTEM_POLE_ACTIVATED.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867));
        }
        this.totemBaseYLevel = this.field_11867.method_10264() - height;
        this.totemBase = totemBase;
        this.totemPoleState = TotemPoleState.CHARGING;
        BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void setState(TotemPoleState state) {
        this.totemPoleState = state;
        BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void onBreak(@Nullable class_1657 player) {
        TotemBaseBlockEntity base;
        if (this.field_11863.field_9236) {
            return;
        }
        class_2338 basePos = new class_2338(this.field_11867.method_10263(), this.totemBaseYLevel, this.field_11867.method_10260());
        class_2586 class_25862 = this.field_11863.method_8321(basePos);
        if (class_25862 instanceof TotemBaseBlockEntity && (base = (TotemBaseBlockEntity)class_25862).isActiveOrAssembling()) {
            base.onBreak(player);
        }
    }

    public static enum TotemPoleState {
        INACTIVE,
        VISUAL_ONLY,
        CHARGING,
        ACTIVE;

    }
}

