/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritRiteRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemBaseBlockEntity
extends LodestoneBlockEntity {
    public static final class_3542.class_7292<TotemRiteState> CODEC = class_3542.method_28140(TotemRiteState::values);
    public final boolean isSoulwood;
    public TotemRiteState state = TotemRiteState.IDLE;
    public TotemicRiteType activeRite;
    public List<class_2338> totemPolePositions = new ArrayList<class_2338>();
    private class_2350 direction;
    public int timer;
    public TotemicRiteType cachedRadiusRite;
    public int radiusVisibility;

    public TotemBaseBlockEntity(class_2591<? extends TotemBaseBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.isSoulwood = ((TotemBaseBlock)state.method_26204()).corrupted;
    }

    public TotemBaseBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends TotemBaseBlockEntity>)((class_2591)BlockEntityRegistry.TOTEM_BASE.get()), pos, state);
    }

    protected void method_11007(class_2487 compound) {
        compound.method_10582("state", this.state.name);
        if (this.activeRite != null) {
            compound.method_10582("rite", this.activeRite.identifier);
        }
        if (this.direction != null) {
            compound.method_10582("direction", this.direction.method_10151());
        }
        compound.method_10569("height", this.totemPolePositions.size());
        compound.method_10569("timer", this.timer);
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        this.state = compound.method_10545("state") ? (TotemRiteState)CODEC.method_42633(compound.method_10558("state")) : TotemRiteState.IDLE;
        this.activeRite = SpiritRiteRegistry.getRite(compound.method_10558("rite"));
        this.direction = class_2350.method_10168((String)compound.method_10558("direction"));
        this.totemPolePositions.clear();
        for (int i = 1; i <= compound.method_10550("height"); ++i) {
            this.totemPolePositions.add(this.field_11867.method_10086(i));
        }
        this.timer = compound.method_10550("timer");
        super.method_11014(compound);
    }

    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            switch (this.state) {
                case ACTIVE: {
                    ++this.timer;
                    if (this.timer < this.activeRite.getRiteEffect(this.isSoulwood).getRiteEffectTickRate()) break;
                    this.activeRite.executeRite(this);
                    this.timer = 0;
                    BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
                    break;
                }
                case ASSEMBLING: {
                    --this.timer;
                    if (this.timer > 0) break;
                    class_2338 polePos = this.field_11867.method_10086(this.totemPolePositions.size() + 1);
                    class_2586 class_25862 = this.field_11863.method_8321(polePos);
                    if (class_25862 instanceof TotemPoleBlockEntity) {
                        TotemPoleBlockEntity pole = (TotemPoleBlockEntity)class_25862;
                        this.timer = 20;
                        this.addTotemPole(pole);
                        break;
                    }
                    TotemicRiteType rite = SpiritRiteRegistry.getRite(this.getSpirits());
                    if (rite == null) {
                        this.setState(TotemRiteState.IDLE);
                        break;
                    }
                    this.activeRite = rite;
                    this.modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState.ACTIVE);
                    rite.executeRite(this);
                    if (rite.getRiteEffect((boolean)this.isSoulwood).category.equals((Object)TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT)) {
                        this.setState(TotemRiteState.IDLE);
                        break;
                    }
                    this.setState(TotemRiteState.ACTIVE);
                    this.deactivateOtherRites();
                }
            }
        } else if (this.state.equals((Object)TotemRiteState.IDLE) && this.radiusVisibility > 0) {
            --this.radiusVisibility;
            if (this.radiusVisibility == 0) {
                this.cachedRadiusRite = null;
            }
        } else if (this.state.equals((Object)TotemRiteState.ACTIVE) && this.radiusVisibility < 40) {
            if (this.activeRite != null && this.cachedRadiusRite == null) {
                this.cachedRadiusRite = this.activeRite;
            }
            ++this.radiusVisibility;
        }
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (this.state.equals((Object)TotemRiteState.ASSEMBLING)) {
            return class_1269.field_5814;
        }
        if (this.field_11863.method_8321(this.field_11867.method_10084()) instanceof TotemPoleBlockEntity) {
            if (!this.field_11863.field_9236) {
                if (this.state.equals((Object)TotemRiteState.ACTIVE)) {
                    this.setState(TotemRiteState.IDLE);
                } else {
                    this.setState(TotemRiteState.ASSEMBLING);
                }
                BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
            }
            player.method_23667(class_1268.field_5808, true);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void onBreak(@Nullable class_1657 player) {
        if (!this.field_11863.field_9236) {
            this.setState(TotemRiteState.IDLE);
        }
    }

    public void addTotemPole(TotemPoleBlockEntity pole) {
        class_2350 direction = (class_2350)pole.method_11010().method_11654((class_2769)class_2741.field_12481);
        if (this.totemPolePositions.isEmpty()) {
            this.direction = direction;
        }
        if (pole.isSoulwood == this.isSoulwood && direction.equals((Object)this.direction) && pole.type != null) {
            this.totemPolePositions.add(pole.method_11016());
            pole.riteStarting(this, this.totemPolePositions.size());
        }
        BlockHelper.updateState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void deactivateOtherRites() {
        TotemicRiteEffect riteEffect = this.activeRite.getRiteEffect(this.isSoulwood);
        int horizontalRadius = riteEffect.getRiteEffectHorizontalRadius();
        int verticalRadius = riteEffect.getRiteEffectVerticalRadius();
        Collection deactivatedTotems = BlockHelper.getBlockEntities(TotemBaseBlockEntity.class, (class_1937)this.field_11863, (class_2338)riteEffect.getRiteEffectCenter(this), (int)horizontalRadius, (int)verticalRadius, (int)horizontalRadius);
        for (TotemBaseBlockEntity deactivatedTotem : deactivatedTotems) {
            if (((Object)((Object)deactivatedTotem)).equals((Object)this) || !deactivatedTotem.isActiveOrAssembling() || deactivatedTotem.activeRite == null || !deactivatedTotem.activeRite.equals(this.activeRite)) continue;
            deactivatedTotem.setState(TotemRiteState.IDLE);
        }
        Collection otherTotems = BlockHelper.getBlockEntities(TotemBaseBlockEntity.class, (class_1937)this.field_11863, (class_2338)this.field_11867, (int)24);
        for (TotemBaseBlockEntity otherTotem : otherTotems) {
            if (((Object)((Object)otherTotem)).equals((Object)this) || otherTotem.activeRite == null || !otherTotem.activeRite.equals(this.activeRite)) continue;
            riteEffect = this.activeRite.getRiteEffect(this.isSoulwood);
            horizontalRadius = riteEffect.getRiteEffectHorizontalRadius();
            verticalRadius = riteEffect.getRiteEffectVerticalRadius();
            if (!BlockHelper.getBlockEntities(TotemBaseBlockEntity.class, (class_1937)this.field_11863, (class_2338)riteEffect.getRiteEffectCenter(otherTotem), (int)horizontalRadius, (int)verticalRadius, (int)horizontalRadius).contains((Object)this)) continue;
            otherTotem.setState(TotemRiteState.IDLE);
        }
    }

    public void setState(TotemRiteState state) {
        if (state.equals((Object)TotemRiteState.ACTIVE)) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.TOTEM_ACTIVATED.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
        if (state.equals((Object)TotemRiteState.IDLE)) {
            if (this.isActiveOrAssembling()) {
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.TOTEM_CANCELLED.get(), class_3419.field_15245, 1.0f, 1.0f);
            }
            this.modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState.INACTIVE);
            this.totemPolePositions.clear();
            this.activeRite = null;
            this.direction = null;
        }
        this.state = state;
        this.timer = 0;
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState state) {
        for (TotemPoleBlockEntity totemPole : this.getTotemPoles()) {
            totemPole.setState(state);
        }
    }

    public List<TotemPoleBlockEntity> getTotemPoles() {
        ArrayList<TotemPoleBlockEntity> totemPoles = new ArrayList<TotemPoleBlockEntity>();
        for (class_2338 totemPolePosition : this.totemPolePositions) {
            class_2586 class_25862 = this.field_11863.method_8321(totemPolePosition);
            if (!(class_25862 instanceof TotemPoleBlockEntity)) continue;
            TotemPoleBlockEntity totemPole = (TotemPoleBlockEntity)class_25862;
            totemPoles.add(totemPole);
        }
        return totemPoles;
    }

    public List<MalumSpiritType> getSpirits() {
        return this.getTotemPoles().stream().map(t -> t.type).toList();
    }

    public class_2350 getDirection() {
        class_2680 state;
        if (this.direction == null && (state = this.field_11863.method_8320(this.field_11867.method_10084())).method_26204() instanceof TotemPoleBlock) {
            this.direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        }
        return this.direction;
    }

    public boolean isActiveOrAssembling() {
        return !this.state.equals((Object)TotemRiteState.IDLE);
    }

    public static enum TotemRiteState implements class_3542
    {
        IDLE("idle"),
        ASSEMBLING("assembling"),
        ACTIVE("active");

        final String name;

        private TotemRiteState(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

