/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.AugmentBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleAccelerationData;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer.CatalyzerAcceleratorType;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import java.util.HashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.HorizontalDirectionStructure;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class SpiritCatalyzerCoreBlockEntity
extends MultiBlockCoreEntity
implements ICrucibleAccelerator,
CustomRenderBoundingBoxBlockEntity {
    private static final class_243 CATALYZER_ITEM_OFFSET = new class_243(0.5, 2.0, 0.5);
    private static final class_243 CATALYZER_AUGMENT_OFFSET = new class_243(0.5, 2.75, 0.5);
    public static final Supplier<HorizontalDirectionStructure> STRUCTURE = () -> HorizontalDirectionStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((class_2248)BlockRegistry.SPIRIT_CATALYZER_COMPONENT.get()).method_9564())});
    public LodestoneBlockEntityInventory inventory = new MalumBlockEntityInventory(1, 64, t -> !(t.method_7909() instanceof SpiritShardItem)){

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockHelper.updateAndNotifyState((class_1937)SpiritCatalyzerCoreBlockEntity.this.field_11863, (class_2338)SpiritCatalyzerCoreBlockEntity.this.field_11867);
        }
    };
    public LodestoneBlockEntityInventory augmentInventory = new AugmentBlockEntityInventory(1, 1){

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SpiritCatalyzerCoreBlockEntity.this.needsSync = true;
            BlockHelper.updateAndNotifyState((class_1937)SpiritCatalyzerCoreBlockEntity.this.field_11863, (class_2338)SpiritCatalyzerCoreBlockEntity.this.field_11867);
        }
    };
    public float burnTicks;
    public HashMap<MalumSpiritType, Integer> intensity;
    protected ICatalyzerAccelerationTarget target;

    public SpiritCatalyzerCoreBlockEntity(class_2591<? extends SpiritCatalyzerCoreBlockEntity> type, MultiBlockStructure structure, class_2338 pos, class_2680 state) {
        super(type, structure, pos, state);
    }

    public SpiritCatalyzerCoreBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends SpiritCatalyzerCoreBlockEntity>)((class_2591)BlockEntityRegistry.SPIRIT_CATALYZER.get()), (MultiBlockStructure)STRUCTURE.get(), pos, state);
    }

    protected void method_11007(class_2487 compound) {
        if (this.burnTicks != 0.0f) {
            compound.method_10548("burnTicks", this.burnTicks);
        }
        this.inventory.save(compound);
        this.augmentInventory.save(compound, "augmentInventory");
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        this.burnTicks = compound.method_10583("burnTicks");
        this.inventory.load(compound);
        this.augmentInventory.load(compound, "augmentInventory");
        super.method_11014(compound);
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (this.field_11863.field_9236) {
            return class_1269.field_21466;
        }
        if (hand.equals((Object)class_1268.field_5808)) {
            class_1799 stack;
            class_1799 heldStack = player.method_5998(hand);
            boolean augmentOnly = heldStack.method_7909() instanceof AbstractAugmentItem;
            if ((augmentOnly || heldStack.method_7960() && this.inventory.isEmpty()) && !(stack = this.augmentInventory.interact(player.method_37908(), player, hand)).method_7960()) {
                return class_1269.field_5812;
            }
            if (!augmentOnly) {
                this.inventory.interact(player.method_37908(), player, hand);
            }
            if (heldStack.method_7960()) {
                return class_1269.field_5812;
            }
        }
        return super.onUse(player, hand);
    }

    public void onBreak(@Nullable class_1657 player) {
        if (!this.field_11863.field_9236) {
            this.inventory.dumpItems(this.field_11863, this.field_11867);
            this.augmentInventory.dumpItems(this.field_11863, this.field_11867);
        }
        super.onBreak(player);
    }

    public void tick() {
        CrucibleAccelerationData data;
        float ratio;
        if (this.target != null && this.target.canBeAccelerated() && this.burnTicks > 0.0f && (ratio = data.fuelUsageRate.getValue(data = this.target.getAccelerationData())) > 0.0f) {
            this.burnTicks -= ratio;
        }
        if (this.field_11863.field_9236) {
            if (this.intensity == null) {
                this.intensity = new HashMap();
            }
            if (this.target != null) {
                boolean canBeAccelerated = this.target.canBeAccelerated();
                MalumSpiritType activeSpiritType = this.target.getActiveSpiritType();
                if (activeSpiritType != null) {
                    this.intensity.putIfAbsent(activeSpiritType, 0);
                    if (canBeAccelerated) {
                        this.intensity.put(activeSpiritType, Math.min(60, this.intensity.get(activeSpiritType) + 1));
                    }
                }
                for (MalumSpiritType spiritType : this.intensity.keySet()) {
                    if (canBeAccelerated && spiritType.equals(activeSpiritType)) continue;
                    this.intensity.put(spiritType, Math.max(0, this.intensity.get(spiritType) - 1));
                }
            }
            SpiritCrucibleParticleEffects.passiveSpiritCatalyzerParticles(this);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addParticles(ICatalyzerAccelerationTarget target, MalumSpiritType spiritType) {
        if (this.burnTicks > 0.0f && this.field_11863 != null && this.field_11863.field_9236) {
            SpiritCrucibleParticleEffects.activeSpiritCatalyzerParticles(this, target, spiritType);
        }
    }

    @Override
    public boolean canStartAccelerating() {
        if (this.burnTicks > 0.0f) {
            return true;
        }
        return (Integer)FuelRegistry.INSTANCE.get((class_1935)this.inventory.getStackInSlot(0).method_7909()) > 0;
    }

    @Override
    public boolean canContinueAccelerating() {
        class_1799 stack;
        if (this.method_11015()) {
            return false;
        }
        if (this.burnTicks <= 0.0f && !(stack = this.inventory.getStackInSlot(0)).method_7960()) {
            this.burnTicks = (float)((Integer)FuelRegistry.INSTANCE.get((class_1935)this.inventory.getStackInSlot(0).method_7909())).intValue() / 2.0f;
            stack.method_7934(1);
            this.inventory.updateData();
            BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
        }
        return this.burnTicks != 0.0f;
    }

    @Override
    public ICrucibleAccelerator.CrucibleAcceleratorType getAcceleratorType() {
        return CatalyzerAcceleratorType.CATALYZER;
    }

    @Override
    public class_1799 getAugment() {
        return this.augmentInventory.getStackInSlot(0);
    }

    @Override
    public ICatalyzerAccelerationTarget getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(ICatalyzerAccelerationTarget target) {
        this.target = target;
    }

    public class_243 getItemOffset() {
        return CATALYZER_ITEM_OFFSET;
    }

    public class_243 getAugmentOffset() {
        return CATALYZER_AUGMENT_OFFSET;
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.field_11867;
        return new class_238((double)(pos.method_10263() - 1), (double)pos.method_10264(), (double)(pos.method_10260() - 1), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 4), (double)(pos.method_10260() + 1));
    }
}

