/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.AugmentBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleAccelerationData;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleSoundInstance;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.augment.core.AbstractCoreAugmentItem;
import com.sammy.malum.common.item.impetus.ImpetusItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.forge_stuff.CombinedInvWrapper;
import team.lodestar.lodestone.forge_stuff.IItemHandler;
import team.lodestar.lodestone.forge_stuff.IItemHandlerModifiable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class SpiritCrucibleCoreBlockEntity
extends MultiBlockCoreEntity
implements ICatalyzerAccelerationTarget,
IMalumSpecialItemAccessPoint,
CustomRenderBoundingBoxBlockEntity {
    private static final class_243 CRUCIBLE_ITEM_OFFSET = new class_243(0.5, (double)1.6f, 0.5);
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((class_2248)BlockRegistry.SPIRIT_CRUCIBLE_COMPONENT.get()).method_9564())});
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public LodestoneBlockEntityInventory augmentInventory;
    public LodestoneBlockEntityInventory coreAugmentInventory;
    public SpiritFocusingRecipe recipe;
    public float spiritAmount;
    public float spiritSpin;
    public float progress;
    public int queuedCracks;
    public int crackTimer;
    public CrucibleAccelerationData acceleratorData = CrucibleAccelerationData.DEFAULT;
    public CrucibleTuning.CrucibleAttributeType tuningType = CrucibleTuning.CrucibleAttributeType.NONE;
    final LazyOptional<IItemHandler> combinedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory}));

    public SpiritCrucibleCoreBlockEntity(class_2591<? extends SpiritCrucibleCoreBlockEntity> type, MultiBlockStructure structure, class_2338 pos, class_2680 state) {
        super(type, structure, pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 1, t -> !(t.method_7909() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((class_1937)SpiritCrucibleCoreBlockEntity.this.field_11863, (class_2338)SpiritCrucibleCoreBlockEntity.this.field_11867);
            }
        };
        this.spiritInventory = new MalumBlockEntityInventory(4, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                SpiritCrucibleCoreBlockEntity.this.spiritAmount = Math.max(1.0f, class_3532.method_16439((float)0.15f, (float)SpiritCrucibleCoreBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((class_1937)SpiritCrucibleCoreBlockEntity.this.field_11863, (class_2338)SpiritCrucibleCoreBlockEntity.this.field_11867);
            }

            public boolean isItemValid(int slot, @NotNull class_1799 stack) {
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof SpiritShardItem)) {
                    return false;
                }
                SpiritShardItem spiritItem = (SpiritShardItem)class_17922;
                for (int i = 0; i < this.getSlots(); ++i) {
                    class_1799 stackInSlot;
                    if (i == slot || (stackInSlot = this.getStackInSlot(i)).method_7960() || stackInSlot.method_7909() != spiritItem) continue;
                    return false;
                }
                return true;
            }
        };
        this.augmentInventory = new AugmentBlockEntityInventory(4, 1){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((class_1937)SpiritCrucibleCoreBlockEntity.this.field_11863, (class_2338)SpiritCrucibleCoreBlockEntity.this.field_11867);
            }
        };
        this.coreAugmentInventory = new AugmentBlockEntityInventory(1, 1, t -> t.method_7909() instanceof AbstractCoreAugmentItem){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((class_1937)SpiritCrucibleCoreBlockEntity.this.field_11863, (class_2338)SpiritCrucibleCoreBlockEntity.this.field_11867);
            }
        };
    }

    public SpiritCrucibleCoreBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends SpiritCrucibleCoreBlockEntity>)((class_2591)BlockEntityRegistry.SPIRIT_CRUCIBLE.get()), STRUCTURE.get(), pos, state);
    }

    protected void method_11007(class_2487 compound) {
        if (this.spiritAmount != 0.0f) {
            compound.method_10548("spiritAmount", this.spiritAmount);
        }
        if (this.progress != 0.0f) {
            compound.method_10548("progress", this.progress);
        }
        if (this.queuedCracks != 0) {
            compound.method_10569("queuedCracks", this.queuedCracks);
        }
        compound.method_10569("tuningType", this.tuningType.ordinal());
        this.acceleratorData.save(compound);
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
        this.augmentInventory.save(compound, "augmentInventory");
        this.coreAugmentInventory.save(compound, "coreAugmentInventory");
    }

    public void method_11014(class_2487 compound) {
        this.spiritAmount = compound.method_10583("spiritAmount");
        this.progress = compound.method_10583("progress");
        this.queuedCracks = compound.method_10550("queuedCracks");
        this.tuningType = CrucibleTuning.CrucibleAttributeType.values()[class_3532.method_15340((int)compound.method_10550("tuningType"), (int)0, (int)(CrucibleTuning.CrucibleAttributeType.values().length - 1))];
        this.acceleratorData = CrucibleAccelerationData.load(this.field_11863, this, compound);
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        this.augmentInventory.load(compound, "augmentInventory");
        this.coreAugmentInventory.load(compound, "coreAugmentInventory");
        super.method_11014(compound);
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (this.field_11863.field_9236) {
            return class_1269.field_21466;
        }
        if (hand.equals((Object)class_1268.field_5808)) {
            class_1799 stack;
            class_1799 heldStack = player.method_6047();
            if (heldStack.method_7909().equals(ItemRegistry.TUNING_FORK.get())) {
                this.tuningType = this.tuningType.next(this.tuningType, this);
                this.recalibrateAccelerators(this.field_11863, this.field_11867);
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.TUNING_FORK_TINKERS.get(), class_3419.field_15245, 1.25f + this.field_11863.field_9229.method_43057() * 0.5f, 0.75f + this.field_11863.field_9229.method_43057() * 0.5f);
                BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
                return class_1269.field_5812;
            }
            boolean augmentOnly = heldStack.method_7909() instanceof AbstractAugmentItem;
            boolean isEmpty = heldStack.method_7960();
            if (augmentOnly || isEmpty && this.inventory.isEmpty() && this.spiritInventory.isEmpty()) {
                boolean isCoreAugment = heldStack.method_7909() instanceof AbstractCoreAugmentItem;
                if ((augmentOnly && !isCoreAugment || isEmpty) && !(stack = this.augmentInventory.interact(player.method_37908(), player, hand)).method_7960()) {
                    this.recalibrateAccelerators(this.field_11863, this.field_11867);
                    return class_1269.field_5812;
                }
                if ((augmentOnly && isCoreAugment || isEmpty) && !(stack = this.coreAugmentInventory.interact(player.method_37908(), player, hand)).method_7960()) {
                    this.recalibrateAccelerators(this.field_11863, this.field_11867);
                    return class_1269.field_5812;
                }
            }
            this.recalibrateAccelerators(this.field_11863, this.field_11867);
            if (!augmentOnly) {
                class_1799 spiritStack = this.spiritInventory.interact(this.field_11863, player, hand);
                if (!spiritStack.method_7960()) {
                    return class_1269.field_5812;
                }
                if (!(heldStack.method_7909() instanceof SpiritShardItem) && !(stack = this.inventory.interact(this.field_11863, player, hand)).method_7960()) {
                    return class_1269.field_5812;
                }
            }
            if (isEmpty) {
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return super.onUse(player, hand);
    }

    public void onBreak(@Nullable class_1657 player) {
        this.inventory.dumpItems(this.field_11863, this.field_11867);
        this.spiritInventory.dumpItems(this.field_11863, this.field_11867);
        this.augmentInventory.dumpItems(this.field_11863, this.field_11867);
        super.onBreak(player);
    }

    public void init() {
        if (this.field_11863.field_9236 && this.recipe == null) {
            CrucibleSoundInstance.playSound(this);
        }
        this.recipe = SpiritFocusingRecipe.getRecipe(this.field_11863, this.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyItemStacks);
    }

    public void tick() {
        super.tick();
        this.spiritAmount = Math.max(1.0f, class_3532.method_16439((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (this.queuedCracks > 0) {
            ++this.crackTimer;
            if (this.crackTimer % 5 == 0) {
                if (this.crackTimer >= 15) {
                    this.crackTimer = 0;
                }
                float pitch = 0.95f + (float)(this.crackTimer - 8) * 0.015f + this.field_11863.field_9229.method_43057() * 0.05f;
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.IMPETUS_CRACK.get(), class_3419.field_15245, 0.7f, pitch);
                --this.queuedCracks;
                if (this.queuedCracks == 0) {
                    this.crackTimer = 0;
                }
            }
        }
        float speed = this.acceleratorData.focusingSpeed.getValue(this.acceleratorData);
        if (!this.field_11863.field_9236) {
            if (this.recipe != null) {
                boolean needsRecalibration;
                boolean bl = needsRecalibration = !this.acceleratorData.accelerators.stream().allMatch(ICrucibleAccelerator::canContinueAccelerating);
                if (needsRecalibration) {
                    this.recalibrateAccelerators(this.field_11863, this.field_11867);
                    BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
                }
                this.progress += speed;
                if (this.progress >= (float)this.recipe.time) {
                    this.craft();
                }
            } else {
                this.progress = 0.0f;
            }
        } else {
            this.spiritSpin += 1.0f + speed * 0.1f;
            SpiritCrucibleParticleEffects.passiveCrucibleParticles(this);
        }
    }

    public void craft() {
        class_1799 stack = this.inventory.getStackInSlot(0);
        class_1799 outputStack = this.recipe.output.method_7972();
        class_243 itemPos = this.getItemPos();
        class_5819 random = this.field_11863.field_9229;
        float processingSpeed = this.acceleratorData.focusingSpeed.getValue(this.acceleratorData);
        float damageChance = this.acceleratorData.damageChance.getValue(this.acceleratorData);
        float bonusYieldChance = this.acceleratorData.bonusYieldChance.getValue(this.acceleratorData);
        float instantCompletionChance = this.acceleratorData.chainFocusingChance.getValue(this.acceleratorData);
        float completeDamageNegationChance = this.acceleratorData.damageAbsorptionChance.getValue(this.acceleratorData);
        float restorationChance = this.acceleratorData.restorationChance.getValue(this.acceleratorData);
        if (random.method_43057() < restorationChance) {
            stack.method_7974(Math.max(stack.method_7919() - this.recipe.durabilityCost * 4, 0));
        }
        if (completeDamageNegationChance == 0.0f || random.method_43057() < completeDamageNegationChance) {
            if (this.recipe.durabilityCost != 0 && stack.method_7963()) {
                class_1792 class_17922;
                int durabilityCost = this.recipe.durabilityCost;
                if (damageChance > 0.0f && random.method_43057() < damageChance) {
                    durabilityCost *= 2;
                }
                this.queuedCracks += durabilityCost;
                boolean success = stack.method_7970(durabilityCost, random, null);
                if (success && (class_17922 = stack.method_7909()) instanceof ImpetusItem) {
                    ImpetusItem impetusItem = (ImpetusItem)class_17922;
                    this.inventory.setStackInSlot(0, impetusItem.getCrackedVariant().method_7854());
                }
            }
        } else {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.SHIELDING_APPARATUS_SHIELDS.get(), class_3419.field_15245, 0.5f, 0.25f + random.method_43057() * 0.25f);
        }
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                class_1799 spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.method_7934(spirit.count);
                continue block0;
            }
        }
        this.spiritInventory.updateData();
        boolean instantCompletion = instantCompletionChance > 0.0f && random.method_43057() < instantCompletionChance;
        float f = this.progress = instantCompletion ? (float)this.recipe.time - 10.0f * processingSpeed : 0.0f;
        if (instantCompletion) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.WARPING_ENGINE_REVERBERATES.get(), class_3419.field_15245, 1.5f, 1.0f + random.method_43057() * 0.25f);
        }
        this.acceleratorData.globalAttributeModifier = instantCompletion ? this.acceleratorData.globalAttributeModifier + 0.2f : 0.0f;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.SPIRIT_CRUCIBLE_CRAFTS.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), ColorEffectData.fromRecipe(this.recipe.spirits));
        }
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.CRUCIBLE_CRAFT.get(), class_3419.field_15245, 1.0f, 0.75f + random.method_43057() * 0.5f);
        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, outputStack));
        while (bonusYieldChance > 0.0f) {
            if (bonusYieldChance >= 1.0f || random.method_43057() < bonusYieldChance) {
                this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, outputStack.method_7972()));
            }
            bonusYieldChance -= 1.0f;
        }
        this.recipe = SpiritFocusingRecipe.getRecipe(this.field_11863, stack, this.spiritInventory.nonEmptyItemStacks);
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    @Override
    public class_243 getAccelerationPoint() {
        return this.getItemPos();
    }

    @Override
    public List<class_1799> getAugments() {
        return this.augmentInventory.nonEmptyItemStacks;
    }

    @Override
    public class_1799 getCoreAugment() {
        return this.coreAugmentInventory.getStackInSlot(0);
    }

    @Override
    public boolean canBeAccelerated() {
        return !this.method_11015() && this.recipe != null;
    }

    @Override
    public CrucibleAccelerationData getAccelerationData() {
        return this.acceleratorData;
    }

    @Override
    public void setAccelerationData(CrucibleAccelerationData data) {
        this.acceleratorData = data;
    }

    @Override
    public CrucibleTuning.CrucibleAttributeType getTuningType() {
        return this.tuningType;
    }

    @Override
    public MalumSpiritType getActiveSpiritType() {
        int spiritCount = this.spiritInventory.nonEmptyItemAmount;
        class_1792 currentItem = this.spiritInventory.getStackInSlot(0).method_7909();
        if (spiritCount > 1) {
            float duration = 60.0f * (float)spiritCount;
            float gameTime = (float)this.method_10997().method_8510() % duration / 60.0f;
            currentItem = this.spiritInventory.getStackInSlot(class_3532.method_15375((float)gameTime)).method_7909();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem.type;
    }

    @Override
    public class_243 getItemPos(float partialTicks) {
        class_2338 blockPos = this.method_11016();
        class_243 offset = this.getCentralItemOffset();
        return new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
    }

    @Override
    public class_2338 getAccessPointBlockPos() {
        return this.method_11016();
    }

    @Override
    public LodestoneBlockEntityInventory getSuppliedInventory() {
        return this.inventory;
    }

    public class_243 getCentralItemOffset() {
        return CRUCIBLE_ITEM_OFFSET;
    }

    public class_243 getSpiritItemOffset(int slot, float partialTicks) {
        float distance = 0.75f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 1.8f;
        return DataHelper.rotatingRadialOffset((class_243)new class_243(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (long)((long)(this.spiritSpin + partialTicks)), (float)360.0f);
    }

    public class_243 getAugmentItemOffset(int slot, float partialTicks) {
        float distance = 0.6f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 1.6f;
        return DataHelper.rotatingRadialOffset((class_243)new class_243(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.augmentInventory.slotCount, (long)((long)(this.spiritSpin + partialTicks)), (float)240.0f);
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.field_11867;
        return new class_238((double)(pos.method_10263() - 1), (double)pos.method_10264(), (double)(pos.method_10260() - 1), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 4), (double)(pos.method_10260() + 1));
    }
}

