/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_altar;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarCraftingHelper;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarSoundInstance;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.SpiritAltarParticleEffects;
import com.sammy.malum.visual_effects.networked.altar.SpiritAltarEatItemParticleEffect;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.forge_stuff.CombinedInvWrapper;
import team.lodestar.lodestone.forge_stuff.IItemHandler;
import team.lodestar.lodestone.forge_stuff.IItemHandlerModifiable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritAltarBlockEntity
extends LodestoneBlockEntity
implements CustomRenderBoundingBoxBlockEntity {
    private static final class_243 ALTAR_ITEM_OFFSET = new class_243(0.5, 1.25, 0.5);
    public static final int HORIZONTAL_RANGE = 4;
    public static final int VERTICAL_RANGE = 3;
    public float speed = 1.0f;
    public int progress;
    public int idleProgress;
    public float spiritYLevel;
    public List<class_2338> acceleratorPositions = new ArrayList<class_2338>();
    public List<IAltarAccelerator> accelerators = new ArrayList<IAltarAccelerator>();
    public float spiritAmount;
    public float spiritSpin;
    public boolean isCrafting;
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory extrasInventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public Map<SpiritInfusionRecipe, AltarCraftingHelper.Ranking> possibleRecipes = new HashMap<SpiritInfusionRecipe, AltarCraftingHelper.Ranking>();
    public SpiritInfusionRecipe recipe;
    public LazyOptional<IItemHandler> internalInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.extrasInventory, this.spiritInventory}));
    public LazyOptional<IItemHandler> exposedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory}));

    public SpiritAltarBlockEntity(class_2591<? extends SpiritAltarBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SpiritAltarBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntityRegistry.SPIRIT_ALTAR.get(), pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64, t -> !(t.method_7909() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritAltarBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((class_1937)SpiritAltarBlockEntity.this.field_11863, (class_2338)SpiritAltarBlockEntity.this.field_11867);
            }
        };
        this.extrasInventory = new MalumBlockEntityInventory(8, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((class_1937)SpiritAltarBlockEntity.this.field_11863, (class_2338)SpiritAltarBlockEntity.this.field_11867);
            }
        };
        this.spiritInventory = new MalumBlockEntityInventory(SpiritTypeRegistry.SPIRITS.size(), 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritAltarBlockEntity.this.needsSync = true;
                SpiritAltarBlockEntity.this.spiritAmount = Math.max(1.0f, class_3532.method_16439((float)0.15f, (float)SpiritAltarBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((class_1937)SpiritAltarBlockEntity.this.field_11863, (class_2338)SpiritAltarBlockEntity.this.field_11867);
            }

            public boolean isItemValid(int slot, @NotNull class_1799 stack) {
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof SpiritShardItem)) {
                    return false;
                }
                SpiritShardItem spiritItem = (SpiritShardItem)class_17922;
                for (int i = 0; i < this.getSlots(); ++i) {
                    class_1799 stackInSlot;
                    if (i == slot || (stackInSlot = this.getStackInSlot(i)).method_7960() || stackInSlot.method_7909() != spiritItem) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected void method_11007(class_2487 compound) {
        compound.method_10569("progress", this.progress);
        compound.method_10569("idleProgress", this.idleProgress);
        compound.method_10548("spiritYLevel", this.spiritYLevel);
        compound.method_10548("speed", this.speed);
        compound.method_10548("spiritAmount", this.spiritAmount);
        compound.method_10569("acceleratorAmount", this.acceleratorPositions.size());
        for (int i = 0; i < this.acceleratorPositions.size(); ++i) {
            BlockHelper.saveBlockPos((class_2487)compound, (class_2338)this.acceleratorPositions.get(i), (String)("" + i));
        }
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
        this.extrasInventory.save(compound, "extrasInventory");
    }

    public void method_11014(class_2487 compound) {
        this.progress = compound.method_10550("progress");
        this.idleProgress = compound.method_10550("idleProgress");
        this.spiritYLevel = compound.method_10583("spiritYLevel");
        this.speed = compound.method_10583("speed");
        this.spiritAmount = compound.method_10583("spiritAmount");
        this.acceleratorPositions.clear();
        this.accelerators.clear();
        int amount = compound.method_10550("acceleratorAmount");
        for (int i = 0; i < amount; ++i) {
            class_2586 class_25862;
            class_2338 pos = BlockHelper.loadBlockPos((class_2487)compound, (String)("" + i));
            if (this.field_11863 == null || !((class_25862 = this.field_11863.method_8321(pos)) instanceof IAltarAccelerator)) continue;
            IAltarAccelerator accelerator = (IAltarAccelerator)class_25862;
            this.acceleratorPositions.add(pos);
            this.accelerators.add(accelerator);
        }
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        this.extrasInventory.load(compound, "extrasInventory");
        super.method_11014(compound);
    }

    public void onBreak(@Nullable class_1657 player) {
        this.inventory.dumpItems(this.field_11863, this.field_11867);
        this.spiritInventory.dumpItems(this.field_11863, this.field_11867);
        this.extrasInventory.dumpItems(this.field_11863, this.field_11867);
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (this.field_11863.field_9236) {
            return class_1269.field_21466;
        }
        if (hand.equals((Object)class_1268.field_5808)) {
            class_1799 stack;
            class_1799 heldStack = player.method_6047();
            this.recalibrateAccelerators();
            if (!(heldStack.method_7909() instanceof SpiritShardItem) && !(stack = this.inventory.interact(this.field_11863, player, hand)).method_7960()) {
                return class_1269.field_5812;
            }
            this.spiritInventory.interact(this.field_11863, player, hand);
            if (heldStack.method_7960()) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return super.onUse(player, hand);
    }

    public void init() {
        this.recalculateRecipes();
        if (this.field_11863.field_9236 && this.isCrafting) {
            AltarSoundInstance.playSound(this);
        }
    }

    public void tick() {
        int progressCap;
        super.tick();
        this.spiritAmount = Math.max(1.0f, class_3532.method_16439((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (!this.inventory.getStackInSlot(0).method_7960()) {
            ++this.idleProgress;
            progressCap = (int)(20.0f / this.speed);
            if (this.idleProgress >= progressCap) {
                this.recalculateRecipes();
                this.idleProgress = 0;
                BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
            }
        }
        if (!this.possibleRecipes.isEmpty()) {
            if (this.spiritYLevel < 30.0f) {
                this.spiritYLevel += 1.0f;
            }
            if (this.recipe != null) {
                if (!this.isCrafting) {
                    BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
                    this.isCrafting = true;
                }
                ++this.progress;
            } else {
                if (this.isCrafting) {
                    BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
                    this.isCrafting = false;
                }
                this.progress = 0;
            }
            if (!this.field_11863.field_9236) {
                boolean success;
                boolean canAccelerate;
                if (this.field_11863.method_8510() % 20L == 0L && !(canAccelerate = this.accelerators.stream().allMatch(IAltarAccelerator::canAccelerate))) {
                    this.recalibrateAccelerators();
                }
                if (this.progress >= (progressCap = (int)(300.0f / this.speed)) && (success = this.consume())) {
                    this.craft();
                }
            }
        } else {
            this.isCrafting = false;
            this.progress = 0;
            if (this.spiritYLevel > 0.0f) {
                this.spiritYLevel = Math.max(this.spiritYLevel - 0.8f, 0.0f);
            }
        }
        if (this.field_11863.field_9236) {
            this.spiritSpin += 1.0f + this.spiritYLevel * 0.05f + this.speed * 0.5f;
            SpiritAltarParticleEffects.passiveSpiritAltarParticles(this);
        }
    }

    private void recalculateRecipes() {
        boolean hadRecipe = this.recipe != null;
        class_1799 stack = this.inventory.getStackInSlot(0);
        if (!stack.method_7960()) {
            Collection recipes = DataHelper.getAll(SpiritInfusionRecipe.getRecipes(this.field_11863), r -> r.doesInputMatch(stack) && r.doSpiritsMatch(this.spiritInventory.nonEmptyItemStacks));
            this.possibleRecipes.clear();
            IItemHandlerModifiable pedestalItems = AltarCraftingHelper.createPedestalInventoryCapture(AltarCraftingHelper.capturePedestals(this.field_11863, this.field_11867));
            for (SpiritInfusionRecipe recipe : recipes) {
                this.possibleRecipes.put(recipe, AltarCraftingHelper.rankRecipe(recipe, stack, (IItemHandlerModifiable)this.spiritInventory, pedestalItems, (IItemHandlerModifiable)this.extrasInventory));
            }
            this.recipe = this.possibleRecipes.entrySet().stream().filter(it -> it.getValue() != null).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        } else {
            this.recipe = null;
            this.possibleRecipes.clear();
        }
        if (hadRecipe && this.recipe == null && this.field_11863 != null) {
            this.extrasInventory.dumpItems(this.field_11863, this.field_11867);
        }
    }

    public boolean consume() {
        if (this.recipe == null) {
            return false;
        }
        if (this.recipe.extraItems.isEmpty()) {
            return true;
        }
        List<IMalumSpecialItemAccessPoint> pedestalItems = AltarCraftingHelper.capturePedestals(this.field_11863, this.field_11867);
        class_1799 stack = this.inventory.getStackInSlot(0);
        AltarCraftingHelper.Ranking reranking = AltarCraftingHelper.rankRecipe(this.recipe, stack, (IItemHandlerModifiable)this.spiritInventory, AltarCraftingHelper.createPedestalInventoryCapture(pedestalItems), (IItemHandlerModifiable)this.extrasInventory);
        if (!Objects.equals(reranking, this.possibleRecipes.get((Object)this.recipe))) {
            this.recalculateRecipes();
            return false;
        }
        IngredientWithCount nextIngredient = AltarCraftingHelper.getNextIngredientToTake(this.recipe, (IItemHandlerModifiable)this.extrasInventory);
        if (nextIngredient != null) {
            for (IMalumSpecialItemAccessPoint provider : pedestalItems) {
                LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
                class_1799 providedStack = inventoryForAltar.extractItem(0, nextIngredient.count, true);
                if (!nextIngredient.ingredient.method_8093(providedStack)) continue;
                this.field_11863.method_8396(null, provider.getAccessPointBlockPos(), (class_3414)SoundRegistry.ALTAR_CONSUME.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    ParticleEffectTypeRegistry.SPIRIT_ALTAR_EATS_ITEM.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), ColorEffectData.fromRecipe(this.recipe.spirits), SpiritAltarEatItemParticleEffect.createData(provider.getAccessPointBlockPos(), providedStack));
                }
                this.extrasInventory.insertItem(inventoryForAltar.extractItem(0, nextIngredient.count, false));
                inventoryForAltar.updateData();
                BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)provider.getAccessPointBlockPos());
                break;
            }
            this.progress = (int)((float)this.progress * 0.8f);
            if (this.extrasInventory.isEmpty()) {
                return false;
            }
            return AltarCraftingHelper.extractIngredient((IItemHandler)this.extrasInventory, (Predicate<class_1799>)nextIngredient.ingredient, nextIngredient.count, true).isEmpty();
        }
        return true;
    }

    public void craft() {
        class_1799 stack = this.inventory.getStackInSlot(0);
        class_1799 outputStack = this.recipe.output.method_7972();
        class_243 itemPos = this.getItemPos();
        if (this.recipe.useNbtFromInput && this.inventory.getStackInSlot(0).method_7985()) {
            class_2487 tag = outputStack.method_7969();
            class_2487 oldTag = stack.method_7969();
            if (tag != null && oldTag != null) {
                class_2487 mergedTag = tag.method_10543(oldTag);
                outputStack.method_7980(mergedTag);
            } else if (tag != null) {
                outputStack.method_7980(tag);
            } else if (oldTag != null) {
                outputStack.method_7980(oldTag);
            }
        }
        stack.method_7934(this.recipe.input.count);
        this.inventory.updateData();
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                class_1799 spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.method_7934(spirit.count);
                continue block0;
            }
        }
        this.spiritInventory.updateData();
        this.progress = (int)((float)this.progress * 0.75f);
        this.extrasInventory.clear();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.SPIRIT_ALTAR_CRAFTS.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), ColorEffectData.fromRecipe(this.recipe.spirits));
        }
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.ALTAR_CRAFT.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, itemPos.field_1352, itemPos.field_1351, itemPos.field_1350, outputStack));
        this.init();
        this.recalibrateAccelerators();
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void recalibrateAccelerators() {
        this.speed = 1.0f;
        this.accelerators.clear();
        this.acceleratorPositions.clear();
        Collection nearbyAccelerators = BlockHelper.getBlockEntities(IAltarAccelerator.class, (class_1937)this.field_11863, (class_2338)this.field_11867, (int)4, (int)3, (int)4);
        HashMap<IAltarAccelerator.AltarAcceleratorType, Integer> entries = new HashMap<IAltarAccelerator.AltarAcceleratorType, Integer>();
        for (IAltarAccelerator accelerator : nearbyAccelerators) {
            if (!accelerator.canAccelerate()) continue;
            int max = accelerator.getAcceleratorType().maximumEntries();
            int amount = entries.computeIfAbsent(accelerator.getAcceleratorType(), a -> 0);
            if (amount >= max) continue;
            this.accelerators.add(accelerator);
            this.acceleratorPositions.add(((class_2586)accelerator).method_11016());
            this.speed += accelerator.getAcceleration();
            entries.replace(accelerator.getAcceleratorType(), amount + 1);
        }
    }

    public class_243 getCentralItemOffset() {
        return ALTAR_ITEM_OFFSET;
    }

    public class_243 getItemPos() {
        class_2338 blockPos = this.method_11016();
        class_243 offset = this.getCentralItemOffset();
        return new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
    }

    public class_243 getSpiritItemOffset(int slot, float partialTicks) {
        float projectedSpiritSpin = this.spiritSpin + this.spiritYLevel * 0.05f + this.speed * 0.5f;
        float lerpSpiritSpin = this.spiritSpin + partialTicks * (projectedSpiritSpin - this.spiritSpin);
        float distance = 1.0f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + (float)Math.sin(lerpSpiritSpin % 6.28f / 20.0f) * 0.025f;
        float height = 0.75f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.5f;
        int period = 360;
        double angle = (double)((float)slot / this.spiritAmount) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle += (double)(lerpSpiritSpin % (float)period / (float)period) * (Math.PI * 2));
        double dz2 = (double)distance * Math.sin(angle);
        class_243 vector2f = new class_243(dx2, 0.0, dz2);
        double x = vector2f.field_1352 * (double)distance;
        double z = vector2f.field_1350 * (double)distance;
        return new class_243(x + 0.5, (double)height, z + 0.5);
    }

    public float getSpinUp(Easing easing) {
        if (this.spiritYLevel > 30.0f) {
            return 1.0f;
        }
        return easing.ease(this.spiritYLevel / 30.0f, 0.0f, 1.0f, 1.0f);
    }

    public class_243 spiritOffset(int slot, float tickDelta) {
        float distance = 1.0f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + (float)Math.sin(this.spiritSpin / 20.0f) * 0.025f;
        float height = 0.75f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.5f;
        return SpiritAltarBlockEntity.rotatedCirclePosition(new class_243(0.5, (double)height, 0.5), distance, slot, this.spiritAmount, (long)this.spiritSpin, 360.0f, tickDelta);
    }

    public static class_243 rotatedCirclePosition(class_243 pos, float distance, float current, float total, long gameTime, float time, float tickDelta) {
        return SpiritAltarBlockEntity.rotatedCirclePosition(pos, distance, distance, current, total, gameTime, time, tickDelta);
    }

    public static class_243 rotatedCirclePosition(class_243 pos, float distanceX, float distanceZ, float current, float total, long gameTime, float time, float tickDelta) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distanceX * Math.cos(angle += (double)(((float)gameTime % time + tickDelta) / time) * (Math.PI * 2));
        double dz2 = (double)distanceZ * Math.sin(angle);
        class_243 vector2f = new class_243(dx2, 0.0, dz2);
        double x = vector2f.field_1352 * (double)distanceX;
        double z = vector2f.field_1350 * (double)distanceZ;
        return pos.method_1031(x, 0.0, z);
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.field_11867;
        return new class_238((double)(pos.method_10263() - 1), (double)pos.method_10264(), (double)(pos.method_10260() - 1), (double)(pos.method_10263() + 2), (double)(pos.method_10264() + 2), (double)(pos.method_10260() + 2));
    }
}

